/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.ContinousChisels;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.MCMultipartProxy;
import mod.chiselsandbits.interfaces.IItemScrollWheel;
import mod.chiselsandbits.interfaces.IPatternItem;
import mod.chiselsandbits.interfaces.IVoxelBlobItem;
import mod.chiselsandbits.items.ItemChisel;
import mod.chiselsandbits.network.NetworkRouter;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemNegativePrint
extends Item
implements IVoxelBlobItem,
IItemScrollWheel,
IPatternItem {
    SimpleInstanceCache<ItemStack, List<String>> toolTipCache = new SimpleInstanceCache(null, new ArrayList());

    @SideOnly(value=Side.CLIENT)
    protected void defaultAddInfo(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, worldIn, tooltip, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        this.defaultAddInfo(stack, worldIn, tooltip, advanced);
        ChiselsAndBits.getConfig().helpText(LocalStrings.HelpNegativePrint, tooltip, ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G), ClientSide.instance.getKeyName(Minecraft.func_71410_x().field_71474_y.field_74313_G));
        if (this.isWritten(stack)) {
            if (ClientSide.instance.holdingShift()) {
                List<String> details = this.toolTipCache.getCached();
                if (this.toolTipCache.needsUpdate(stack)) {
                    details.clear();
                    VoxelBlob blob = ModUtil.getBlobFromStack(stack, null);
                    int solid = blob.filled();
                    int air = blob.air();
                    if (solid > 0) {
                        details.add(solid + " " + LocalStrings.Filled.getLocal());
                    }
                    if (air > 0) {
                        details.add(air + " " + LocalStrings.Empty.getLocal());
                    }
                }
                tooltip.addAll(details);
            } else {
                tooltip.add(LocalStrings.ShiftDetails.getLocal());
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        if (this.isWritten(stack)) {
            return super.func_77667_c(stack) + "_written";
        }
        return super.func_77667_c(stack);
    }

    @Override
    public boolean isWritten(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            boolean a = ModUtil.getSubCompound(stack, "BlockEntityTag", false) != null;
            boolean b = ModUtil.getTagCompound(stack).func_74764_b("v");
            boolean c = ModUtil.getTagCompound(stack).func_74764_b("X");
            return a || b || c;
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        IBlockState blkstate = world.func_180495_p(pos);
        if (!player.func_175151_a(pos, side, stack) || !world.func_175660_a(player, pos)) {
            return EnumActionResult.FAIL;
        }
        if (!this.isWritten(stack)) {
            NBTTagCompound comp = this.getCompoundFromBlock(world, pos, player);
            if (comp != null) {
                stack.func_77982_d(comp);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te == null && !BlockChiseled.replaceWithChisled(world, pos, blkstate, true) && !MCMultipartProxy.proxyMCMultiPart.isMultiPartTileEntity(world, pos)) {
            return EnumActionResult.FAIL;
        }
        TileEntityBlockChiseled tec = ModUtil.getChiseledTileEntity(world, pos, true);
        if (tec != null) {
            VoxelBlob vb = tec.getBlob();
            VoxelBlob pattern = ModUtil.getBlobFromStack(stack, (EntityLivingBase)player);
            this.applyPrint(stack, world, pos, side, vb, pattern, player, hand);
            tec.completeEditOperation(vb);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    protected boolean convertToStone() {
        return true;
    }

    protected NBTTagCompound getCompoundFromBlock(World world, BlockPos pos, EntityPlayer player) {
        TileEntityBlockChiseled te = ModUtil.getChiseledTileEntity(world, pos, false);
        if (te != null) {
            NBTTagCompound comp = new NBTTagCompound();
            te.writeChisleData(comp);
            if (this.convertToStone()) {
                TileEntityBlockChiseled tmp = new TileEntityBlockChiseled();
                tmp.readChisleData(comp);
                VoxelBlob bestBlob = tmp.getBlob();
                bestBlob.binaryReplacement(0, ModUtil.getStateId(Blocks.field_150348_b.func_176223_P()));
                tmp.setBlob(bestBlob);
                tmp.writeChisleData(comp);
            }
            comp.func_74774_a("side", (byte)ModUtil.getPlaceFace((EntityLivingBase)player).ordinal());
            return comp;
        }
        return null;
    }

    @Override
    public ItemStack getPatternedItem(ItemStack stack, boolean craftingBlocks) {
        if (!this.isWritten(stack)) {
            return null;
        }
        NBTTagCompound tag = ModUtil.getTagCompound(stack);
        NBTBlobConverter conv = new NBTBlobConverter();
        conv.readChisleData(tag, -1);
        if (craftingBlocks && ChiselsAndBits.getConfig().fullBlockCrafting) {
            IBlockState state;
            ItemStack is;
            VoxelBlob.BlobStats stats = conv.getBlob().getVoxelStats();
            if (stats.isFullBlock && !ModUtil.isEmpty(is = ModUtil.getItemFromBlock(state = ModUtil.getStateById(stats.mostCommonState)))) {
                return is;
            }
        }
        IBlockState state = conv.getPrimaryBlockState();
        ItemStack itemstack = new ItemStack((Block)ChiselsAndBits.getBlocks().getConversionWithDefault(state), 1);
        itemstack.func_77983_a("BlockEntityTag", (NBTBase)tag);
        return itemstack;
    }

    protected void applyPrint(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, @Nonnull VoxelBlob vb, @Nonnull VoxelBlob pattern, @Nonnull EntityPlayer who, @Nonnull EnumHand hand) {
        ActingPlayer player = ActingPlayer.actingAs(who, hand);
        ContinousChisels selected = new ContinousChisels(player, pos, side);
        ItemStack spawnedItem = null;
        ArrayList<EntityItem> spawnlist = new ArrayList<EntityItem>();
        for (int z = 0; z < vb.detail && selected.isValid(); ++z) {
            for (int y = 0; y < vb.detail && selected.isValid(); ++y) {
                for (int x = 0; x < vb.detail && selected.isValid(); ++x) {
                    int blkID = vb.get(x, y, z);
                    if (blkID == 0 || pattern.get(x, y, z) != 0) continue;
                    spawnedItem = ItemChisel.chiselBlock(selected, player, vb, world, pos, side, x, y, z, spawnedItem, spawnlist);
                }
            }
        }
        for (EntityItem ei : spawnlist) {
            ModUtil.feedPlayer(world, who, ei);
        }
    }

    @Override
    public void scroll(EntityPlayer player, ItemStack stack, int dwheel) {
        PacketRotateVoxelBlob p = new PacketRotateVoxelBlob();
        p.rotationDirection = dwheel;
        NetworkRouter.instance.sendToServer(p);
    }

    @Override
    public void rotate(ItemStack stack, int rotationDirection) {
        EnumFacing side = ModUtil.getSide(stack);
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            side = EnumFacing.NORTH;
        }
        side = rotationDirection > 0 ? side.func_176746_e() : side.func_176735_f();
        ModUtil.setSide(stack, side);
    }
}

