/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.client.render;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTileIWConnectable
extends FastTESR<TileEntityImmersiveConnectable> {
    public void renderTileEntityFast(TileEntityImmersiveConnectable te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        Set outputs = ImmersiveNetHandler.INSTANCE.getConnections(te.func_145831_w(), Utils.toCC((Object)te));
        if (outputs != null) {
            Vec3d tilePosVec = new Vec3d(x, y, z);
            for (ImmersiveNetHandler.Connection con : outputs) {
                TileEntity tileEnd = te.func_145831_w().func_175625_s(con.end);
                if (!(tileEnd instanceof IImmersiveConnectable)) continue;
                if (te.func_174877_v().func_177986_g() > tileEnd.func_174877_v().func_177986_g()) {
                    tilePosVec = tilePosVec.func_72441_c(0.001, 0.001, 0.001);
                }
                RenderTileIWConnectable.tessellateConnectionFast(con, (IImmersiveConnectable)te, ApiUtils.toIIC((Object)tileEnd, (World)te.func_145831_w()), con.cableType.getIcon(con), buffer, tilePosVec);
            }
        }
    }

    private static void tessellateConnectionFast(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, TextureAtlasSprite sprite, BufferBuilder buffer, Vec3d tilePos) {
        if (connection != null && start != null && end != null && connection.end != null && connection.start != null) {
            int col = connection.cableType.getColour(connection);
            double radius = connection.cableType.getRenderDiameter() / 2.0;
            int[] rgba = new int[]{col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, 255};
            Vec3d startOffset = start.getConnectionOffset(connection);
            Vec3d endOffset = end.getConnectionOffset(connection);
            if (startOffset == null) {
                startOffset = new Vec3d(0.5, 0.5, 0.5);
            }
            if (endOffset == null) {
                endOffset = new Vec3d(0.5, 0.5, 0.5);
            }
            double dx = (double)connection.end.func_177958_n() + endOffset.field_72450_a - ((double)connection.start.func_177958_n() + startOffset.field_72450_a);
            double dy = (double)connection.end.func_177956_o() + endOffset.field_72448_b - ((double)connection.start.func_177956_o() + startOffset.field_72448_b);
            double dz = (double)connection.end.func_177952_p() + endOffset.field_72449_c - ((double)connection.start.func_177952_p() + startOffset.field_72449_c);
            double dw = Math.sqrt(dx * dx + dz * dz);
            World world = ((TileEntity)start).func_145831_w();
            double rmodx = dz / dw;
            double rmodz = dx / dw;
            Vec3d[] vertex = connection.getSubVertices(world);
            Vec3d initPos = new Vec3d(startOffset.field_72450_a, startOffset.field_72448_b, startOffset.field_72449_c);
            double uMin = sprite.func_94209_e();
            double uMax = sprite.func_94212_f();
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94210_h();
            boolean vertical = connection.end.func_177958_n() == connection.start.func_177958_n() && connection.end.func_177952_p() == connection.start.func_177952_p();
            boolean runBackwards = dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0;
            Vec3d tilePosVec = new Vec3d((Vec3i)((TileEntity)start).func_174877_v());
            if (vertical) {
                buffer.func_178969_c(tilePos.field_72450_a + initPos.field_72450_a, tilePos.field_72448_b + initPos.field_72448_b, tilePos.field_72449_c + initPos.field_72449_c);
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0 - radius, 0.0, 0.0).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx - radius, dy, dz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx + radius, dy, dz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0 + radius, 0.0, 0.0).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx - radius, dy, dz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0 - radius, 0.0, 0.0).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0 + radius, 0.0, 0.0).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx + radius, dy, dz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0, 0.0, 0.0 - radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx, dy, dz - radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx, dy, dz + radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0, 0.0, 0.0 + radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx, dy, dz - radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0, 0.0, 0.0 - radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(0.0, 0.0, 0.0 + radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), tilePosVec).func_181675_d();
                RenderTileIWConnectable.setLightmap(buffer.func_181662_b(dx, dy, dz + radius).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), tilePosVec).func_181675_d();
                buffer.func_178969_c(0.0, 0.0, 0.0);
            } else {
                int i;
                int n = i = runBackwards ? vertex.length - 1 : 0;
                while (!(!runBackwards ? i >= vertex.length : i < 0)) {
                    Vec3d v0 = i > 0 ? vertex[i - 1].func_178786_a((double)connection.start.func_177958_n(), (double)connection.start.func_177956_o(), (double)connection.start.func_177952_p()) : initPos;
                    Vec3d v1 = vertex[i].func_178786_a((double)connection.start.func_177958_n(), (double)connection.start.func_177956_o(), (double)connection.start.func_177952_p());
                    buffer.func_178969_c(tilePos.field_72450_a, tilePos.field_72448_b, tilePos.field_72449_c);
                    Vec3d shiftV0 = v0.func_178787_e(tilePosVec);
                    Vec3d shiftV1 = v1.func_178787_e(tilePosVec);
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a, v1.field_72448_b + radius, v1.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a, v0.field_72448_b + radius, v0.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a, v0.field_72448_b - radius, v0.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a, v1.field_72448_b - radius, v1.field_72449_c).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a - radius * rmodx, v1.field_72448_b, v1.field_72449_c + radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMax), shiftV1).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a - radius * rmodx, v0.field_72448_b, v0.field_72449_c + radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMax), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v0.field_72450_a + radius * rmodx, v0.field_72448_b, v0.field_72449_c - radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMax, vMin), shiftV0).func_181675_d();
                    RenderTileIWConnectable.setLightmap(buffer.func_181662_b(v1.field_72450_a + radius * rmodx, v1.field_72448_b, v1.field_72449_c - radius * rmodz).func_181669_b(rgba[0], rgba[1], rgba[2], rgba[3]).func_187315_a(uMin, vMin), shiftV1).func_181675_d();
                    buffer.func_178969_c(0.0, 0.0, 0.0);
                    i += runBackwards ? -1 : 1;
                }
            }
        }
    }

    private static BufferBuilder setLightmap(BufferBuilder buffer, Vec3d pos) {
        BlockPos bPos = new BlockPos(pos);
        int bright = Minecraft.func_71410_x().field_71441_e.func_175626_b(bPos, 0);
        int bX = bright >> 16 & 0xFFFF;
        int bY = bright & 0xFFFF;
        buffer.func_187314_a(bX, bY);
        return buffer;
    }
}

