/*
 * Decompiled with CFR 0.152.
 */
package de.sanandrew.mods.immersivecables.tileentity.ae;

import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import de.sanandrew.mods.immersivecables.block.ae2.BlockTransformerFluix;
import de.sanandrew.mods.immersivecables.block.ae2.FluixType;
import de.sanandrew.mods.immersivecables.tileentity.ae.TileFluixConnectable;
import de.sanandrew.mods.immersivecables.util.ICConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTransformerFluix
extends TileFluixConnectable {
    private boolean isActive;

    @Override
    public double getIdlePowerUsage() {
        return this.getType() == FluixType.FLUIX_DENSE ? (double)ICConfiguration.ae2DenseTransformerPowerDrain : (double)ICConfiguration.ae2FluixTransformerPowerDrain;
    }

    @Override
    public EnumSet<EnumFacing> getConnectableSides() {
        return EnumSet.of(this.getFacing().func_176734_d());
    }

    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        return this.getType().wireType == cableType && this.limitType == null;
    }

    @Override
    public GridFlags[] getFlags() {
        return this.getType().flags;
    }

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return this.getType().cableType;
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing facing = this.getFacing();
        return new Vec3d(0.5 + (double)facing.func_82601_c() * 0.5, 0.5 + (double)facing.func_96559_d() * 0.5, 0.5 + (double)facing.func_82599_e() * 0.5);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing facing = this.getFacing();
        return new Vec3d(0.5 + (double)facing.func_82601_c() * 0.4, 0.5 + (double)facing.func_96559_d() * 0.4, 0.5 + (double)facing.func_82599_e() * 0.4);
    }

    @Override
    public void gridChanged() {
        super.gridChanged();
        this.updateOnGridChange(false);
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.updateOnGridChange(true);
    }

    @MENetworkEventSubscribe
    public void channelUpdated(MENetworkChannelsChanged c) {
        this.updateOnGridChange(true);
    }

    public boolean isMeActive() {
        return this.isActive;
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.isActive = pkt.func_148857_g().func_74767_n("meActive");
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockTransformerFluix.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 3);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        this.writeCustomNBT(nbt, true);
        nbt.func_74757_a("meActive", this.proxy.getNode() != null && this.proxy.getNode().isActive());
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74757_a("meActive", this.proxy.getNode() != null && this.proxy.getNode().isActive());
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.isActive = tag.func_74767_n("meActive");
    }

    private FluixType getType() {
        return this.field_145850_b.func_175623_d(this.field_174879_c) ? FluixType.FLUIX : (FluixType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(FluixType.TYPE));
    }

    private void updateOnGridChange(boolean force) {
        if (!this.field_145850_b.field_72995_K && !this.field_145850_b.func_175623_d(this.field_174879_c)) {
            boolean prevActive = this.isActive;
            boolean bl = this.isActive = this.proxy.getNode() != null && this.proxy.getNode().isActive();
            if (prevActive != this.isActive || force) {
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockTransformerFluix.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 3);
            }
        }
    }

    public List<AxisAlignedBB> getAdvancedSelectionBounds() {
        if (this.cachedSelectionBounds == null) {
            EnumFacing facing = this.getFacing();
            switch (facing) {
                case UP: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.3125, 0.5625, 0.3125, 0.6875, 1.0, 0.6875).func_186670_a(this.field_174879_c));
                    break;
                }
                case DOWN: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.0, 0.4375, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.4375, 0.6875).func_186670_a(this.field_174879_c));
                    break;
                }
                case NORTH: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.4375).func_186670_a(this.field_174879_c));
                    break;
                }
                case SOUTH: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.3125, 0.3125, 0.5625, 0.6875, 0.6875, 1.0).func_186670_a(this.field_174879_c));
                    break;
                }
                case EAST: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.5625, 0.3125, 0.3125, 1.0, 0.6875, 0.6875).func_186670_a(this.field_174879_c));
                    break;
                }
                case WEST: {
                    this.cachedSelectionBounds = Arrays.asList(new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c), new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.4375, 0.6875, 0.6875).func_186670_a(this.field_174879_c));
                }
            }
        }
        return this.cachedSelectionBounds;
    }
}

