/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.network;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import baubles.common.Baubles;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSync
implements IMessage {
    int playerId;
    byte slot = 0;
    ItemStack bauble;

    public PacketSync() {
    }

    public PacketSync(EntityPlayer p, int slot) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler(p);
        this.slot = (byte)slot;
        this.bauble = baubles.getStackInSlot(slot);
        this.playerId = p.func_145782_y();
        baubles.setChanged(slot, false);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.playerId);
        buffer.writeByte((int)this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.bauble);
    }

    public void fromBytes(ByteBuf buffer) {
        this.playerId = buffer.readInt();
        this.slot = buffer.readByte();
        this.bauble = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    public static class Handler
    implements IMessageHandler<PacketSync, IMessage> {
        public IMessage onMessage(final PacketSync message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    World world = Baubles.proxy.getClientWorld();
                    if (world == null) {
                        return;
                    }
                    Entity p = world.func_73045_a(message.playerId);
                    if (p != null && p instanceof EntityPlayer) {
                        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)p);
                        baubles.setStackInSlot(message.slot, message.bauble);
                    }
                }
            });
            return null;
        }
    }
}

