/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import cofh.api.item.IToolHammer;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.McJtyRegister;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.BaseBlock;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.container.GenericItemBlock;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.WrenchUsage;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WrenchChecker;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public abstract class GenericBlock<T extends GenericTileEntity, C extends Container>
extends BaseBlock
implements ITileEntityProvider,
IRedstoneConnectable {
    protected final Class<? extends T> tileEntityClass;
    private final Class<? extends C> containerClass;

    public GenericBlock(ModBase mod, Material material, Class<? extends T> tileEntityClass, Class<? extends C> containerClass, String name, boolean isContainer) {
        this(mod, material, tileEntityClass, containerClass, GenericItemBlock.class, name, isContainer);
    }

    public GenericBlock(ModBase mod, Material material, Class<? extends T> tileEntityClass, Class<? extends C> containerClass, Class<? extends ItemBlock> itemBlockClass, String name, boolean isContainer) {
        super(mod, material, name, itemBlockClass);
        this.field_149758_A = isContainer;
        this.tileEntityClass = tileEntityClass;
        this.containerClass = containerClass;
        McJtyRegister.registerLater(this, tileEntityClass);
    }

    public boolean needsRedstoneCheck() {
        return false;
    }

    public boolean hasRedstoneOutput() {
        return false;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return this.needsRedstoneCheck() || this.hasRedstoneOutput();
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return -1;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.hasRedstoneOutput();
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && !world.field_72995_K) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockBreak(world, pos, state);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        BlockPos pos = data.getPos();
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            if (blockState.func_177230_c() instanceof Infusable) {
                int infused = genericTileEntity.getInfused();
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                probeInfo.text(TextFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if (mode == ProbeMode.EXTENDED && GeneralConfig.manageOwnership && genericTileEntity.getOwnerName() != null && !genericTileEntity.getOwnerName().isEmpty()) {
                int securityChannel = genericTileEntity.getSecurityChannel();
                if (securityChannel == -1) {
                    probeInfo.text(TextFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName());
                } else {
                    probeInfo.text(TextFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName() + " (channel " + securityChannel + ")");
                }
                if (genericTileEntity.getOwnerUUID() == null) {
                    probeInfo.text(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        currenttip = super.getWailaBody(itemStack, currenttip, accessor, config);
        Block block = accessor.getBlock();
        TileEntity tileEntity = accessor.getTileEntity();
        if (tileEntity instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)tileEntity;
            if (block instanceof Infusable) {
                int infused = genericTileEntity.getInfused();
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                currenttip.add(TextFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && GeneralConfig.manageOwnership && genericTileEntity.getOwnerName() != null && !genericTileEntity.getOwnerName().isEmpty()) {
                int securityChannel = genericTileEntity.getSecurityChannel();
                if (securityChannel == -1) {
                    currenttip.add(TextFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName());
                } else {
                    currenttip.add(TextFormatting.YELLOW + "Owned by: " + genericTileEntity.getOwnerName() + " (channel " + securityChannel + ")");
                }
                if (genericTileEntity.getOwnerUUID() == null) {
                    currenttip.add(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
        return currenttip;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        this.intAddInformation(stack, tooltip);
    }

    private void intAddInformation(ItemStack itemStack, List<String> list) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            if (tagCompound.func_74764_b("Energy")) {
                int energy = tagCompound.func_74762_e("Energy");
                list.add(TextFormatting.GREEN + "Energy: " + energy + " rf");
            }
            if (this instanceof Infusable) {
                int infused = tagCompound.func_74762_e("infused");
                int pct = infused * 100 / GeneralConfig.maxInfuse;
                list.add(TextFormatting.YELLOW + "Infused: " + pct + "%");
            }
            if (GeneralConfig.manageOwnership && tagCompound.func_74764_b("owner")) {
                String owner = tagCompound.func_74779_i("owner");
                int securityChannel = -1;
                if (tagCompound.func_74764_b("secChannel")) {
                    securityChannel = tagCompound.func_74762_e("secChannel");
                }
                if (securityChannel == -1) {
                    list.add(TextFormatting.YELLOW + "Owned by: " + owner);
                } else {
                    list.add(TextFormatting.YELLOW + "Owned by: " + owner + " (channel " + securityChannel + ")");
                }
                if (!tagCompound.func_74764_b("idM")) {
                    list.add(TextFormatting.RED + "Warning! Ownership not correctly set! Please place block again!");
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.needsRedstoneCheck()) {
            this.checkRedstone(world, pos);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof GenericTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((GenericTileEntity)tileEntity).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            result.add(stack);
            return result;
        }
        return super.getDrops(world, pos, metadata, fortune);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public TileEntity func_149915_a(World world, int i) {
        return null;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        try {
            return (TileEntity)this.tileEntityClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private WrenchUsage testWrenchUsage(BlockPos pos, EntityPlayer player) {
        Item item;
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        WrenchUsage wrenchUsed = WrenchUsage.NOT;
        if (!itemStack.func_190926_b() && (item = itemStack.func_77973_b()) != null) {
            wrenchUsed = this.getWrenchUsage(pos, player, itemStack, wrenchUsed, item);
        }
        if (wrenchUsed == WrenchUsage.NORMAL && player.func_70093_af()) {
            wrenchUsed = WrenchUsage.SNEAKING;
        }
        return wrenchUsed;
    }

    private WrenchUsage getWrenchUsageInt(BlockPos pos, EntityPlayer player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        if (item instanceof IToolHammer) {
            IToolHammer hammer = (IToolHammer)item;
            if (hammer.isUsable(itemStack, (EntityLivingBase)player, pos)) {
                hammer.toolUsed(itemStack, (EntityLivingBase)player, pos);
                wrenchUsed = WrenchUsage.NORMAL;
            } else {
                wrenchUsed = WrenchUsage.DISABLED;
            }
        } else if (WrenchChecker.isAWrench(item)) {
            wrenchUsed = WrenchUsage.NORMAL;
        }
        return wrenchUsed;
    }

    protected WrenchUsage getWrenchUsage(BlockPos pos, EntityPlayer player, ItemStack itemStack, WrenchUsage wrenchUsed, Item item) {
        SmartWrench smartWrench;
        SmartWrenchMode mode;
        WrenchUsage usage = this.getWrenchUsageInt(pos, player, itemStack, wrenchUsed, item);
        if (item instanceof IToolHammer && usage == WrenchUsage.DISABLED && item instanceof SmartWrench && (mode = (smartWrench = (SmartWrench)item).getMode(itemStack)).equals((Object)SmartWrenchMode.MODE_SELECT)) {
            usage = player.func_70093_af() ? WrenchUsage.SNEAK_SELECT : WrenchUsage.SELECT;
        }
        return usage;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.handleModule(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        WrenchUsage wrenchUsed = this.testWrenchUsage(pos, player);
        switch (wrenchUsed) {
            case NOT: {
                return this.openGui(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
            }
            case NORMAL: {
                return this.wrenchUse(world, pos, side, player);
            }
            case SNEAKING: {
                return this.wrenchSneak(world, pos, player);
            }
            case DISABLED: {
                return this.wrenchDisabled(world, pos, player);
            }
            case SELECT: {
                return this.wrenchSelect(world, pos, player);
            }
            case SNEAK_SELECT: {
                return this.wrenchSneakSelect(world, pos, player);
            }
        }
        return false;
    }

    protected IModuleSupport getModuleSupport() {
        return null;
    }

    public boolean handleModule(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IModuleSupport support;
        return !heldItem.func_190926_b() && (support = this.getModuleSupport()) != null && support.isModule(heldItem) && InventoryHelper.installModule(player, heldItem, hand, pos, support.getFirstSlot(), support.getLastSlot());
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        this.rotateBlock(world, pos, EnumFacing.UP);
        return true;
    }

    protected boolean wrenchSneak(World world, BlockPos pos, EntityPlayer player) {
        this.breakAndRemember(world, player, pos);
        return true;
    }

    protected boolean wrenchDisabled(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSelect(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean wrenchSneakSelect(World world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (this.getGuiID() != -1) {
            if (world.field_72995_K) {
                return true;
            }
            TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
            if (this.checkAccess(world, player, te)) {
                return true;
            }
            player.openGui((Object)this.modBase, this.getGuiID(), world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        this.restoreBlockFromNBT(world, pos, stack);
        if (!world.field_72995_K && GeneralConfig.manageOwnership) {
            this.setOwner(world, pos, placer);
        }
        if ((te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.onBlockPlacedBy(world, pos, state, placer, stack);
        }
    }

    protected void setOwner(World world, BlockPos pos, EntityLivingBase entityLivingBase) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity && entityLivingBase instanceof EntityPlayer) {
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            genericTileEntity.setOwner(player);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    protected void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GenericTileEntity) {
            int powered = world.func_175687_A(pos);
            GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            genericTileEntity.setPowerInput(powered);
        }
    }

    protected void breakAndRemember(World world, EntityPlayer player, BlockPos pos) {
        if (!world.field_72995_K) {
            this.func_180657_a(world, player, pos, world.func_180495_p(pos), world.func_175625_s(pos), ItemStack.field_190927_a);
        }
    }

    protected void restoreBlockFromNBT(World world, BlockPos pos, ItemStack itemStack) {
        TileEntity te;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && (te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            ((GenericTileEntity)te).readRestorableFromNBT(tagCompound);
        }
    }

    public abstract int getGuiID();

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        if (this.field_149758_A) {
            super.func_189539_a(state, worldIn, pos, id, param);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            return tileentity == null ? false : tileentity.func_145842_c(id, param);
        }
        return super.func_189539_a(state, worldIn, pos, id, param);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        GenericTileEntity inventory = (GenericTileEntity)tileEntity;
        try {
            Constructor<C> constructor = this.containerClass.getConstructor(EntityPlayer.class, IInventory.class);
            Container container = (Container)constructor.newInstance(entityPlayer, inventory instanceof IInventory ? (IInventory)inventory : null);
            Constructor<GenericGuiContainer> guiConstructor = this.getGuiClass().getConstructor(this.tileEntityClass, this.containerClass);
            GenericGuiContainer gui = guiConstructor.newInstance(inventory, container);
            return gui;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Logging.logError("Severe exception during creation of gui!");
            throw new RuntimeException(e);
        }
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        GenericTileEntity inventory = (GenericTileEntity)tileEntity;
        try {
            Constructor<C> constructor = this.containerClass.getConstructor(EntityPlayer.class, IInventory.class);
            Container container = (Container)constructor.newInstance(entityPlayer, inventory instanceof IInventory ? (IInventory)inventory : null);
            return container;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Logging.logError("Severe exception during creation of gui!");
            throw new RuntimeException(e);
        }
    }

    protected boolean checkAccess(World world, EntityPlayer player, TileEntity te) {
        return false;
    }
}

