/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.entity;

import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.entity.McJtyEnergyStorage;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.network.PacketRequestIntegerFromServer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GenericEnergyStorageTileEntity
extends GenericTileEntity {
    public static final String CMD_GETENERGY = "getEnergy";
    public static final String CLIENTCMD_GETENERGY = "getEnergy";
    protected McJtyEnergyStorage storage;
    private static int currentRF = 0;
    private int requestRfDelay = 3;

    public void modifyEnergyStored(int energy) {
        this.storage.modifyEnergyStored(energy);
    }

    public GenericEnergyStorageTileEntity(int maxEnergy, int maxReceive) {
        this.storage = new McJtyEnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
    }

    public GenericEnergyStorageTileEntity(int maxEnergy, int maxReceive, int maxExtract) {
        this.storage = new McJtyEnergyStorage(maxEnergy);
        this.storage.setMaxReceive(maxReceive);
        this.storage.setMaxExtract(maxExtract);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.storage.readFromNBT(tagCompound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.storage.writeToNBT(tagCompound);
    }

    public static int getCurrentRF() {
        return currentRF;
    }

    public static void setCurrentRF(int currentRF) {
        GenericEnergyStorageTileEntity.currentRF = currentRF;
    }

    public void requestRfFromServer(String modid) {
        --this.requestRfDelay;
        if (this.requestRfDelay > 0) {
            return;
        }
        this.requestRfDelay = 3;
        PacketHandler.modNetworking.get(modid).sendToServer((IMessage)new PacketRequestIntegerFromServer(modid, this.field_174879_c, "getEnergy", "getEnergy", new Argument[0]));
    }

    @Override
    public Integer executeWithResultInteger(String command, Map<String, Argument> args) {
        Integer rc = super.executeWithResultInteger(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getEnergy".equals(command)) {
            return this.storage.getEnergyStored();
        }
        return null;
    }

    @Override
    public boolean execute(String command, Integer result) {
        boolean rc = super.execute(command, result);
        if (rc) {
            return true;
        }
        if ("getEnergy".equals(command)) {
            GenericEnergyStorageTileEntity.setCurrentRF(result);
            return true;
        }
        return false;
    }
}

