/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class AbstractContainerWidget<P extends AbstractContainerWidget<P>>
extends AbstractWidget<P> {
    protected List<Widget> children = new ArrayList<Widget>();

    public AbstractContainerWidget(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.markDirty();
        super.setBounds(bounds);
    }

    @Override
    public Widget getWidgetAtPosition(int x, int y) {
        x -= this.bounds.x;
        y -= this.bounds.y;
        for (Widget child : this.children) {
            if (!child.in(x, y) || !child.isVisible()) continue;
            return child.getWidgetAtPosition(x, y);
        }
        return this;
    }

    @Override
    public boolean mouseWheel(int amount, int x, int y) {
        x -= this.bounds.x;
        y -= this.bounds.y;
        for (Widget child : this.children) {
            if (!child.in(x, y) || !child.isVisible() || !child.mouseWheel(amount, x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsWidget(Widget w) {
        if (w == this) {
            return true;
        }
        for (Widget child : this.children) {
            if (!child.containsWidget(w)) continue;
            return true;
        }
        return false;
    }

    public P addChild(Widget child) {
        if (child == null) {
            throw new RuntimeException("THIS IS NOT POSSIBLE!");
        }
        this.children.add(child);
        this.markDirty();
        return (P)this;
    }

    public P removeChild(Widget child) {
        this.children.remove(child);
        this.markDirty();
        return (P)this;
    }

    public void removeChildren() {
        this.children.clear();
        this.markDirty();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public Widget getChild(int index) {
        return this.children.get(index);
    }
}

