/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Keyboard;

public class ChoiceLabel
extends Label<ChoiceLabel> {
    private List<String> choiceList = new ArrayList<String>();
    private Map<String, List<String>> tooltipMap = new HashMap<String, List<String>>();
    private String currentChoice = null;
    private List<ChoiceEvent> choiceEvents = null;

    public ChoiceLabel(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setText("");
    }

    public ChoiceLabel addChoices(String ... choices) {
        for (String choice : choices) {
            this.choiceList.add(choice);
            if (this.currentChoice != null) continue;
            this.currentChoice = choice;
            this.setText(this.currentChoice);
            this.fireChoiceEvents(this.currentChoice);
        }
        return this;
    }

    public ChoiceLabel setChoiceTooltip(String choice, String ... tooltips) {
        this.tooltipMap.put(choice, Arrays.asList(tooltips));
        return this;
    }

    public ChoiceLabel setChoice(String choice) {
        this.currentChoice = choice;
        this.setText(this.currentChoice);
        return this;
    }

    public String getCurrentChoice() {
        return this.currentChoice;
    }

    @Override
    public List<String> getTooltips() {
        List<String> tooltips = this.tooltipMap.get(this.currentChoice);
        if (tooltips == null) {
            return super.getTooltips();
        }
        return tooltips;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            if (this.isHovering()) {
                this.drawStyledBoxHovering(window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            } else {
                this.drawStyledBoxNormal(window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            }
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleNormal);
        } else {
            this.drawStyledBoxDisabled(window, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            RenderHelper.drawLeftTriangle(xx + this.bounds.width - 10, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
            RenderHelper.drawRightTriangle(xx + this.bounds.width - 4, yy + this.bounds.height / 2, StyleConfig.colorCycleButtonTriangleDisabled);
        }
        super.drawOffset(window, x, y, -3, 1);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            if (this.choiceList.isEmpty()) {
                return null;
            }
            int index = this.choiceList.indexOf(this.currentChoice);
            if (button == 1 || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (--index < 0) {
                    index = this.choiceList.size() - 1;
                }
            } else if (++index >= this.choiceList.size()) {
                index = 0;
            }
            this.currentChoice = this.choiceList.get(index);
            this.setText(this.currentChoice);
            this.fireChoiceEvents(this.currentChoice);
        }
        return null;
    }

    public ChoiceLabel addChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ChoiceEvent>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ChoiceEvent event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(String choice) {
        if (this.choiceEvents != null) {
            for (ChoiceEvent event : this.choiceEvents) {
                event.choiceChanged(this, choice);
            }
        }
    }
}

