/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.network.ArgumentType;
import mcjty.lib.network.NetworkTools;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class Arguments {
    private final List<Pair<ArgumentType, Object>> parameters;
    private int idx = 0;
    public static final Arguments EMPTY = Arguments.builder().build();

    private Arguments(Builder builder) {
        this.parameters = builder.parameters;
    }

    public Arguments(ByteBuf buf) {
        this.parameters = new ArrayList<Pair<ArgumentType, Object>>();
        int size = buf.readInt();
        block8: for (int i = 0; i < size; ++i) {
            ArgumentType type = ArgumentType.getType(buf.readByte());
            switch (type) {
                case TYPE_STRING: {
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)NetworkTools.readStringUTF8(buf)));
                    continue block8;
                }
                case TYPE_INTEGER: {
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)buf.readInt()));
                    continue block8;
                }
                case TYPE_BLOCKPOS: {
                    int cx = buf.readInt();
                    int cy = buf.readInt();
                    int cz = buf.readInt();
                    if (cx == -1 && cy == -1 && cz == -1) {
                        this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), null));
                        continue block8;
                    }
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)new BlockPos(cx, cy, cz)));
                    continue block8;
                }
                case TYPE_BOOLEAN: {
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)(buf.readByte() == 1 ? 1 : 0)));
                    continue block8;
                }
                case TYPE_DOUBLE: {
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)buf.readDouble()));
                    continue block8;
                }
                case TYPE_STACK: {
                    if (buf.readBoolean()) {
                        this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)NetworkTools.readItemStack(buf)));
                        continue block8;
                    }
                    this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)type), (Object)ItemStack.field_190927_a));
                }
            }
        }
    }

    public void reset() {
        this.idx = 0;
    }

    private void checkType(ArgumentType type) {
        if (this.parameters.get(this.idx).getKey() != type) {
            throw new RuntimeException("Bad argument type at position " + this.idx);
        }
    }

    public int getInt() {
        this.checkType(ArgumentType.TYPE_INTEGER);
        return (Integer)this.parameters.get(this.idx++).getValue();
    }

    public double getDouble() {
        this.checkType(ArgumentType.TYPE_DOUBLE);
        return (Double)this.parameters.get(this.idx++).getValue();
    }

    public boolean getBoolean() {
        this.checkType(ArgumentType.TYPE_BOOLEAN);
        return (Boolean)this.parameters.get(this.idx++).getValue();
    }

    public BlockPos getBlockPos() {
        this.checkType(ArgumentType.TYPE_BLOCKPOS);
        return (BlockPos)this.parameters.get(this.idx++).getValue();
    }

    public ItemStack getItemStack() {
        this.checkType(ArgumentType.TYPE_STACK);
        return (ItemStack)this.parameters.get(this.idx++).getValue();
    }

    public String getString() {
        this.checkType(ArgumentType.TYPE_STRING);
        return (String)this.parameters.get(this.idx++).getValue();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.parameters.size());
        for (Pair<ArgumentType, Object> pair : this.parameters) {
            buf.writeByte(((ArgumentType)((Object)pair.getKey())).ordinal());
            Object arg = pair.getValue();
            switch ((ArgumentType)((Object)pair.getKey())) {
                case TYPE_STRING: {
                    NetworkTools.writeStringUTF8(buf, (String)arg);
                    break;
                }
                case TYPE_INTEGER: {
                    buf.writeInt(((Integer)arg).intValue());
                    break;
                }
                case TYPE_BLOCKPOS: {
                    BlockPos c = (BlockPos)arg;
                    if (c == null) {
                        buf.writeInt(-1);
                        buf.writeInt(-1);
                        buf.writeInt(-1);
                        break;
                    }
                    buf.writeInt(c.func_177958_n());
                    buf.writeInt(c.func_177956_o());
                    buf.writeInt(c.func_177952_p());
                    break;
                }
                case TYPE_BOOLEAN: {
                    buf.writeByte((Boolean)arg != false ? 1 : 0);
                    break;
                }
                case TYPE_DOUBLE: {
                    buf.writeDouble(((Double)arg).doubleValue());
                    break;
                }
                case TYPE_STACK: {
                    if (((ItemStack)arg).func_190926_b()) {
                        buf.writeBoolean(false);
                        break;
                    }
                    buf.writeBoolean(true);
                    NetworkTools.writeItemStack(buf, (ItemStack)arg);
                }
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final List<Pair<ArgumentType, Object>> parameters = new ArrayList<Pair<ArgumentType, Object>>();

        Builder() {
        }

        public Arguments build() {
            return new Arguments(this);
        }

        public Builder value(int i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_INTEGER), (Object)i));
            return this;
        }

        public Builder value(double i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_DOUBLE), (Object)i));
            return this;
        }

        public Builder value(boolean i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_BOOLEAN), (Object)i));
            return this;
        }

        public Builder value(ItemStack i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_STACK), (Object)i));
            return this;
        }

        public Builder value(BlockPos i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_BLOCKPOS), (Object)i));
            return this;
        }

        public Builder value(String i) {
            this.parameters.add((Pair<ArgumentType, Object>)Pair.of((Object)((Object)ArgumentType.TYPE_STRING), (Object)i));
            return this;
        }
    }
}

