/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.Map;
import mcjty.lib.network.Argument;
import mcjty.lib.network.PacketUpdateNBTItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUpdateNBTItemHandler<T extends PacketUpdateNBTItem>
implements IMessageHandler<T, IMessage> {
    public IMessage onMessage(T message, MessageContext ctx) {
        FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
        return null;
    }

    private void handle(T message, MessageContext ctx) {
        EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
        ItemStack heldItem = playerEntity.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (!((PacketUpdateNBTItem)message).isValidItem(heldItem)) {
            return;
        }
        NBTTagCompound tagCompound = heldItem.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            heldItem.func_77982_d(tagCompound);
        }
        for (Map.Entry<String, Argument> entry : ((PacketUpdateNBTItem)message).args.entrySet()) {
            String key = entry.getKey();
            switch (entry.getValue().getType()) {
                case TYPE_STRING: {
                    tagCompound.func_74778_a(key, entry.getValue().getString());
                    break;
                }
                case TYPE_INTEGER: {
                    tagCompound.func_74768_a(key, entry.getValue().getInteger().intValue());
                    break;
                }
                case TYPE_BLOCKPOS: {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                case TYPE_BOOLEAN: {
                    tagCompound.func_74757_a(key, entry.getValue().getBoolean());
                    break;
                }
                case TYPE_DOUBLE: {
                    tagCompound.func_74780_a(key, entry.getValue().getDouble().doubleValue());
                }
            }
        }
    }
}

