/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;

public class RecipeConverter {
    static final Pattern REGEX_PARAMS = Pattern.compile("\\((.*)\\)");
    static final String OUT_PATH = "convertedRecipes/";
    static final Gson GSON = new Gson();

    public static void main(String[] args) {
        String input = "\tRecipeSorter.register(ImmersiveEngineering.MODID+\":shapedIngredient\", RecipeShapedIngredient.class, Category.SHAPED, \"after:forge:shapedore\");\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":shapelessIngredient\", RecipeShapelessIngredient.class, Category.SHAPELESS, \"after:forge:shapedore\");\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":banners\", RecipeBannerAdvanced.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":RGBColour\", RecipeRGBColouration.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\t\tForgeRegistries.RECIPES.register(new RecipeBannerAdvanced().setRegistryName(ImmersiveEngineering.MODID, \"banners\"));\n\n\t\tItemStack copperCoil = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.COIL_LV.getMeta());\n\t\tItemStack electrumCoil = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.COIL_MV.getMeta());\n\t\tItemStack hvCoil = new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.COIL_HV.getMeta());\n\t\tItemStack componentIron = new ItemStack(IEContent.itemMaterial,1,8);\n\t\tItemStack componentSteel = new ItemStack(IEContent.itemMaterial,1,9);\n\t\tItemStack woodenGrip = new ItemStack(IEContent.itemMaterial,1,13);\n\t\tItemStack elecTube = new ItemStack(IEContent.itemMaterial,1,26);\n\t\tIngredient woodenSticks = new IngredientMultiOre(\"stickWood\", \"stickTreatedWood\");\n\t\tIngredient metalSticks = new IngredientMultiOre(\"stickIron\", \"stickAluminum\", \"stickSteel\");\n//\t\tItemStack[] cutters = new ItemStack[]{new ItemStack(IEContent.itemTool, 1, 1), new ItemStack(Items.SHEARS, 1, OreDictionary.WILDCARD_VALUE)};\n\t\tIngredient cutters = Ingredient.fromStacks(new ItemStack(IEContent.itemTool, 1, 1), new ItemStack(Items.SHEARS, 1, OreDictionary.WILDCARD_VALUE));\n\t\tItemStack baseConveyor = ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":conveyor\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,4,0), \"W\",\"W\", 'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,4,1), \"I\",\"I\", 'I',\"ingotIron\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,4,2), \"I\",\"I\", 'I',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,4,3), \"I\",\"I\", 'I',\"ingotAluminum\");\n\t\taddShapelessOredictRecipe(new ItemStack(Items.STRING), \"fiberHemp\",\"fiberHemp\",\"fiberHemp\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,5), \"HHH\",\"HSH\",\"HHH\", 'H',\"fiberHemp\", 'S',\"stickWood\");\n\t\taddOredictRecipe(componentIron, \"I I\",\" C \",\"I I\", 'I',\"plateIron\",'C',\"ingotCopper\");\n\t\taddOredictRecipe(componentSteel, \"I I\",\" C \",\"I I\", 'I',\"plateSteel\",'C',\"ingotCopper\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,10), \" S \",\"SBS\",\"BSB\", 'B',\"plankTreatedWood\", 'S',\"stickTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,11), \"BB \",\"SSB\",\"SS \", 'B',\"plankTreatedWood\", 'S',\"stickTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,12), \" CC\",\"CCC\",\" C \", 'C',\"fabricHemp\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,13), \"SS\",\"IS\",\"SS\", 'I',\"ingotCopper\",'S',\"stickTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,14), \"III\", 'I',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,15), \" I \",\"ICI\",\" I \", 'I',\"ingotSteel\",'C',componentIron);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,1,16), \"I  \",\"II \",\" II\", 'I',\"ingotSteel\");\n\n\t\taddShapelessIngredientRecipe(new ItemStack(IEContent.itemMaterial, 1, 20), \"plateCopper\", cutters).setToolDamageRecipe(1);\n\t\taddShapelessIngredientRecipe(new ItemStack(IEContent.itemMaterial, 1, 21), \"plateElectrum\", cutters).setToolDamageRecipe(1);\n\t\taddShapelessIngredientRecipe(new ItemStack(IEContent.itemMaterial, 1, 22), \"plateAluminum\", cutters).setToolDamageRecipe(1);\n\t\taddShapelessIngredientRecipe(new ItemStack(IEContent.itemMaterial, 1, 23), \"plateSteel\", cutters).setToolDamageRecipe(1);\n\n\t\taddShapelessOredictRecipe(new ItemStack(Items.GUNPOWDER,4), \"dustSaltpeter\",\"dustSaltpeter\",\"dustSaltpeter\",\"dustSaltpeter\",\"dustSulfur\",\"charcoal\");\n\t\tif(OreDictionary.doesOreNameExist(\"dustCharcoal\"))\n\t\t\taddShapelessOredictRecipe(new ItemStack(Items.GUNPOWDER,4), \"dustSaltpeter\",\"dustSaltpeter\",\"dustSaltpeter\",\"dustSaltpeter\",\"dustSulfur\",\"dustCharcoal\");\n\n\t\t//\t\taddOredictRecipe(new ItemStack(IEContent.itemMaterial,4,14), \"I\",\"I\", 'I',\"ingotIron\");\n\t\t//\t\taddOredrrictRecipe(new ItemStack(IEContent.itemMaterial,4,15), \"I\",\"I\", 'I',\"ingotSteel\");\n\n\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemTool, 1, 0), \" IF\", \" SI\", \"S  \", 'I', \"ingotIron\", 'S', woodenSticks, 'F', new ItemStack(Items.STRING));\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemTool, 1, 1), \"SI\", \" S\", 'I', \"ingotIron\", 'S', woodenSticks).setMirrored(true);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemTool, 1, 2), \" P \", \"SCS\", 'C', \"ingotCopper\", 'P', Items.COMPASS, 'S', woodenSticks);\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.itemTool,1,3), Items.BOOK,Blocks.LEVER);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemRevolver,1,0), \" I \",\"BDH\",\"GIG\", 'I',\"ingotIron\",'B',new ItemStack(IEContent.itemMaterial,1,14),'D',new ItemStack(IEContent.itemMaterial,1,15),'G',woodenGrip,'H',new ItemStack(IEContent.itemMaterial,1,16)).setMirrored(true);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemRevolver,1,1), \"  I\",\"IIS\",\"  I\", 'I',\"ingotIron\",'S',\"ingotSteel\");\n\t\tForgeRegistries.RECIPES.register(new RecipeRevolver().setRegistryName(ImmersiveEngineering.MODID, \"revolver_Loop\"));\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":revolverLoop\", RecipeRevolver.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemBullet,5,0), \"I I\",\"I I\",\" I \", 'I',\"ingotCopper\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemBullet,5,1), \"PDP\",\"PDP\",\" I \", 'I',\"ingotCopper\",'P',Items.PAPER,'D',\"dyeRed\");\n\t\taddOredictRecipe(BlueprintCraftingRecipe.getTypedBlueprint(\"bullet\"), \"JKL\",\"DDD\",\"PPP\", 'J',Items.GUNPOWDER,'K',\"ingotCopper\",'L',Items.GUNPOWDER, 'D',\"dyeBlue\",'P',Items.PAPER);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemMold,1,3), \" P \",\"PCP\",\" P \", 'P',\"plateSteel\",'C',new ItemStack(IEContent.itemBullet,1,0));\n\t\tMetalPressRecipe.addRecipe(new ItemStack(IEContent.itemBullet,2,0),\"ingotCopper\",new ItemStack(IEContent.itemMold,1,3), 2400);\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemSkyhook,1,0), \"II \",\"IC \",\" GG\", 'C',componentIron,'I',\"ingotSteel\", 'G',woodenGrip);\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemDrill,1,0), \"  G\",\" EG\",\"C  \", 'C',componentSteel,'E',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()), 'G',woodenGrip);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemDrillhead,1,0), \"SS \",\"BBS\",\"SS \", 'B',\"blockSteel\", 'S',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemDrillhead,1,1), \"SS \",\"BBS\",\"SS \", 'B',\"blockIron\", 'S',\"ingotIron\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemChemthrower,1,0), \" OG\",\" EG\",\"PB \", 'P',new ItemStack(IEContent.blockMetalDevice1,1,BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()), 'O',new ItemStack(IEContent.itemToolUpgrades,1,0), 'B',Items.BUCKET, 'E',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()), 'G',woodenGrip);\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemRailgun,1,0), \" HG\",\"CBH\",\"BC \", 'C',electrumCoil, 'H',new ItemStack(IEContent.blockMetalDevice0,1,BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()), 'B',new ItemStack(IEContent.itemMaterial,1,14), 'G',woodenGrip);\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1,ToolUpgrades.DRILL_WATERPROOF.ordinal()), \"BI \",\"IBI\",\" IC\", 'B',Items.BUCKET, 'I',\"dyeBlue\", 'C',componentIron);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemToolUpgrades, 1, ToolUpgrades.DRILL_LUBE.ordinal()), \"BI \", \"IBI\", \" IC\", 'B', new IngredientFluidStack(IEContent.fluidPlantoil, 1000), 'I', \"ingotIron\", 'C', componentIron);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.DRILL_DAMAGE.ordinal()), \"SSS\",\" C \", 'S',\"ingotSteel\", 'C',componentSteel);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.DRILL_CAPACITY.ordinal()), \"CS \",\"SBO\",\" OB\", 'C',componentIron, 'S',\"ingotSteel\", 'B',Items.BUCKET, 'O',\"dyeRed\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.REVOLVER_BAYONET.ordinal()), \"SI\",\"IW\", 'S',Items.IRON_SWORD, 'I',\"ingotSteel\", 'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.REVOLVER_MAGAZINE.ordinal()), \" CS\",\"C C\",\"IC \", 'I',componentIron, 'S',\"ingotSteel\", 'C',\"ingotCopper\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.REVOLVER_ELECTRO.ordinal()), \"TTT\",\"RWR\", 'T',elecTube, 'R',\"stickSteel\", 'W',\"wireCopper\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.CHEMTHROWER_FOCUS.ordinal()), \" SS\",\"PPH\",\" SS\", 'P',new ItemStack(IEContent.blockMetalDevice1,1,BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()), 'H',Blocks.HOPPER, 'S',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.RAILGUN_SCOPE.ordinal()), \"GC \",\"C C\",\" CG\", 'G',\"paneGlassColorless\", 'C',\"ingotCopper\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.RAILGUN_CAPACITORS.ordinal()), \"WWW\",\"HHH\", 'W',new ItemStack(IEContent.itemWireCoil,1,2), 'H',new ItemStack(IEContent.blockMetalDevice0,1,2));\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.SHIELD_FLASH.ordinal()), \"AGA\",\"GTG\", 'A',\"plateAluminum\", 'G',\"paneGlass\", 'T',elecTube);\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.SHIELD_SHOCK.ordinal()), \"CRC\",\"CRC\",\"CRC\", 'C',new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.CONNECTOR_LV.getMeta()), 'R',\"stickIron\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolUpgrades,1, ToolUpgrades.SHIELD_MAGNET.ordinal()), \"  L\",\"LC \",\"LIL\", 'L',\"leather\",'C',new ItemStack(IEContent.blockMetalDecoration0, 1, BlockTypes_MetalDecoration0.COIL_LV.getMeta()), 'I',\"ingotIron\");\n\n\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.itemMetal,2,15), \"dustCopper\",\"dustNickel\");\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.itemMetal,2,16), \"dustSilver\",\"dustGold\");\n\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 0), \" I \", \"ISI\", \" I \", 'I', \"wireCopper\", 'S', woodenSticks);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 1), \" I \", \"ISI\", \" I \", 'I', \"wireElectrum\", 'S', woodenSticks);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 2), \" I \", \"ASA\", \" I \", 'I', \"wireSteel\", 'A', \"wireAluminum\", 'S', woodenSticks).allowQuarterTurn();\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 3), \" I \", \"ISI\", \" I \", 'I', new ItemStack(IEContent.itemMaterial, 1, 4), 'S', woodenSticks);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 4), \" I \", \"ISI\", \" I \", 'I', \"wireSteel\", 'S', woodenSticks);\n\t\taddIngredientRecipe(new ItemStack(IEContent.itemWireCoil, 4, 5), \" I \", \"ASA\", \" I \", 'I', \"dustRedstone\", 'A', \"wireAluminum\", 'S', woodenSticks).allowQuarterTurn();\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemJerrycan), \" II\",\"IBB\",\"IBB\", 'I',\"plateIron\",'B',Items.BUCKET);\n\t\tForgeRegistries.RECIPES.register(new RecipeJerrycan().setRegistryName(ImmersiveEngineering.MODID, \"jerrycan\"));\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":jerrycan\", RecipeJerrycan.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemToolbox), \"PPP\",\"RCR\", 'P',\"plateAluminum\",'C',new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.CRATE.getMeta()),'R',\"dyeRed\");\n\n\t\tForgeRegistries.RECIPES.register(new RecipeShaderBags().setRegistryName(ImmersiveEngineering.MODID, \"shader_bags\"));\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":shaderbags\", RecipeShaderBags.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemEarmuffs), \" S \",\"S S\",\"W W\", 'S',\"stickIron\",'W',new ItemStack(Blocks.WOOL,1,OreDictionary.WILDCARD_VALUE));\n\t\tForgeRegistries.RECIPES.register(new RecipeEarmuffs().setRegistryName(ImmersiveEngineering.MODID, \"earmuffs\"));\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":earmuffs\", RecipeEarmuffs.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemsFaradaySuit[0]), \"A A\", \"A A\", 'A', \"plateAluminum\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemsFaradaySuit[1]), \"AAA\", \"A A\", \"A A\", 'A', \"plateAluminum\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemsFaradaySuit[2]), \"A A\", \"AAA\", \"AAA\", 'A', \"plateAluminum\");\n\t\taddOredictRecipe(new ItemStack(IEContent.itemsFaradaySuit[3]), \"AAA\", \"A A\", 'A', \"plateAluminum\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemPowerpack), \"LBL\",\"WCW\", 'L',\"leather\",'B',new ItemStack(IEContent.blockMetalDevice0,1,BlockTypes_MetalDevice0.CAPACITOR_LV.getMeta()),'C',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_LV.getMeta()),'W',new ItemStack(IEContent.itemWireCoil,1,0));\n\t\tForgeRegistries.RECIPES.register(new RecipePowerpack().setRegistryName(ImmersiveEngineering.MODID, \"powerpack\"));\n\t\tRecipeSorter.register(ImmersiveEngineering.MODID+\":powerpack\", RecipePowerpack.class, Category.SHAPELESS, \"after:forge:shapelessore\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemFluorescentTube), \"GEG\", \"GgG\", \"GgG\", 'G', \"blockGlass\", 'E', new ItemStack(IEContent.itemGraphiteElectrode), 'g', \"dustGlowstone\");\n\n\t\taddOredictRecipe(new ItemStack(IEContent.itemShield), \"PTP\",\"PSP\",\"PTP\", 'P',\"plateSteel\",'T',\"plankTreatedWood\",'S',Items.SHIELD);\n\n\t\t//\n\t\t//TREATED WOOD\n\t\t//\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockTreatedWood, 8, 0), \"WWW\", \"WCW\", \"WWW\", 'W', \"plankWood\", 'C', new IngredientFluidStack(IEContent.fluidCreosote, 1000));\n\t\tfor(int i=0; i<IEContent.blockTreatedWood.enumValues.length; i++)\n\t\t{\n\t\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockTreatedWood,1, i==IEContent.blockTreatedWood.enumValues.length-1?0:i+1), new ItemStack(IEContent.blockTreatedWood,1,i));\n\t\t\taddTwoWaySlabRecipe(new ItemStack(IEContent.blockTreatedWoodSlabs,1,i), new ItemStack(IEContent.blockTreatedWood,1,i));\n\t\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockTreatedWoodSlabs,1, i==IEContent.blockTreatedWood.enumValues.length-1?0:i+1), new ItemStack(IEContent.blockTreatedWoodSlabs,1,i));\n\t\t}\n\t\taddStairRecipe(IEContent.blockWoodenStair, new ItemStack(IEContent.blockTreatedWood,1,0));\n\t\taddStairRecipe(IEContent.blockWoodenStair1, new ItemStack(IEContent.blockTreatedWood,1,1));\n\t\taddStairRecipe(IEContent.blockWoodenStair2, new ItemStack(IEContent.blockTreatedWood,1,2));\n\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockWoodenStair,1,0), new ItemStack(IEContent.blockWoodenStair2,1,0));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockWoodenStair1,1,0), new ItemStack(IEContent.blockWoodenStair,1,0));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockWoodenStair2,1,0), new ItemStack(IEContent.blockWoodenStair1,1,0));\n\n\t\t//\n\t\t//WOODEN DECORACTION\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDecoration,3,BlockTypes_WoodenDecoration.FENCE.getMeta()), \"WSW\",\"WSW\", 'W',\"plankTreatedWood\", 'S',\"stickTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDecoration,6,BlockTypes_WoodenDecoration.SCAFFOLDING.getMeta()), \"WWW\",\" S \",\"S S\", 'W',\"plankTreatedWood\",'S',\"stickTreatedWood\");\n\n\t\t//\n\t\t//WOODEN DEVICES\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.CRATE.getMeta()), \"WWW\",\"W W\",\"WWW\", 'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.BARREL.getMeta()), \"SSS\",\"W W\",\"WWW\", 'W',\"plankTreatedWood\",'S',\"slabTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.WORKBENCH.getMeta()), \"WWW\",\"B F\", 'W',\"plankTreatedWood\",'B',\"craftingTableWood\",'F',\"fenceTreatedWood\");\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.SORTER.getMeta()), \"WRW\", \"IBI\", \"WCW\", 'I', \"ingotIron\", 'R', \"dustRedstone\", 'W', \"plankTreatedWood\", 'B',baseConveyor, 'C',componentIron).allowQuarterTurn();\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.GUNPOWDER_BARREL.getMeta()), \" F \",\"GBG\",\"GGG\", 'F',\"fiberHemp\",'G',Items.GUNPOWDER,'B',new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.BARREL.getMeta()));\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.REINFORCED_CRATE.getMeta()), \"WPW\", \"RCR\", \"WPW\", 'W', \"plankTreatedWood\", 'P', \"plateIron\", 'R', \"stickIron\", 'C', new ItemStack(IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.CRATE.getMeta())).setNBTCopyTargetRecipe(4).allowQuarterTurn();\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.TURNTABLE.getMeta()), \"WIW\", \"RCR\", 'I',\"ingotIron\", 'C',copperCoil, 'R',\"dustRedstone\", 'W',\"plankTreatedWood\");\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockWoodenDevice0, 1, BlockTypes_WoodenDevice0.FLUID_SORTER.getMeta()), \"WRW\", \"IBI\", \"WCW\", 'I', \"ingotIron\", 'R', \"dustRedstone\", 'W', \"plankTreatedWood\", 'B',new ItemStack(IEContent.blockMetalDevice1,1,BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()), 'C',componentIron).allowQuarterTurn();\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice1,1,BlockTypes_WoodenDevice1.WATERMILL.getMeta()), \" P \",\"PIP\",\" P \", 'P',new ItemStack(IEContent.itemMaterial,1,10),'I',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice1,1,BlockTypes_WoodenDevice1.WINDMILL.getMeta()), \"PPP\",\"PIP\",\"PPP\", 'P',new ItemStack(IEContent.itemMaterial,1,11),'I',\"ingotIron\");\n//\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice1,1,BlockTypes_WoodenDevice1.WINDMILL_ADVANCED.getMeta()), \"PPP\",\"PIP\",\"PPP\", 'P',new ItemStack(IEContent.itemMaterial,1,12),'I',\"ingotSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice1,1,BlockTypes_WoodenDevice1.POST.getMeta()), \"F\",\"F\",\"S\", 'F',\"fenceTreatedWood\",'S',\"bricksStone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockWoodenDevice1,4,BlockTypes_WoodenDevice1.WALLMOUNT.getMeta()), \"WW\",\"WS\", 'W',\"plankTreatedWood\",'S',\"stickTreatedWood\");\n\n\t\t//\n\t\t//CLOTH DEVICES\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockClothDevice,3,BlockTypes_ClothDevice.CUSHION.getMeta()), \"FFF\",\"F F\",\"FFF\", 'F',\"fabricHemp\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockClothDevice,2,BlockTypes_ClothDevice.BALLOON.getMeta()), \" F \",\"FTF\",\" S \", 'F',\"fabricHemp\", 'T',\"torch\", 'S',\"slabTreatedWood\");\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockClothDevice,3,BlockTypes_ClothDevice.STRIPCURTAIN.getMeta()), \"SSS\",\"FFF\",\"FFF\", 'S',metalSticks, 'F',\"fabricHemp\");\n\t\tfinal ItemStack stripCurtain = new ItemStack(IEContent.blockClothDevice,1,BlockTypes_ClothDevice.STRIPCURTAIN.getMeta());\n\t\tForgeRegistries.RECIPES.register(new RecipeRGBColouration((s)->(OreDictionary.itemMatches(stripCurtain,s,true)), (s)->(ItemNBTHelper.hasKey(s,\"colour\")?ItemNBTHelper.getInt(s,\"colour\"):0xffffff), (s, i)->ItemNBTHelper.setInt(s, \"colour\", i) ).setRegistryName(ImmersiveEngineering.MODID, \"stripcurtain_colour\"));\n\n\t\t//\n\t\t//STONE DECORACTION\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,3,BlockTypes_StoneDecoration.COKEBRICK.getMeta()), \"CBC\",\"BSB\",\"CBC\", 'S',\"sandstone\",'C',Items.CLAY_BALL,'B',\"ingotBrick\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,3,BlockTypes_StoneDecoration.BLASTBRICK.getMeta()), \"NBN\",\"BDB\",\"NBN\", 'D',Items.BLAZE_POWDER,'N',\"ingotBrickNether\",'B',\"ingotBrick\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK_REINFORCED.getMeta()), \"P\",\"B\", 'P',\"plateSteel\",'B',new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.BLASTBRICK.getMeta()));\n\t\taddTwoWayStorageRecipe(new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.COKE.getMeta()), new ItemStack(IEContent.itemMaterial,1,6));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,6,BlockTypes_StoneDecoration.HEMPCRETE.getMeta()), \"CCC\",\"HHH\",\"CCC\", 'C',Items.CLAY_BALL,'H',\"fiberHemp\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,2,BlockTypes_StoneDecoration.ALLOYBRICK.getMeta()), \"SB\",\"BS\", 'S',\"sandstone\",'B',\"ingotBrick\");\n\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockStoneDecoration, 8, BlockTypes_StoneDecoration.CONCRETE.getMeta()), \"SCS\", \"GBG\", \"SCS\", 'C', Items.CLAY_BALL, 'S', \"sand\", 'G', Blocks.GRAVEL, 'B', new IngredientFluidStack(FluidRegistry.WATER,1000)).allowQuarterTurn();\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockStoneDecoration, 12, BlockTypes_StoneDecoration.CONCRETE.getMeta()), \"SCS\", \"GBG\", \"SCS\", 'C', Items.CLAY_BALL, 'S', \"itemSlag\", 'G', Blocks.GRAVEL, 'B', new IngredientFluidStack(FluidRegistry.WATER,1000)).allowQuarterTurn();\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE.getMeta()), new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE_TILE.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration,4,BlockTypes_StoneDecoration.CONCRETE_TILE.getMeta()), \"CC\",\"CC\", 'C',new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta()), \"P\", \"B\", 'P', \"plateLead\", 'B', new ItemStack(IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.CONCRETE.getMeta()));\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockStoneDecoration, 2, BlockTypes_StoneDecoration.INSULATING_GLASS.getMeta()), \" G \", \"IDI\", \" G \", 'G', \"blockGlass\", 'I', \"dustIron\", 'D', \"dyeGreen\").allowQuarterTurn();\n\t\tfor(int i=0; i<=BlockTypes_StoneDecoration.values().length; i++)\n\t\t\tif(!IEContent.blockStoneDecorationSlabs.isMetaHidden(i))\n\t\t\t\taddTwoWaySlabRecipe(new ItemStack(IEContent.blockStoneDecorationSlabs,1,i), new ItemStack(IEContent.blockStoneDecoration,1,i));\n\t\taddStairRecipe(IEContent.blockStoneStair_hempcrete, new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.HEMPCRETE.getMeta()));\n\t\taddStairRecipe(IEContent.blockStoneStair_concrete0, new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE.getMeta()));\n\t\taddStairRecipe(IEContent.blockStoneStair_concrete1, new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE_TILE.getMeta()));\n\t\taddStairRecipe(IEContent.blockStoneStair_concrete2, new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.CONCRETE_LEADED.getMeta()));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockStoneStair_concrete0,1,0), new ItemStack(IEContent.blockStoneStair_concrete1,1,0));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockStoneStair_concrete1,1,0), new ItemStack(IEContent.blockStoneStair_concrete0,1,0));\n\n\t\t//\n\t\t//METAL STORAGE\n\t\t//\n\t\taddTwoWayStorageRecipe(new ItemStack(Items.IRON_INGOT), new ItemStack(IEContent.itemMetal,1,29));\n\t\tfor(int i=0; i<=8; i++)\n\t\t{\n\t\t\taddTwoWayStorageRecipe(new ItemStack(IEContent.itemMetal,1,i), new ItemStack(IEContent.itemMetal,1,20+i));\n\t\t\taddTwoWayStorageRecipe(new ItemStack(IEContent.blockStorage,1,i), new ItemStack(IEContent.itemMetal,1,i));\n\t\t\taddTwoWaySlabRecipe(new ItemStack(IEContent.blockStorageSlabs,1,i), new ItemStack(IEContent.blockStorage,1,i));\n\t\t}\n\t\t//\n\t\t//SHEETMETAL\n\t\t//\n\t\tfor(int i=0; i<Lib.METALS_ALL.length; i++)\n\t\t\tif(!IEContent.itemMetal.isMetaHidden(30+i))\n\t\t\t{\n\t\t\t\taddShapelessOredictRecipe(new ItemStack(IEContent.itemMetal,1,30+i), \"ingot\"+Lib.METALS_ALL[i],new ItemStack(IEContent.itemTool,1,0));\n\t\t\t\taddOredictRecipe(new ItemStack(IEContent.blockSheetmetal,4,i), \" P \",\"P P\",\" P \", 'P',\"plate\"+Lib.METALS_ALL[i]);\n\t\t\t\taddShapelessOredictRecipe(new ItemStack(IEContent.itemMetal,1,30+i), new ItemStack(IEContent.blockSheetmetal,1,i));\n\t\t\t\taddTwoWaySlabRecipe(new ItemStack(IEContent.blockSheetmetalSlabs,1,i), new ItemStack(IEContent.blockSheetmetal,1,i));\n\t\t\t}\n\n\t\t//\n\t\t//METAL DECORACTION\n\t\t//\n\t\taddOredictRecipe(copperCoil, \"WWW\",\"WIW\",\"WWW\", 'I',\"ingotIron\",'W',new ItemStack(IEContent.itemWireCoil,1,0));\n\t\taddOredictRecipe(electrumCoil, \"WWW\",\"WIW\",\"WWW\", 'I',\"ingotIron\",'W',new ItemStack(IEContent.itemWireCoil,1,1));\n\t\taddOredictRecipe(hvCoil, \"WWW\",\"WIW\",\"WWW\", 'I',\"ingotIron\",'W',new ItemStack(IEContent.itemWireCoil,1,2));\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()), \"IRI\", \"RCR\", \"IRI\", 'I', \"ingotIron\", 'C', \"ingotCopper\", 'R', \"dustRedstone\").allowEighthTurn();\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()), \"IGI\",\"CCC\",\"IGI\", 'I',\"ingotIron\",'C',\"ingotCopper\",'G',componentIron);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.HEAVY_ENGINEERING.getMeta()), \"IGI\",\"PEP\",\"IGI\", 'I',\"ingotSteel\",'E',\"ingotElectrum\",'G',componentSteel,'P',Blocks.PISTON);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.GENERATOR.getMeta()), \"III\",\"EDE\",\"III\", 'I',\"ingotSteel\",'E',\"ingotElectrum\",'D',new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.DYNAMO.getMeta()));\n\t\taddIngredientRecipe(new ItemStack(IEContent.blockMetalDecoration0, 2, BlockTypes_MetalDecoration0.RADIATOR.getMeta()), \"ICI\", \"CBC\", \"ICI\", 'I', \"ingotSteel\", 'C', \"ingotCopper\", 'B', new IngredientFluidStack(FluidRegistry.WATER,1000)).allowEighthTurn();\n\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 3, BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta()), \"IRI\",\"IRI\", 'I',\"ingotSteel\",'R',\"stickSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 6, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()), \"III\",\" R \",\"R R\", 'I',\"ingotSteel\",'R',\"stickSteel\");\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_1.getMeta()));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_0.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.STEEL_SCAFFOLDING_2.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 3, BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()), \"IRI\",\"IRI\", 'I',\"ingotAluminum\",'R',\"stickAluminum\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 6, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), \"III\",\" R \",\"R R\", 'I',\"ingotAluminum\",'R',\"stickAluminum\");\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_1.getMeta()));\n\t\taddShapelessOredictRecipe(new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_0.getMeta()), new ItemStack(IEContent.blockMetalDecoration1, 1, BlockTypes_MetalDecoration1.ALUMINUM_SCAFFOLDING_2.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,1,BlockTypes_MetalDecoration2.STEEL_POST.getMeta()), \"F\",\"F\",\"S\", 'F',\"fenceSteel\",'S',\"bricksStone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,4,BlockTypes_MetalDecoration2.STEEL_WALLMOUNT.getMeta()), \"II\",\"IS\", 'I',\"ingotSteel\",'S',\"stickSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,1,BlockTypes_MetalDecoration2.ALUMINUM_POST.getMeta()), \"F\",\"F\",\"S\", 'F',\"fenceAluminum\",'S',\"bricksStone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,4,BlockTypes_MetalDecoration2.ALUMINUM_WALLMOUNT.getMeta()), \"II\",\"IS\", 'I',\"ingotAluminum\",'S',\"stickAluminum\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,3,BlockTypes_MetalDecoration2.LANTERN.getMeta()), \" I \",\"PGP\",\" I \", 'G',\"glowstone\",'I',\"plateIron\",'P',\"paneGlass\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDecoration2,3,BlockTypes_MetalDecoration2.RAZOR_WIRE.getMeta()), \"PWP\",\"WWW\",\"PWP\", 'W',\"wireSteel\",'P',\"plateSteel\");\n\n\t\t//\n\t\t//CONNECTOR\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 4, BlockTypes_Connector.CONNECTOR_LV.getMeta()), \" I \",\"BIB\",\"BIB\", 'I',\"ingotCopper\",'B',Blocks.HARDENED_CLAY);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 8, BlockTypes_Connector.RELAY_LV.getMeta()), \" I \",\"BIB\", 'I',\"ingotCopper\",'B',Blocks.HARDENED_CLAY);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 4, BlockTypes_Connector.CONNECTOR_MV.getMeta()), \" I \",\"BIB\",\"BIB\", 'I',\"ingotIron\",'B',Blocks.HARDENED_CLAY);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 8, BlockTypes_Connector.RELAY_MV.getMeta()), \" I \",\"BIB\", 'I',\"ingotIron\",'B',Blocks.HARDENED_CLAY);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 4, BlockTypes_Connector.CONNECTOR_HV.getMeta()), \" I \",\"BIB\",\"BIB\", 'I',\"ingotAluminum\",'B',Blocks.HARDENED_CLAY);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 8, BlockTypes_Connector.RELAY_HV.getMeta()), \" I \",\"BIB\",\"BIB\", 'I',\"ingotAluminum\",'B',new ItemStack(IEContent.blockStoneDecoration,1,BlockTypes_StoneDecoration.INSULATING_GLASS.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 8, BlockTypes_Connector.CONNECTOR_STRUCTURAL.getMeta()), \"ISI\",\"I I\", 'I',\"ingotSteel\",'S',\"stickSteel\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.TRANSFORMER.getMeta()), \"L M\",\"IBI\",\"III\", 'L',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_LV.getMeta()),'M',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_MV.getMeta()),'I',\"ingotIron\",'B',electrumCoil).setMirrored(true);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.TRANSFORMER_HV.getMeta()), \"M H\",\"IBI\",\"III\", 'H',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_HV.getMeta()),'M',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_MV.getMeta()),'I',\"ingotIron\",'B',hvCoil).setMirrored(true);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.BREAKERSWITCH.getMeta()), \" L \",\"CIC\", 'L',Blocks.LEVER,'C',Blocks.HARDENED_CLAY,'I',\"ingotCopper\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.REDSTONE_BREAKER.getMeta()), \"H H\",\"ICI\",\"IRI\", 'H',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_HV.getMeta()), 'I',\"ingotIron\", 'C',Items.REPEATER, 'R',\"dustRedstone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 1, BlockTypes_Connector.ENERGY_METER.getMeta()), \" M \",\"BCB\",\"ICI\", 'M',new ItemStack(IEContent.itemTool,1,2), 'B', Blocks.HARDENED_CLAY, 'I',\"ingotIron\", 'C',copperCoil);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockConnectors, 4, BlockTypes_Connector.CONNECTOR_REDSTONE.getMeta()), \"III\", \"BRB\", 'I', \"nuggetElectrum\", 'B', Blocks.HARDENED_CLAY, 'R', \"dustRedstone\");\n\n\t\t//\n\t\t//METAL DEVICES\n\t\t//\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.CAPACITOR_LV.getMeta()), \"III\",\"CLC\",\"WRW\", 'L',\"ingotLead\",'I',\"ingotIron\",'C',\"ingotCopper\",'R',\"dustRedstone\",'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.CAPACITOR_MV.getMeta()), \"III\",\"ELE\",\"WRW\", 'L',\"ingotLead\",'I',\"ingotIron\",'E',\"ingotElectrum\",'R',\"blockRedstone\",'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.CAPACITOR_HV.getMeta()), \"III\",\"ALA\",\"WRW\", 'L',\"blockLead\",'I',\"ingotSteel\",'A',\"ingotAluminum\",'R',\"blockRedstone\",'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.BARREL.getMeta()), \"SSS\",\"B B\",\"BBB\", 'B',\"blockSheetmetalIron\",'S',\"slabSheetmetalIron\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.FLUID_PUMP.getMeta()), \" I \",\"ICI\",\"PPP\", 'I',\"plateIron\",'C',componentIron,'P',new ItemStack(IEContent.blockMetalDevice1,1,BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.FLUID_PLACER.getMeta()), \"IBI\",\"B B\",\"IBI\", 'I',\"plateIron\",'B',Blocks.IRON_BARS);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.BLAST_FURNACE_PREHEATER.getMeta()), \"SSS\",\"S S\",\"SHS\", 'S',\"blockSheetmetalIron\", 'H',new ItemStack(IEContent.blockMetalDevice1,1,BlockTypes_MetalDevice1.FURNACE_HEATER.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.FURNACE_HEATER.getMeta()), \"ICI\",\"CBC\",\"IRI\", 'I',\"ingotIron\",'R',\"dustRedstone\",'C',\"ingotCopper\",'B',copperCoil);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.DYNAMO.getMeta()), \"RCR\",\"III\", 'C',copperCoil,'I',\"ingotIron\",'R',\"dustRedstone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.THERMOELECTRIC_GEN.getMeta()), \"III\",\"CBC\",\"CCC\", 'I',\"ingotSteel\",'C',\"plateConstantan\",'B',copperCoil);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,3, BlockTypes_MetalDevice1.ELECTRIC_LANTERN.getMeta()), \" I \",\"PTP\",\"IRI\", 'P',\"paneGlass\",'I',\"plateIron\",'T',elecTube,'R',\"dustRedstone\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.CHARGING_STATION.getMeta()), \"IMI\",\"GGG\",\"WCW\", 'M',new ItemStack(IEContent.blockConnectors,1,BlockTypes_Connector.CONNECTOR_MV.getMeta()), 'I',\"ingotIron\", 'G',\"blockGlass\", 'C',copperCoil, 'W',\"plankTreatedWood\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,8, BlockTypes_MetalDevice1.FLUID_PIPE.getMeta()), \"PPP\",\"   \",\"PPP\", 'P',\"plateIron\");\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.SAMPLE_DRILL.getMeta()), \"SFS\",\"SFS\",\"BFB\", 'F',\"fenceSteel\",'S',\"scaffoldingSteel\",'B',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.TESLA_COIL.getMeta()), \"III\",\" C \",\"MCM\", 'I',\"ingotAluminum\",'C',copperCoil,'M',new ItemStack(IEContent.blockMetalDevice0,1,BlockTypes_MetalDevice0.CAPACITOR_MV.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.FLOODLIGHT.getMeta()), \"III\",\"PTC\",\"ILI\", 'I',\"ingotIron\",'P',\"paneGlass\",'T',elecTube,'C',copperCoil,'L',componentIron);\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.TURRET_CHEM.getMeta()), \" S \",\" GL\",\"XBR\", 'S',new ItemStack(IEContent.itemToolUpgrades,1,8), 'G',new ItemStack(IEContent.itemChemthrower),'L',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()), 'B',new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.TURNTABLE.getMeta()),'R',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()),'X',new ItemStack(IEContent.blockMetalDevice0,1, BlockTypes_MetalDevice0.BARREL.getMeta()));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.TURRET_GUN.getMeta()), \" S \",\" GL\",\"XBR\", 'S',new ItemStack(IEContent.itemToolUpgrades,1,8), 'G',new ItemStack(IEContent.itemRevolver),'L',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.LIGHT_ENGINEERING.getMeta()), 'B',new ItemStack(IEContent.blockWoodenDevice0,1,BlockTypes_WoodenDevice0.TURNTABLE.getMeta()),'R',new ItemStack(IEContent.blockMetalDecoration0,1,BlockTypes_MetalDecoration0.RS_ENGINEERING.getMeta()),'X',new ItemStack(IEContent.itemToolUpgrades,1,5));\n\t\taddOredictRecipe(new ItemStack(IEContent.blockMetalDevice1,1, BlockTypes_MetalDevice1.BELLJAR.getMeta()), \"GTG\",\"G G\",\"WCW\", 'T',elecTube, 'G',\"blockGlass\", 'W',\"plankTreatedWood\", 'C',componentIron);\n\n\t\taddOredictRecipe(Utils.copyStackWithAmount(baseConveyor, 8), \"LLL\", \"IRI\", 'I', \"ingotIron\", 'R', \"dustRedstone\", 'L', \"leather\");\n\t\taddShapelessIngredientRecipe(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":uncontrolled\"), 1), new IngredientStack(baseConveyor).setUseNBT(true));\n\t\taddShapelessIngredientRecipe(baseConveyor, new IngredientStack(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":uncontrolled\"), 1)).setUseNBT(true));\n\t\taddOredictRecipe(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":dropper\"), 1), \"C\", \"H\", 'C', baseConveyor, 'H', Blocks.IRON_TRAPDOOR);\n\t\taddOredictRecipe(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":vertical\"), 3), \"CI\", \"C \", \"CI\", 'C', baseConveyor, 'I', \"ingotIron\");\n\t\taddOredictRecipe(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":splitter\"), 3), \"CIC\", \" C \", 'C', baseConveyor, 'I', \"ingotIron\");\n\t\taddOredictRecipe(Utils.copyStackWithAmount(ConveyorHandler.getConveyorStack(ImmersiveEngineering.MODID + \":covered\"), 1), \"S\", \"C\", 'C', baseConveyor, 'S',\"scaffoldingSteel\");";
        String[] lines = input.split("\n");
        ArrayListMultimap sortedMap = ArrayListMultimap.create();
        for (String line : lines) {
            int idx;
            if (!(line = line.trim()).startsWith("add") || (idx = line.indexOf("(")) <= 0) continue;
            sortedMap.put((Object)line.substring(0, idx), (Object)line.substring(idx + 1, line.length() - 2));
        }
        File dir = new File(OUT_PATH);
        if (dir.isDirectory()) {
            dir.delete();
        }
        ArrayList<String> oreEntries = new ArrayList<String>();
        for (String key : sortedMap.keySet()) {
            System.out.println("Handling " + key);
            for (String val : sortedMap.get((Object)key)) {
                int i;
                int idxOutEnd;
                int idxOutEndTrue = idxOutEnd = val.startsWith("new") ? val.indexOf("),") : val.indexOf(",");
                if (idxOutEnd < 0) {
                    System.err.println("failed to parse (because indexes): " + val);
                    continue;
                }
                int idxOutStart = val.substring(0, idxOutEnd).lastIndexOf("(");
                if (idxOutStart > 0) {
                    if (idxOutEnd - idxOutStart < 3) {
                        idxOutStart = val.substring(0, idxOutStart).lastIndexOf("(");
                    }
                    if (idxOutEnd - idxOutStart < 3) {
                        System.err.println("failed to parse (too small out): " + val);
                        continue;
                    }
                    idxOutEndTrue = val.indexOf(")", idxOutStart);
                } else {
                    idxOutStart = 0;
                }
                String output = val.substring(0, idxOutEndTrue + 1);
                System.out.println("  " + output);
                String toSplit = val.substring(val.indexOf(" ", idxOutEnd));
                toSplit = toSplit.replaceAll("\\.ordinal\\(", "");
                toSplit = toSplit.replaceAll("\\.getMeta\\(", "");
                toSplit = toSplit.replaceAll("\\.allowQuarterTurn\\(", "");
                toSplit = toSplit.replaceAll("\\.allowEighthTurn\\(", "");
                toSplit = toSplit.replaceAll("\\.setMirrored\\(true", "");
                String[] split = null;
                try {
                    split = toSplit.trim().split(",(?![^()]*\\))");
                }
                catch (Exception e) {
                    System.err.println("Error for " + output + "!");
                    continue;
                }
                System.out.println("   Recipe:");
                for (i = 0; i < split.length; ++i) {
                    split[i] = split[i].trim();
                    System.out.println("    -" + split[i]);
                }
                i = 0;
                boolean shaped = split[i].startsWith("\"");
                StringBuilder out = new StringBuilder("{\n");
                out.append("  \"type\": \"");
                if (shaped) {
                    out.append("forge:ore_shaped");
                } else {
                    out.append("forge:ore_shapeless");
                }
                out.append("\",\n");
                out.append("  \"result\": {\n" + RecipeConverter.parseItemStack(output) + "\n  },\n");
                if (shaped) {
                    out.append("  \"pattern\": [\n");
                    boolean interrupt = false;
                    while (split[i].startsWith("\"")) {
                        out.append("    " + split[i++]);
                        if (i >= split.length) {
                            interrupt = true;
                            break;
                        }
                        if (split[i].startsWith("\"")) {
                            out.append(",");
                        }
                        out.append("\n");
                    }
                    if (interrupt) {
                        System.err.println("failed to parse (interrupt on pattern): " + val);
                        continue;
                    }
                    out.append("  ],\n");
                    out.append("  \"key\": {\n");
                    while (i < split.length) {
                        if (split[i].startsWith("'")) {
                            String c = split[i].substring(1, 2);
                            out.append("    \"" + c + "\": {\n");
                            String item = split[i + 1].trim();
                            if (!(item.startsWith("new") || item.startsWith("Items.") || item.startsWith("Blocks.") || item.startsWith("IEContent."))) {
                                if (item.startsWith("\"") && !oreEntries.contains(item = item.substring(1, item.length() - 1))) {
                                    oreEntries.add(item);
                                }
                                item = "      \"item\": \"#" + item + "\"";
                            } else {
                                item = RecipeConverter.parseItemStack(item);
                            }
                            out.append(item);
                            out.append("\n    }");
                            if (i + 2 < split.length) {
                                out.append(",");
                            }
                            out.append("\n");
                        }
                        i += 2;
                    }
                    out.append("  }");
                } else {
                    out.append("  \"ingredients\": [\n");
                    while (i < split.length) {
                        out.append("    {\n");
                        String item = split[i];
                        item = !item.startsWith("new") && !item.startsWith("Items.") && !item.startsWith("Blocks.") && !item.startsWith("IEContent.") ? "      \"item\": \"#" + item + "\"" : RecipeConverter.parseItemStack(item);
                        out.append(item);
                        out.append("\n    }");
                        if (i + 2 < split.length) {
                            out.append(",");
                        }
                        out.append("\n");
                        i += 2;
                    }
                    out.append("  ]");
                }
                out.append("\n}");
                String name = val.substring(idxOutStart, idxOutEndTrue);
                name = name.replaceAll("\\)", "").replaceAll("\\(", "").replaceAll(" ", "").replaceAll(",", "_").replaceAll("\"", "").replaceAll("\\+", "");
                RecipeConverter.saveToJson(key + "/" + name, out.toString());
            }
        }
        if (!oreEntries.isEmpty()) {
            Collections.sort(oreEntries);
            StringBuilder out = new StringBuilder("[\n");
            int i = 0;
            while (i < oreEntries.size()) {
                String ore = (String)oreEntries.get(i);
                out.append("  {\n    \"ingredient\": {\n      \"type\": \"forge:ore_dict\",\n");
                out.append("      \"ore\": \"" + ore + "\"\n    },\n");
                out.append("    \"name\": \"" + ore + "\"\n  }");
                if (++i < oreEntries.size()) {
                    out.append(",");
                }
                out.append("\n");
            }
            out.append("]");
            RecipeConverter.saveToJson("oreDict", out.toString());
        }
    }

    static void saveToJson(String file, String out) {
        File f = new File(OUT_PATH + file + ".json");
        boolean i = true;
        if (f.exists()) {
            try {
                f.getParentFile().mkdirs();
                FileWriter fw = new FileWriter(f);
                fw.write(out);
                fw.flush();
            }
            catch (Exception e) {
                System.out.println("Can't find " + f.getAbsolutePath());
            }
        }
    }

    static String parseItemStack(String input) {
        int i;
        String[] split;
        String content = input.trim();
        if (content.startsWith("new ItemStack") && (content = content.substring("new ItemStack(".length())).endsWith(")") && !content.endsWith("()")) {
            content = content.substring(0, content.length() - 1);
        }
        if ((split = content.split(",")).length < 1) {
            return "    item: \"" + input + "\"";
        }
        String item = split[0];
        if (item.startsWith("Blocks.")) {
            item = "minecraft:" + split[0].substring("Blocks.".length()).toLowerCase();
        } else if (item.startsWith("Items.")) {
            item = "minecraft:" + split[0].substring("Items.".length()).toLowerCase();
        } else if (item.startsWith("IEContent.")) {
            item = RecipeConverter.camelCaseToMojang(split[0].substring("IEContent.".length()));
            if (item.startsWith("block_")) {
                item = item.substring("block_".length());
            } else if (item.startsWith("item_")) {
                item = item.substring("item_".length());
            }
            item = "immersiveengineering:" + item;
        }
        String output = "    \"item\": \"" + item + "\"";
        if (split.length > 2) {
            output = output + ",\n    \"data\": " + split[2].trim();
        }
        if (split.length > 1 && (i = RecipeConverter.parseInt(split[1])) > 1) {
            output = output + ",\n    \"count\": " + i;
        }
        return output;
    }

    static String camelCaseToMojang(String s) {
        String out = "";
        for (char c : s.toCharArray()) {
            out = Character.isUpperCase(c) ? out + "_" + Character.toLowerCase(c) : out + c;
        }
        return out;
    }

    static int parseInt(String s) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception e) {
            return 0;
        }
    }
}

