/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipe
extends MultiblockRecipe {
    public static float energyModifier = 1.0f;
    public static float timeModifier = 1.0f;
    public final String oreInputString;
    public final IngredientStack input;
    public final ItemStack output;
    public ItemStack[] secondaryOutput;
    public float[] secondaryChance;
    public static ArrayList<CrusherRecipe> recipeList = new ArrayList();

    public CrusherRecipe(ItemStack output, Object input, int energy) {
        this.output = output;
        this.input = ApiUtils.createIngredientStack(input);
        this.oreInputString = input instanceof String ? (String)input : null;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(50.0f * timeModifier);
        this.inputList = Lists.newArrayList((Object[])new IngredientStack[]{this.input});
        this.outputList = ListUtils.fromItem(this.output);
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.output);
        if (this.secondaryOutput != null && this.secondaryChance != null) {
            for (int i = 0; i < this.secondaryOutput.length; ++i) {
                if (!(Utils.RAND.nextFloat() < this.secondaryChance[i])) continue;
                list.add((Object)this.secondaryOutput[i]);
            }
        }
        return list;
    }

    public CrusherRecipe addToSecondaryOutput(Object ... outputs) {
        int i;
        if (outputs.length % 2 != 0) {
            return this;
        }
        ArrayList<ItemStack> newSecondaryOutput = new ArrayList<ItemStack>();
        ArrayList<Float> newSecondaryChance = new ArrayList<Float>();
        if (this.secondaryOutput != null) {
            for (i = 0; i < this.secondaryOutput.length; ++i) {
                newSecondaryOutput.add(this.secondaryOutput[i]);
                newSecondaryChance.add(Float.valueOf(this.secondaryChance[i]));
            }
        }
        for (i = 0; i < outputs.length / 2; ++i) {
            ItemStack ss;
            if (outputs[i * 2] == null) continue;
            Object o = ApiUtils.convertToValidRecipeInput(outputs[i * 2]);
            ItemStack itemStack = o instanceof ItemStack ? (ItemStack)o : (ss = o instanceof List ? IEApi.getPreferredStackbyMod((List)o) : ItemStack.field_190927_a);
            if (ss.func_190926_b()) continue;
            newSecondaryOutput.add(ss);
            newSecondaryChance.add((Float)outputs[i * 2 + 1]);
        }
        this.secondaryOutput = newSecondaryOutput.toArray(new ItemStack[newSecondaryOutput.size()]);
        this.secondaryChance = new float[newSecondaryChance.size()];
        i = 0;
        for (Float f : newSecondaryChance) {
            this.secondaryChance[i++] = f.floatValue();
        }
        this.outputList = ListUtils.fromItems(this.secondaryOutput);
        if (this.outputList.isEmpty()) {
            this.outputList.add((Object)this.output);
        } else {
            this.outputList.add(0, (Object)this.output);
        }
        return this;
    }

    public static CrusherRecipe addRecipe(ItemStack output, Object input, int energy) {
        CrusherRecipe r = new CrusherRecipe(output, input, energy);
        if (r.input != null && !r.output.func_190926_b()) {
            recipeList.add(r);
        }
        return r;
    }

    public static CrusherRecipe findRecipe(ItemStack input) {
        for (CrusherRecipe recipe : recipeList) {
            if (!recipe.input.matchesItemStack(input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<CrusherRecipe> removeRecipes(ItemStack stack) {
        ArrayList<CrusherRecipe> list = new ArrayList<CrusherRecipe>();
        Iterator<CrusherRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            CrusherRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 4;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("input", (NBTBase)this.input.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public static CrusherRecipe loadFromNBT(NBTTagCompound nbt) {
        IngredientStack input = IngredientStack.readFromNBT(nbt.func_74775_l("input"));
        for (CrusherRecipe recipe : recipeList) {
            if (!recipe.input.equals(input)) continue;
            return recipe;
        }
        return null;
    }
}

