/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public interface IMultiblockRecipe {
    public List<IngredientStack> getItemInputs();

    public List<FluidStack> getFluidInputs();

    public NonNullList<ItemStack> getItemOutputs();

    default public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        return this.getItemOutputs();
    }

    public List<FluidStack> getFluidOutputs();

    default public ItemStack getDisplayStack(ItemStack input) {
        for (IngredientStack ingr : this.getItemInputs()) {
            if (!ingr.matchesItemStack(input)) continue;
            return Utils.copyStackWithAmount(input, ingr.inputSize);
        }
        return ItemStack.field_190927_a;
    }

    default public List<FluidStack> getActualFluidOutputs(TileEntity tile) {
        return this.getFluidOutputs();
    }

    public int getTotalProcessTime();

    public int getTotalProcessEnergy();

    public int getMultipleProcessTicks();

    public NBTTagCompound writeToNBT(NBTTagCompound var1);
}

