/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.ConveyorHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelConveyor;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBasic;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorCovered;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorVertical;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.util.vector.Vector3f;

public class ConveyorVerticalCovered
extends ConveyorVertical {
    public ItemStack cover = ItemStack.field_190927_a;
    static final List<AxisAlignedBB> selectionBoxes = Collections.singletonList(Block.field_185505_j);
    static final AxisAlignedBB[] topBounds = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25), new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0)};
    static final AxisAlignedBB[] topBoundsCorner = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.75, 0.75, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 0.25), new AxisAlignedBB(0.75, 0.75, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.75, 0.0, 0.25, 1.0, 1.0)};

    @Override
    public String getModelCacheKey(TileEntity tile, EnumFacing facing) {
        String key = ConveyorHandler.reverseClassRegistry.get(this.getClass()).toString();
        key = key + "f" + facing.ordinal();
        key = key + "a" + (this.isActive(tile) ? 1 : 0);
        key = key + "b" + (this.renderBottomBelt(tile, facing) ? "1" + (this.isInwardConveyor(tile, facing.func_176734_d()) ? "1" : "0") + (this.renderBottomWall(tile, facing, 0) ? "1" : "0") + (this.renderBottomWall(tile, facing, 1) ? "1" : "0") : "0000");
        key = key + "c" + this.getDyeColour();
        if (!this.cover.func_190926_b()) {
            key = key + "s" + this.cover.func_77973_b().getRegistryName() + this.cover.func_77960_j();
        }
        return key;
    }

    @Override
    public void onEntityCollision(TileEntity tile, Entity entity, EnumFacing facing) {
        super.onEntityCollision(tile, entity, facing);
        if (entity instanceof EntityItem) {
            ((EntityItem)entity).func_174867_a(10);
        }
    }

    @Override
    public void onItemDeployed(TileEntity tile, EntityItem entity, EnumFacing facing) {
        entity.func_174867_a(10);
    }

    @Override
    public boolean playerInteraction(TileEntity tile, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, EnumFacing side) {
        if (heldItem.func_190926_b() && player.func_70093_af() && !this.cover.func_190926_b()) {
            EntityItem entityitem;
            if (!tile.func_145831_w().field_72995_K && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.cover.func_77946_l(), false)) != null) {
                entityitem.func_174868_q();
            }
            this.cover = ItemStack.field_190927_a;
            return true;
        }
        if (!heldItem.func_190926_b() && !player.func_70093_af()) {
            for (Function<ItemStack, Boolean> func : ConveyorCovered.validCoveyorCovers) {
                EntityItem entityitem;
                if (func.apply((Object)heldItem) != Boolean.TRUE || OreDictionary.itemMatches((ItemStack)this.cover, (ItemStack)heldItem, (boolean)true)) continue;
                if (!tile.func_145831_w().field_72995_K && !this.cover.func_190926_b() && tile.func_145831_w().func_82736_K().func_82766_b("doTileDrops") && (entityitem = player.func_71019_a(this.cover.func_77946_l(), false)) != null) {
                    entityitem.func_174868_q();
                }
                this.cover = Utils.copyStackWithAmount(heldItem, 1);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() <= 0) {
                    player.func_184611_a(hand, heldItem);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getSelectionBoxes(TileEntity tile, EnumFacing facing) {
        return selectionBoxes;
    }

    @Override
    public List<AxisAlignedBB> getColisionBoxes(TileEntity tile, EnumFacing facing) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        boolean bottom = this.renderBottomBelt(tile, facing);
        if (facing.ordinal() > 1) {
            list.add(verticalBounds[facing.ordinal() - 2]);
            list.add((bottom ? topBoundsCorner : topBounds)[facing.ordinal() - 2]);
        }
        if (bottom || list.isEmpty()) {
            list.add(conveyorBounds);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> modifyQuads(List<BakedQuad> baseModel, @Nullable TileEntity tile, EnumFacing facing) {
        boolean[] walls;
        boolean renderBottom;
        boolean bl = renderBottom = tile != null && this.renderBottomBelt(tile, facing);
        if (renderBottom) {
            TextureAtlasSprite sprite = ClientUtils.getSprite(this.isActive(tile) ? ConveyorBasic.texture_on : ConveyorBasic.texture_off);
            TextureAtlasSprite spriteColour = ClientUtils.getSprite(this.getColouredStripesTexture());
            walls = new boolean[]{this.renderBottomWall(tile, facing, 0), this.renderBottomWall(tile, facing, 1)};
            baseModel.addAll(ModelConveyor.getBaseConveyor(facing, 0.875f, new Matrix4(facing), ConveyorHandler.ConveyorDirection.HORIZONTAL, sprite, walls, new boolean[]{true, false}, spriteColour, this.getDyeColour()));
        } else {
            walls = new boolean[]{true, true};
        }
        ItemStack cover = !this.cover.func_190926_b() ? this.cover : ConveyorCovered.defaultCover;
        Block b = Block.func_149634_a((Item)cover.func_77973_b());
        IBlockState state = !cover.func_190926_b() ? b.func_176203_a(cover.func_77960_j()) : Blocks.field_150348_b.func_176223_P();
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
        if (model != null) {
            TextureAtlasSprite sprite = model.func_177554_e();
            HashMap<EnumFacing, TextureAtlasSprite> sprites = new HashMap<EnumFacing, TextureAtlasSprite>();
            for (EnumFacing f2 : EnumFacing.field_82609_l) {
                for (BakedQuad q : model.func_188616_a(state, f2, 0L)) {
                    if (q == null || q.func_187508_a() == null) continue;
                    sprites.put(f2, q.func_187508_a());
                }
            }
            for (BakedQuad q : model.func_188616_a(state, null, 0L)) {
                if (q == null || q.func_187508_a() == null || q.func_178210_d() == null) continue;
                sprites.put(q.func_178210_d(), q.func_187508_a());
            }
            java.util.function.Function<EnumFacing, TextureAtlasSprite> getSprite = f -> sprites.containsKey(f) ? (TextureAtlasSprite)sprites.get(f) : sprite;
            float[] colour = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            Matrix4 matrix = new Matrix4(facing);
            if (!renderBottom) {
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.0f, 0.75f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.0f, 0.1875f), new Vector3f(0.0625f, 1.0f, 0.75f), matrix, facing, getSprite, colour));
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.0f, 0.1875f), new Vector3f(1.0f, 1.0f, 0.75f), matrix, facing, getSprite, colour));
            } else {
                boolean straightInput = tile != null && this.isInwardConveyor(tile, facing.func_176734_d());
                baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.9375f, 0.75f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
                if (!straightInput) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.75f, 0.9375f), new Vector3f(1.0f, 1.0f, 1.0f), matrix, facing, getSprite, colour));
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.9375f), new Vector3f(0.0625f, 0.75f, 1.0f), matrix, facing, getSprite, colour));
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.9375f), new Vector3f(1.0f, 0.75f, 1.0f), matrix, facing, getSprite, colour));
                }
                if (walls[0]) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.1875f, 0.1875f), new Vector3f(0.0625f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.0f, 0.75f, 0.1875f), new Vector3f(0.0625f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
                }
                if (walls[1]) {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.1875f, 0.1875f), new Vector3f(1.0f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
                } else {
                    baseModel.addAll(ClientUtils.createBakedBox(new Vector3f(0.9375f, 0.75f, 0.1875f), new Vector3f(1.0f, 1.0f, 0.9375f), matrix, facing, getSprite, colour));
                }
            }
        }
        return baseModel;
    }

    @Override
    public NBTTagCompound writeConveyorNBT() {
        NBTTagCompound nbt = super.writeConveyorNBT();
        if (this.cover != null) {
            nbt.func_74782_a("cover", (NBTBase)this.cover.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void readConveyorNBT(NBTTagCompound nbt) {
        super.readConveyorNBT(nbt);
        this.cover = new ItemStack(nbt.func_74775_l("cover"));
    }
}

