/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemDrill
extends ItemUpgradeableTool
implements IEItemInterfaces.IAdvancedFluidItem,
IOBJModelCallback<ItemStack>,
ITool {
    public static Material[] validMaterials = new Material[]{Material.field_151574_g, Material.field_151571_B, Material.field_151592_s, Material.field_151577_b, Material.field_151578_c, Material.field_151588_w, Material.field_151573_f, Material.field_151598_x, Material.field_76233_E, Material.field_151576_e, Material.field_151595_p, Material.field_151597_y};
    public static HashMap<String, Integer> animationTimer = new HashMap();
    private static final Matrix4 matAugers = new Matrix4().translate(0.441f, 0.0, 0.0);

    public ItemDrill() {
        super("drill", 1, "DRILL", new String[]{"diesel"});
    }

    @Override
    public int getSlotCount(ItemStack stack) {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.DrillHead(inv, 0, 98, 22), new IESlot.Upgrades(container, inv, 1, 78, 52, "DRILL", stack, true), new IESlot.Upgrades(container, inv, 2, 98, 52, "DRILL", stack, true), new IESlot.Upgrades(container, inv, 3, 118, 52, "DRILL", stack, true)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack, 2000)) {
            fs.amount = this.getCapacity(stack, 2000);
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack, 2000)) {
            fs.amount = this.getCapacity(stack, 2000);
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.fuel", (Object[])new Object[0]) + " " + fs.amount + "/" + this.getCapacity(stack, 2000) + "mB");
        } else {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.empty", (Object[])new Object[0]));
        }
        if (this.getHead(stack).func_190926_b()) {
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.noHead", (Object[])new Object[0]));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            String status = "" + ((double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN)));
            list.add(I18n.func_135052_a((String)"desc.immersiveengineering.flavour.drill.headDamage", (Object[])new Object[0]) + " " + status + dmg + "/" + maxDmg);
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (this.canDrillBeUsed(stack, entityLiving)) {
            if (!animationTimer.containsKey(entityLiving.func_70005_c_())) {
                animationTimer.put(entityLiving.func_70005_c_(), 40);
            } else if (animationTimer.get(entityLiving.func_70005_c_()) < 20) {
                animationTimer.put(entityLiving.func_70005_c_(), 20);
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String material) {
        if (material.equals("head") && !this.getHead(stack).func_190926_b() && this.getHead(stack).func_77973_b() instanceof IDrillHead) {
            TextureAtlasSprite spr = ((IDrillHead)this.getHead(stack).func_77973_b()).getDrillTexture(stack, this.getHead(stack));
            return spr;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if (group.equals("drill_frame") || group.equals("drill_grip")) {
            return true;
        }
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (group.equals("upgrade_waterproof")) {
            return upgrades.func_74767_n("waterproof");
        }
        if (group.equals("upgrade_speed")) {
            return upgrades.func_74767_n("oiled");
        }
        if (!this.getHead(stack).func_190926_b()) {
            if (group.equals("drill_head")) {
                return true;
            }
            if (group.equals("upgrade_damage0")) {
                return upgrades.func_74762_e("damage") > 0;
            }
            if (group.equals("upgrade_damage1") || group.equals("upgrade_damage2")) {
                return upgrades.func_74762_e("damage") > 1;
            }
            if (group.equals("upgrade_damage3") || group.equals("upgrade_damage4")) {
                return upgrades.func_74762_e("damage") > 2;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Optional<TRSRTransformation> applyTransformations(ItemStack stack, String group, Optional<TRSRTransformation> transform) {
        if (transform.isPresent()) {
            NBTTagCompound upgrades = this.getUpgrades(stack);
            if (group.equals("drill_head") && upgrades.func_74762_e("damage") <= 0) {
                Matrix4 mat = new Matrix4(transform.get().getMatrix());
                mat.translate(-0.25, 0.0, 0.0);
                return Optional.of(new TRSRTransformation(mat.toMatrix4f()));
            }
            if (!Config.IEConfig.fancyItemAnimations && group.startsWith("upgrade_damage") && !"upgrade_damage0".equals(group)) {
                Matrix4 mat = new Matrix4(transform.get().getMatrix());
                mat.translate(0.441f, 0.0, 0.0);
                return Optional.of(new TRSRTransformation(mat.toMatrix4f()));
            }
        }
        return transform;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isDynamicGroup(ItemStack stack, String group) {
        return "drill_head".equals(group) || "upgrade_damage0".equals(group) || "upgrade_damage1".equals(group) || "upgrade_damage2".equals(group) || "upgrade_damage3".equals(group) || "upgrade_damage4".equals(group);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Matrix4 dynamicChanges(ItemStack stack, String group, ItemCameraTransforms.TransformType cameraTransformType, @Nullable EntityLivingBase entity) {
        if (!(entity == null || !this.canDrillBeUsed(stack, entity) || entity.func_184586_b(EnumHand.MAIN_HAND) != stack && entity.func_184586_b(EnumHand.OFF_HAND) != stack || cameraTransformType != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && cameraTransformType != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && cameraTransformType != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && cameraTransformType != ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND)) {
            float angle = (float)(entity.field_70173_aa % 60) / 60.0f * 6.28218f;
            if ("drill_head".equals(group) || "upgrade_damage0".equals(group)) {
                return new Matrix4().rotate(angle, 1.0, 0.0, 0.0);
            }
            if ("upgrade_damage1".equals(group) || "upgrade_damage2".equals(group)) {
                return new Matrix4().translate(0.441f, 0.0, 0.0).rotate(angle, 0.0, 1.0, 0.0);
            }
            if ("upgrade_damage3".equals(group) || "upgrade_damage4".equals(group)) {
                return new Matrix4().translate(0.441f, 0.0, 0.0).rotate(angle, 0.0, 0.0, 1.0);
            }
        } else if ("upgrade_damage1".equals(group) || "upgrade_damage2".equals(group) || "upgrade_damage3".equals(group) || "upgrade_damage4".equals(group)) {
            return matAugers;
        }
        return null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getHeadDamage(stack) / (double)this.getMaxHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.BOW;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (!(inv == null || inv.getStackInSlot(0).func_190926_b() || inv.getStackInSlot(1).func_190926_b() || inv.getStackInSlot(2).func_190926_b() || inv.getStackInSlot(3).func_190926_b())) {
            Utils.unlockIEAdvancement(player, "main/upgrade_drill");
        }
    }

    public ItemStack getHead(ItemStack drill) {
        ItemStack head = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? ((IItemHandler)drill.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0) : new ItemStack(ItemNBTHelper.getTagCompound(drill, "head"));
        return !head.func_190926_b() && head.func_77973_b() instanceof IDrillHead ? head : ItemStack.field_190927_a;
    }

    public void setHead(ItemStack drill, ItemStack head) {
        IItemHandler inv = (IItemHandler)drill.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ((IItemHandlerModifiable)inv).setStackInSlot(0, head);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public boolean canDrillBeUsed(ItemStack drill, EntityLivingBase player) {
        if (drill.func_77952_i() == 0 && player.func_70055_a(Material.field_151586_h) && !this.getUpgrades(drill).func_74767_n("waterproof")) {
            return false;
        }
        return drill.func_77952_i() != 0 || this.getFluid(drill) != null;
    }

    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.func_190926_b() ? ((IDrillHead)head.func_77973_b()).getMaximumHeadDamage(head) : 0;
    }

    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.func_190926_b() ? ((IDrillHead)head.func_77973_b()).getHeadDamage(head) : 0;
    }

    public boolean isDrillBroken(ItemStack stack) {
        return this.getHeadDamage(stack) >= this.getMaxHeadDamage(stack) || this.getFluid(stack) == null || this.getFluid((ItemStack)stack).amount < 1;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase player) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase living) {
        if ((double)state.func_185887_b(world, pos) != 0.0) {
            int dmg = ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack) ? 1 : 3;
            ItemStack head = this.getHead(stack);
            if (!head.func_190926_b()) {
                if (living instanceof EntityPlayer) {
                    if (((EntityPlayer)living).field_71075_bZ.field_75098_d) {
                        return true;
                    }
                    ((IDrillHead)head.func_77973_b()).afterBlockbreak(stack, head, (EntityPlayer)living);
                }
                if (!this.getUpgrades(stack).func_74767_n("oiled") || Utils.RAND.nextInt(4) == 0) {
                    ((IDrillHead)head.func_77973_b()).damageHead(head, dmg);
                }
                this.setHead(stack, head);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack);
                handler.drain(1, true);
            }
        }
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    public Multimap getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        ItemStack head;
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && !(head = this.getHead(stack)).func_190926_b()) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)(((IDrillHead)head.func_77973_b()).getAttackDamage(head) + (float)this.getUpgrades(stack).func_74762_e("damage")), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, 0));
        }
        return multimap;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        ItemStack head = this.getHead(stack);
        if (!head.func_190926_b()) {
            return ((IDrillHead)head.func_77973_b()).getMiningLevel(head) + ItemNBTHelper.getInt(stack, "harvestLevel");
        }
        return 0;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        if (!this.getHead(stack).func_190926_b() && !this.isDrillBroken(stack)) {
            return ImmutableSet.of((Object)"pickaxe");
        }
        return super.getToolClasses(stack);
    }

    public boolean isEffective(Material mat) {
        for (Material m : validMaterials) {
            if (m != mat) continue;
            return true;
        }
        return false;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.isEffective(state.func_185904_a()) && !this.isDrillBroken(stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        ItemStack head = this.getHead(stack);
        if (!head.func_190926_b() && !this.isDrillBroken(stack)) {
            return ((IDrillHead)head.func_77973_b()).getMiningSpeed(head) + this.getUpgrades(stack).func_74760_g("speed");
        }
        return super.func_150893_a(stack, state);
    }

    public boolean canBreakExtraBlock(World world, Block block, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack drill, ItemStack head, boolean inWorld) {
        if (block.canHarvestBlock((IBlockAccess)world, pos, player) && this.isEffective(state.func_185904_a()) && !this.isDrillBroken(drill)) {
            if (inWorld) {
                return !((IDrillHead)head.func_77973_b()).beforeBlockbreak(drill, head, player);
            }
            return true;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos iPos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (player.func_70093_af() || world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return false;
        }
        RayTraceResult mop = this.func_77621_a(world, player, true);
        ItemStack head = this.getHead(stack);
        if (mop == null || head.func_190926_b() || this.isDrillBroken(stack)) {
            return false;
        }
        ImmutableList<BlockPos> additional = ((IDrillHead)head.func_77973_b()).getExtraBlocksDug(head, world, player, mop);
        for (BlockPos pos : additional) {
            int xpDropEvent;
            IBlockState state;
            Block block;
            if (!world.func_175667_e(pos) || (block = (state = world.func_180495_p(pos)).func_177230_c()) == null || block.isAir(state, (IBlockAccess)world, pos) || state.func_185903_a(player, world, pos) == 0.0f || !this.canBreakExtraBlock(world, block, pos, state, player, stack, head, true) || (xpDropEvent = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos)) < 0) continue;
            if (player.field_71075_bZ.field_75098_d) {
                block.func_176208_a(world, pos, state, player);
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
            } else {
                block.func_176208_a(world, pos, state, player);
                TileEntity te = world.func_175625_s(pos);
                stack.func_179548_a(world, state, pos, player);
                if (block.removedByPlayer(state, world, pos, player, true)) {
                    block.func_176206_d(world, pos, state);
                    block.func_180657_a(world, player, pos, state, te, stack);
                    block.func_180637_b(world, pos, xpDropEvent);
                }
            }
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        }
        return false;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        if (oldStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && newStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null)) {
            CapabilityShader.ShaderWrapper wrapperOld = (CapabilityShader.ShaderWrapper)oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            CapabilityShader.ShaderWrapper wrapperNew = (CapabilityShader.ShaderWrapper)newStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null);
            if (!ItemStack.func_77989_b((ItemStack)wrapperOld.getShaderItem(), (ItemStack)wrapperNew.getShaderItem())) {
                return true;
            }
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                IEItemFluidHandler fluids;
                CapabilityShader.ShaderWrapper_Item shaders;
                {
                    super(stack2);
                    this.fluids = new IEItemFluidHandler(stack, 2000);
                    this.shaders = new CapabilityShader.ShaderWrapper_Item("immersiveengineering:drill", stack);
                }

                @Override
                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityShader.SHADER_CAPABILITY || super.hasCapability(capability, facing);
                }

                @Override
                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return (T)((Object)this.fluids);
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return (T)this.shaders;
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public int getCapacity(ItemStack container, int baseCapacity) {
        return baseCapacity + this.getUpgrades(container).func_74762_e("capacity");
    }

    @Override
    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid != null && DieselHandler.isValidDrillFuel(fluid.getFluid());
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound ret = super.getNBTShareTag(stack);
        ret = ret == null ? new NBTTagCompound() : ret.func_74737_b();
        NBTTagCompound tmp = new NBTTagCompound();
        this.getHead(stack).func_77955_b(tmp);
        ret.func_74782_a("head", (NBTBase)tmp);
        return ret;
    }
}

