/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExtraUtilsHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        Item lillySeeds = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("extrautils2:enderlilly"));
        Block lillyBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("extrautils2:enderlilly"));
        Item orchidSeeds = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("extrautils2:redorchid"));
        Block orchidBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("extrautils2:redorchid"));
        if (lillySeeds != null && lillyBlock != null) {
            ExtraUtilsHelper.registerXUPlant(new ItemStack(lillySeeds), lillyBlock, new ItemStack(Blocks.field_150377_bs), new ItemStack[]{new ItemStack(Items.field_151079_bi)}, 7, 1.25E-5f, false);
        }
        if (orchidSeeds != null && orchidBlock != null) {
            ExtraUtilsHelper.registerXUPlant(new ItemStack(orchidSeeds), orchidBlock, new ItemStack(Blocks.field_150450_ax), new ItemStack[]{new ItemStack(Items.field_151137_ax)}, 6, 0.0125f, true);
        }
    }

    @Override
    public void postInit() {
    }

    static void registerXUPlant(ItemStack seed, Block block, ItemStack soil, ItemStack[] output, final int maxAge, final float growthStep, final boolean useFertilizer) {
        IProperty propGrowth = null;
        final IBlockState state = block.func_176223_P();
        for (IProperty prop : state.func_177227_a()) {
            if (!"growth".equals(prop.func_177701_a())) continue;
            propGrowth = prop;
        }
        if (propGrowth != null) {
            final IProperty finalPropGrowth = propGrowth;
            BelljarHandler.DefaultPlantHandler handler = new BelljarHandler.DefaultPlantHandler(){
                private HashSet<ComparableItemStack> validSeeds = new HashSet();

                @Override
                protected HashSet<ComparableItemStack> getSeedSet() {
                    return this.validSeeds;
                }

                @Override
                public float getGrowthStep(ItemStack seed, ItemStack soil, float growth, TileEntity tile, float fertilizer, boolean render) {
                    return !useFertilizer ? growthStep : growthStep * fertilizer;
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                public IBlockState[] getRenderedPlant(ItemStack seed, ItemStack soil, float growth, TileEntity tile) {
                    return new IBlockState[]{state.func_177226_a(finalPropGrowth, (Comparable)Integer.valueOf(Math.min(maxAge, Math.round((float)maxAge * growth))))};
                }
            };
            handler.register(seed, output, soil, state);
            BelljarHandler.registerHandler(handler);
        }
    }
}

