/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Sets;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

class ContainerContext {
    final Slot slot;
    final InventoryHandler.InventoryMapping slotMapping;
    final EntityPlayerMP player;
    final ImmutableBiMap<IInventory, InventoryHandler.InventoryMapping> mapping;
    private InventoryHandler.InventoryMapping slotTarget;
    static final IInventory PLAYER_HOTBAR = new InventoryBasic("Dummy Hotbar", false, 0);
    static final IInventory PLAYER_MAIN = new InventoryBasic("Dummy Main", false, 0);
    static final IInventory PLAYER_OFFHAND = new InventoryBasic("Dummy Offhand", false, 0);

    private boolean validSlot(Slot slot) {
        return slot.field_75224_c != null && !InventorySorter.INSTANCE.slotblacklist.contains(slot.getClass().getName());
    }

    public ContainerContext(Slot slot, EntityPlayerMP playerEntity) {
        this.slot = slot;
        this.player = playerEntity;
        HashMap<IInventory, InventoryHandler.InventoryMapping> mapping = new HashMap<IInventory, InventoryHandler.InventoryMapping>();
        Container openContainer = playerEntity.field_71070_bA;
        openContainer.field_75151_b.stream().filter(this::validSlot).forEach(sl -> {
            InventoryHandler.InventoryMapping inventoryMapping = mapping.computeIfAbsent(sl.field_75224_c, k -> new InventoryHandler.InventoryMapping(sl.field_75224_c, openContainer, sl.field_75224_c, sl.getClass()));
            inventoryMapping.addSlot((Slot)sl);
            if (sl == slot) {
                this.slotTarget = inventoryMapping;
            }
        });
        if (mapping.containsKey(playerEntity.field_71071_by)) {
            InventoryHandler.InventoryMapping playerMapping = (InventoryHandler.InventoryMapping)mapping.remove(playerEntity.field_71071_by);
            if (this.slotTarget == playerMapping) {
                this.slotTarget = null;
            }
            int mainStart = 9;
            int mainEnd = 36;
            int offhandStart = 40;
            InventoryHandler.InventoryMapping hotbarMapping = new InventoryHandler.InventoryMapping(PLAYER_HOTBAR, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
            InventoryHandler.InventoryMapping mainMapping = new InventoryHandler.InventoryMapping(PLAYER_MAIN, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
            InventoryHandler.InventoryMapping offhandMapping = new InventoryHandler.InventoryMapping(PLAYER_OFFHAND, openContainer, (IInventory)playerEntity.field_71071_by, Slot.class);
            for (int i = playerMapping.begin; i <= playerMapping.end; ++i) {
                InventoryHandler.InventoryMapping inventoryMapping;
                Slot s = openContainer.func_75139_a(i);
                if (s.getSlotIndex() < mainStart && s.field_75224_c == playerEntity.field_71071_by) {
                    hotbarMapping.begin = Math.min(s.field_75222_d, hotbarMapping.begin);
                    hotbarMapping.end = Math.max(s.field_75222_d, hotbarMapping.end);
                    mapping.put(PLAYER_HOTBAR, hotbarMapping);
                    inventoryMapping = hotbarMapping;
                } else if (s.getSlotIndex() < mainEnd && s.field_75224_c == playerEntity.field_71071_by) {
                    mainMapping.begin = Math.min(s.field_75222_d, mainMapping.begin);
                    mainMapping.end = Math.max(s.field_75222_d, mainMapping.end);
                    mapping.put(PLAYER_MAIN, mainMapping);
                    inventoryMapping = mainMapping;
                } else if (s.getSlotIndex() >= offhandStart && s.field_75224_c == playerEntity.field_71071_by) {
                    offhandMapping.begin = Math.min(s.field_75222_d, offhandMapping.begin);
                    offhandMapping.end = Math.max(s.field_75222_d, offhandMapping.end);
                    mapping.put(PLAYER_OFFHAND, offhandMapping);
                    inventoryMapping = offhandMapping;
                } else {
                    inventoryMapping = null;
                }
                if (s != slot) continue;
                this.slotTarget = inventoryMapping;
            }
        }
        for (Map.Entry map : Sets.newLinkedHashSet(mapping.entrySet())) {
            if (!((InventoryHandler.InventoryMapping)map.getValue()).markForRemoval) continue;
            mapping.remove(map.getKey());
            if (this.slotTarget != map.getValue()) continue;
            this.slotTarget = null;
        }
        this.slotMapping = this.slotTarget;
        this.mapping = ImmutableBiMap.copyOf(mapping);
        InventorySorter.INSTANCE.log.log(Level.DEBUG, "Slot mapping {}", new Supplier[]{() -> this.mapping});
        InventorySorter.INSTANCE.log.log(Level.DEBUG, "Action slot {}", new Supplier[]{() -> this.slotMapping});
    }
}

