/*
 * Decompiled with CFR 0.152.
 */
package wiiv.magipsi.client;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import wiiv.magipsi.MagicalPsi;

public class ResourceProxy
extends AbstractResourcePack {
    public static final String[] DEFAULT_RESOURCE_PACKS = new String[]{"aD", "field_110449_ao", "defaultResourcePacks"};
    private static final Set<String> RESOURCE_DOMAINS = ImmutableSet.of((Object)"psi", (Object)"minecraft");
    private static final String PACK_META = "pack.mcmeta";
    private static final String PROXYPACK_META = "/proxypack.mcmeta";
    private static final HashMap<String, Boolean> found = new HashMap();

    public static void init() {
        List resourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])DEFAULT_RESOURCE_PACKS);
        ResourceProxy resourceProxy = new ResourceProxy();
        resourcePacks.add(resourceProxy);
        FMLLog.info((String)"[Magical Psi] Hooked Proxy Resource Pack", (Object[])new Object[0]);
    }

    private ResourceProxy() {
        super(Loader.instance().activeModContainer().getSource());
    }

    public Set<String> func_110587_b() {
        return RESOURCE_DOMAINS;
    }

    protected InputStream func_110591_a(String name) throws IOException {
        if (name == null) {
            return null;
        }
        return this.stream(name);
    }

    protected boolean func_110593_b(String name) {
        if (name.startsWith("assets/minecraft") && !name.contains("creative_inventory")) {
            return false;
        }
        if (!found.containsKey(name)) {
            this.locate(name);
        }
        return found.get(name);
    }

    private void locate(String name) {
        InputStream stream = this.stream(name);
        found.put(name, stream != null);
    }

    private InputStream stream(String name) {
        if (name.equals(PACK_META)) {
            name = PROXYPACK_META;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        if (name.contains("tab_psi.png")) {
            name = "/assets/magipsi/textures/misc/tab_psi.png";
        }
        name = name.replaceAll("\\/assets\\/psi", "/assets/magipsi");
        return MagicalPsi.class.getResourceAsStream(name);
    }

    protected void func_110594_c(String name) {
    }

    public String func_130077_b() {
        return "magipsi-texture-proxy";
    }
}

