/*
 * Decompiled with CFR 0.152.
 */
package reborncore;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import reborncore.common.LootManager;
import reborncore.common.util.RebornCraftingHelper;

public class RebornRegistry {
    public static LootManager.InnerPool lp = new LootManager.InnerPool();

    public static void registerBlock(Block block, String name) {
        block.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)block);
        ItemBlock itemBlock = new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        GameData.register_impl((IForgeRegistryEntry)itemBlock);
    }

    public static void registerBlock(Block block, ResourceLocation name) {
        block.setRegistryName(name);
        ItemBlock itemBlock = new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        GameData.register_impl((IForgeRegistryEntry)itemBlock);
        GameData.register_impl((IForgeRegistryEntry)block);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name) {
        block.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)block);
        try {
            ItemBlock itemBlock = itemclass.getConstructor(Block.class).newInstance(block);
            itemBlock.setRegistryName(name);
            GameData.register_impl((IForgeRegistryEntry)itemBlock);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, ResourceLocation name) {
        block.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)block);
        try {
            ItemBlock itemBlock = itemclass.getConstructor(Block.class).newInstance(block);
            itemBlock.setRegistryName(name);
            GameData.register_impl((IForgeRegistryEntry)itemBlock);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void registerBlock(Block block) {
        GameData.register_impl((IForgeRegistryEntry)block);
        ItemBlock itemBlock = new ItemBlock(block);
        itemBlock.setRegistryName(block.getRegistryName());
        GameData.register_impl((IForgeRegistryEntry)itemBlock);
    }

    public static void registerItem(Item item) {
        GameData.register_impl((IForgeRegistryEntry)item);
    }

    public static void registerItem(Item item, ResourceLocation name) {
        item.setRegistryName(name);
        GameData.register_impl((IForgeRegistryEntry)item);
    }

    public static void addShapedOreRecipe(ItemStack output, Object parm) {
        RebornCraftingHelper.addShapedOreRecipe(output, parm);
    }

    public static void addShapelessOreRecipe(ItemStack output, Object parm) {
        RebornCraftingHelper.addShapelessOreRecipe(output, parm);
    }

    public static void addLoot(Item item, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, chance, list));
    }

    public static void addLoot(Item item, int minSize, int maxSize, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, minSize, maxSize, chance, list));
    }

    public static void addLoot(Item item, int ordinal, int minSize, int maxSize, double chance, ResourceLocation list) {
        lp.addItem(LootManager.createLootEntry(item, ordinal, minSize, maxSize, chance, list));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item i, int meta) {
        ResourceLocation loc = i.getRegistryName();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Block b, int meta) {
        RebornRegistry.registerItemModel(Item.func_150898_a((Block)b), meta);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item i, int meta, String variant) {
        ResourceLocation loc = i.getRegistryName();
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "type=" + variant));
    }
}

