/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.hud;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.Color;

public class StackInfoHUD {
    public static final StackInfoHUD instance = new StackInfoHUD();
    public static boolean showHud = true;
    public static boolean bottom = true;
    public static List<StackInfoElement> ELEMENTS = new ArrayList<StackInfoElement>();
    private static Minecraft mc = Minecraft.func_71410_x();
    private final int yDef = 7;
    private int x = 2;
    private int y = 7;

    public static void registerElement(StackInfoElement element) {
        ELEMENTS.add(element);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderExperienceBar(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if ((StackInfoHUD.mc.field_71415_G || StackInfoHUD.mc.field_71462_r != null && StackInfoHUD.mc.field_71474_y.field_74330_P) && RebornCoreConfig.ShowStackInfoHUD) {
            this.drawStackInfoHud(event.getResolution());
        }
    }

    public void drawStackInfoHud(ScaledResolution res) {
        EntityPlayerSP player = StackInfoHUD.mc.field_71439_g;
        this.y = 7;
        if (showHud) {
            List<Object> stacks = new ArrayList<ItemStack>();
            for (ItemStack stack : player.func_184193_aE()) {
                stacks.add(stack);
            }
            stacks.add(player.func_184592_cb());
            stacks.add(player.func_184614_ca());
            if (bottom) {
                stacks = Lists.reverse(stacks);
            }
            for (ItemStack stack : stacks) {
                this.addInfo(stack);
            }
        }
    }

    public void renderItemStack(ItemStack stack, int x, int y) {
        if (stack != ItemStack.field_190927_a) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            RenderHelper.func_74520_c();
            RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
            itemRenderer.func_180450_b(stack, x, y);
            GL11.glDisable((int)2896);
        }
    }

    private void renderStackForInfo(ItemStack stack) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        RenderHelper.func_74519_b();
        RenderHelper.func_74520_c();
        this.renderItemStack(stack, this.x, this.y - 5);
    }

    private void addInfo(ItemStack stack) {
        if (stack != ItemStack.field_190927_a) {
            String text = "";
            boolean didShit = false;
            Color gold = Color.GOLD;
            Color grey = Color.GRAY;
            if (stack.func_77973_b() instanceof IEnergyInterfaceItem) {
                double MaxCharge = ((IEnergyInterfaceItem)stack.func_77973_b()).getMaxPower(stack);
                double CurrentCharge = ((IEnergyInterfaceItem)stack.func_77973_b()).getEnergy(stack);
                Color color = Color.GREEN;
                double quarter = MaxCharge / 4.0;
                double half = MaxCharge / 2.0;
                this.renderStackForInfo(stack);
                if (CurrentCharge <= half) {
                    color = Color.YELLOW;
                }
                if (CurrentCharge <= quarter) {
                    color = Color.DARK_RED;
                }
                text = (Object)((Object)color) + PowerSystem.getLocaliszedPowerFormattedNoSuffix(CurrentCharge) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix(MaxCharge) + " " + PowerSystem.getDisplayPower().abbreviation + (Object)((Object)grey);
                if (stack.func_77978_p() != null && stack.func_77942_o() && stack.func_77978_p().func_74764_b("isActive")) {
                    text = stack.func_77978_p().func_74767_n("isActive") ? text + (Object)((Object)gold) + " (" + I18n.func_74838_a((String)"reborncore.message.active") + ")" + (Object)((Object)grey) : text + (Object)((Object)gold) + " (" + I18n.func_74838_a((String)"reborncore.message.inactive") + ")" + (Object)((Object)grey);
                }
                StackInfoHUD.mc.field_71466_p.func_175063_a(text, (float)(this.x + 18), (float)this.y, 0);
                this.y += 20;
            }
            for (StackInfoElement element : ELEMENTS) {
                if (element.getText(stack).equals("")) continue;
                this.renderStackForInfo(stack);
                StackInfoHUD.mc.field_71466_p.func_175063_a(element.getText(stack), (float)(this.x + 18), (float)this.y, 0);
                this.y += 20;
            }
        }
    }
}

