/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.multiblock;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.client.multiblock.component.MultiblockComponent;

public class MultiblockRenderEvent {
    public static BlockPos anchor;
    private static BlockRendererDispatcher blockRender;
    public MultiblockSet currentMultiblock;
    public BlockPos parent;

    public void setMultiblock(MultiblockSet set) {
        this.currentMultiblock = set;
        anchor = null;
        this.parent = null;
    }

    @SubscribeEvent
    public void onWorldRenderLast(RenderWorldLastEvent event) throws Throwable {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71476_x != null && !mc.field_71439_g.func_70093_af() && this.currentMultiblock != null) {
            BlockPos anchorPos = anchor != null ? anchor : mc.field_71476_x.func_178782_a();
            Multiblock mb = this.currentMultiblock.getForIndex(0);
            for (MultiblockComponent comp : mb.getComponents()) {
                this.renderComponent(comp, anchorPos.func_177984_a(), event.getPartialTicks(), mc.field_71439_g);
            }
        }
    }

    private void renderComponent(MultiblockComponent comp, BlockPos anchor, float partialTicks, EntityPlayerSP player) {
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        BlockPos pos = anchor.func_177971_a((Vec3i)comp.getRelativePosition());
        Minecraft minecraft = Minecraft.func_71410_x();
        World world = player.field_70170_p;
        minecraft.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        BlockRenderLayer originalLayer = MinecraftForgeClient.getRenderLayer();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.CUTOUT);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)pos.func_177958_n() - dx), (double)((double)pos.func_177956_o() - dy), (double)((double)pos.func_177952_p() - dz));
        GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
        GlStateManager.func_179137_b((double)0.2, (double)0.2, (double)0.2);
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int alpha = 0x7F000000;
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179143_c((int)515);
        this.renderModel(world, pos, alpha, comp.state);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)originalLayer);
    }

    private void renderModel(World world, BlockPos pos, int alpha, IBlockState state) {
        IBakedModel model = blockRender.func_184389_a(state);
        IBlockState extendedState = state.func_177230_c().getExtendedState(state, (IBlockAccess)world, pos);
        for (EnumFacing facing : EnumFacing.values()) {
            this.renderQuads(world, state, pos, model.func_188616_a(extendedState, facing, 0L), alpha);
        }
        this.renderQuads(world, state, pos, model.func_188616_a(extendedState, null, 0L), alpha);
    }

    private void renderQuads(World world, IBlockState actualState, BlockPos pos, List<BakedQuad> quads, int alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        if (quads == null || quads.isEmpty()) {
            return;
        }
        for (BakedQuad quad : quads) {
            buffer.func_181668_a(7, quad.getFormat());
            int color = quad.func_178212_b() ? this.getTint(world, actualState, pos, alpha, quad.func_178211_c()) : alpha | 0xFFFFFF;
            LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)quad, (int)color);
            tessellator.func_78381_a();
        }
    }

    private int getTint(World world, IBlockState actualState, BlockPos pos, int alpha, int tintIndex) {
        return alpha | Minecraft.func_71410_x().func_184125_al().func_186724_a(actualState, (IBlockAccess)world, pos, tintIndex);
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.BreakEvent event) {
        if (this.parent != null && event.getPos().func_177958_n() == this.parent.func_177958_n() && event.getPos().func_177956_o() == this.parent.func_177956_o() && event.getPos().func_177952_p() == this.parent.func_177952_p()) {
            this.setMultiblock(null);
        }
    }

    @SubscribeEvent
    public void worldUnloaded(WorldEvent.Unload event) {
        this.setMultiblock(null);
    }

    static {
        blockRender = Minecraft.func_71410_x().func_175602_ab();
    }
}

