/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import reborncore.api.IToolDrop;
import reborncore.api.ToolManager;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.api.tile.IUpgrade;
import reborncore.api.tile.IUpgradeable;
import reborncore.common.BaseTileBlock;
import reborncore.common.RebornCoreConfig;
import reborncore.common.tile.TileMachineBase;
import reborncore.common.util.InventoryHelper;
import reborncore.common.util.WorldUtils;

public abstract class BlockMachineBase
extends BaseTileBlock {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static ItemStack basicFrameStack;
    public static ItemStack advancedFrameStack;
    boolean hasCustomStaes;

    public BlockMachineBase() {
        this(false);
    }

    public BlockMachineBase(boolean hasCustomStates) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.hasCustomStaes = hasCustomStates;
        if (!hasCustomStates) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.setFacing(placer.func_174811_aO().func_176734_d(), worldIn, pos);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        this.dropInventory(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    protected void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        this.addItemsToList(inventory, items);
        if (tileEntity instanceof IUpgradeable) {
            this.addItemsToList(((IUpgradeable)tileEntity).getUpgradeInvetory(), items);
        }
        WorldUtils.dropItems(items, world, pos);
    }

    private void addItemsToList(IInventory inventory, List<ItemStack> items) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == ItemStack.field_190927_a || itemStack != ItemStack.field_190927_a && itemStack.func_190916_E() > 0 && itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockDynamicLiquid)) continue;
            items.add(itemStack.func_77946_l());
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList items = NonNullList.func_191196_a();
        if (RebornCoreConfig.wrenchRequired) {
            items.add((Object)(this.isAdvanced() ? advancedFrameStack.func_77946_l() : basicFrameStack.func_77946_l()));
        } else {
            super.getDrops(items, world, pos, state, fortune);
        }
        return items;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (axis == null) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileMachineBase) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)axis));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (this.fillBlockWithFluid(worldIn, pos, playerIn)) {
            return true;
        }
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        if (playerIn.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() instanceof IUpgrade && (tileEntity = worldIn.func_175625_s(pos)) instanceof IUpgradeable && ((IUpgradeable)tileEntity).canBeUpgraded() && InventoryHelper.testInventoryInsertion(((IUpgradeable)tileEntity).getUpgradeInvetory(), stack, null) > 0) {
            InventoryHelper.insertItemIntoInventory(((IUpgradeable)tileEntity).getUpgradeInvetory(), stack);
            playerIn.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            return true;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack)) {
            if (!ToolManager.INSTANCE.handleTool(stack, pos, worldIn, playerIn, side, false)) return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
            tileEntity = worldIn.func_175625_s(pos);
            if (playerIn.func_70093_af()) {
                if (!(tileEntity instanceof IToolDrop)) return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
                ItemStack drop = ((IToolDrop)tileEntity).getToolDrop(playerIn);
                if (drop == null) {
                    return false;
                }
                if (!drop.func_190926_b()) {
                    BlockMachineBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)drop);
                }
                if (worldIn.field_72995_K) return true;
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                return true;
            }
            tileEntity.func_189667_a(Rotation.CLOCKWISE_90);
            return true;
        }
        if (this.getGui() == null || playerIn.func_70093_af()) return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        this.getGui().open(playerIn, pos, worldIn);
        return true;
    }

    public boolean fillBlockWithFluid(World world, BlockPos pos, EntityPlayer entityplayer) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 4;
        return facingInt + activeInt;
    }

    public IBlockState func_176203_a(int meta) {
        boolean active = false;
        int facingInt = meta;
        if (facingInt > 4) {
            active = true;
            facingInt -= 4;
        }
        EnumFacing facing = this.getSideFromint(facingInt);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public boolean isActive(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        if (this.hasCustomStaes) {
            return;
        }
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public void setActive(Boolean active, World world, BlockPos pos) {
        if (this.hasCustomStaes) {
            return;
        }
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)active).func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 3);
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return 0;
    }

    public abstract IMachineGuiHandler getGui();
}

