/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.misc;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Deprecated
public class Location
implements Comparable<Location> {
    public int x;
    public int y;
    public int z;
    public int depth;
    public World world;

    public Location(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(int x, int y, int z, int depth) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.depth = depth;
    }

    public Location(int x, int y, int z, int depth, World world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.depth = depth;
        this.world = world;
    }

    public Location(int x, int y, int z, World world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
    }

    public Location(int xCoord, int yCoord, int zCoord, EnumFacing dir) {
        this.x = xCoord + dir.func_82601_c();
        this.y = yCoord + dir.func_96559_d();
        this.z = zCoord + dir.func_82599_e();
    }

    public Location(int[] coords) {
        if (coords.length >= 2) {
            this.x = coords[0];
            this.y = coords[1];
            this.z = coords[2];
        }
    }

    public Location(BlockPos pos) {
        if (pos != null) {
            this.x = pos.func_177958_n();
            this.y = pos.func_177952_p();
            this.z = pos.func_177956_o();
        }
    }

    public Location(RayTraceResult blockLookedAt) {
        if (blockLookedAt != null) {
            this.x = blockLookedAt.func_178782_a().func_177958_n();
            this.y = blockLookedAt.func_178782_a().func_177956_o();
            this.z = blockLookedAt.func_178782_a().func_177952_p();
        }
    }

    public Location(TileEntity par1) {
        this.x = par1.func_174877_v().func_177958_n();
        this.y = par1.func_174877_v().func_177956_o();
        this.z = par1.func_174877_v().func_177952_p();
    }

    public boolean equals(Location toTest) {
        return this.x == toTest.x && this.y == toTest.y && this.z == toTest.z;
    }

    public void setLocation(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int newX) {
        this.x = newX;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int newY) {
        this.y = newY;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int newZ) {
        this.z = newZ;
    }

    public int[] getLocation() {
        int[] ret = new int[]{this.x, this.y, this.z};
        return ret;
    }

    public void setLocation(int[] coords) {
        this.x = coords[0];
        this.y = coords[1];
        this.z = coords[2];
    }

    public int getDifference(Location otherLoc) {
        return (int)Math.sqrt(Math.pow(this.x - otherLoc.x, 2.0) + Math.pow(this.y - otherLoc.y, 2.0) + Math.pow(this.z - otherLoc.z, 2.0));
    }

    public String printLocation() {
        return "X: " + this.x + " Y: " + this.y + " Z: " + this.z;
    }

    public String printCoords() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public boolean compare(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public Location getLocation(EnumFacing dir) {
        return new Location(this.x + dir.func_82601_c(), this.y + dir.func_96559_d(), this.z + dir.func_82599_e());
    }

    public Location modifyPositionFromSide(EnumFacing side, int amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
        return this;
    }

    public Location modifyPositionFromSide(EnumFacing side) {
        return this.modifyPositionFromSide(side, 1);
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_175625_s(new BlockPos(this.x, this.y, this.z));
    }

    public final Location clone() {
        return new Location(this.x, this.y, this.z);
    }

    public TileEntity getTileEntityOnSide(World world, EnumFacing side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side.ordinal()) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return null;
            }
        }
        if (world.func_175667_e(this.getBlockPos())) {
            return world.func_175625_s(this.getBlockPos());
        }
        return null;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public TileEntity getTileEntityOnSide(World world, int side) {
        int x = this.x;
        int y = this.y;
        int z = this.z;
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
                break;
            }
            default: {
                return null;
            }
        }
        if (world.func_175667_e(this.getBlockPos())) {
            return world.func_175625_s(this.getBlockPos());
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public int compareTo(Location o) {
        return Integer.valueOf(this.depth).compareTo(o.depth);
    }

    public World getWorld() {
        return this.world;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public String toString() {
        return "Location{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", depth=" + this.depth + ", world=" + this.world + '}';
    }
}

