/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem;

import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.api.power.IPowerConfig;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.powerSystem.forge.ForgePowerManager;
import reborncore.common.powerSystem.tesla.TeslaManager;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.StringUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public abstract class TilePowerAcceptor
extends TileLegacyMachineBase
implements IEnergyInterfaceTile,
IListInfoProvider,
IEnergyTile,
IEnergySink,
IEnergySource {
    private EnumPowerTier tier;
    protected boolean addedToEnet;
    ForgePowerManager forgePowerManager = new ForgePowerManager(this, null);
    private double energy;
    public double extraPowerStoage;
    public int extraTeir;

    public void setExtraPowerStoage(double extraPowerStoage) {
        this.extraPowerStoage = extraPowerStoage;
    }

    public TilePowerAcceptor() {
        this.checkTeir();
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.created(this);
        }
    }

    public TilePowerAcceptor(EnumPowerTier tier) {
        this.checkTeir();
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.created(this);
        }
    }

    public void checkTeir() {
        if (this.getBaseTier() == null) {
            this.tier = this.getMaxInput() == 0.0 ? EnumPowerTier.getTeir((int)this.getBaseMaxOutput()) : EnumPowerTier.getTeir((int)this.getBaseMaxInput());
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        HashMap<EnumFacing, TileEntity> acceptors = new HashMap<EnumFacing, TileEntity>();
        if (this.getEnergy() > 0.0 && !this.field_145850_b.field_72995_K) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tile;
                if (!this.canProvideEnergy(side) || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side))) == null) continue;
                acceptors.put(side, tile);
            }
        }
        if (acceptors.size() > 0) {
            double drain = this.useEnergy(Math.min(this.getEnergy(), this.getMaxOutput()), true);
            double energyShare = drain / (double)acceptors.size();
            double remainingEnergy = drain;
            if (energyShare > 0.0) {
                for (Map.Entry entry : acceptors.entrySet()) {
                    EnumFacing side = (EnumFacing)entry.getKey();
                    TileEntity tile = (TileEntity)entry.getValue();
                    if (tile instanceof IEnergyInterfaceTile) {
                        IEnergyInterfaceTile eFace = (IEnergyInterfaceTile)tile;
                        if (!eFace.canAcceptEnergy(side.func_176734_d())) continue;
                        if (this.handleTierWithPower() && eFace.getTier().ordinal() < this.getPushingTier().ordinal()) {
                            for (int j = 0; j < 2; ++j) {
                                double d3 = (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble() + (double)(side.func_82601_c() / 2);
                                double d8 = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() + 1.0;
                                double d13 = (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble() + (double)(side.func_82599_e() / 2);
                                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                            }
                            continue;
                        }
                        double filled = eFace.addEnergy(Math.min(energyShare, remainingEnergy), false);
                        remainingEnergy -= this.useEnergy(filled, false);
                        continue;
                    }
                    if (tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) {
                        IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
                        if (this.forgePowerManager == null || energyStorage == null || !energyStorage.canReceive() || !this.canProvideEnergy(side)) continue;
                        int filled = energyStorage.receiveEnergy((int)Math.min(energyShare, remainingEnergy) * RebornCoreConfig.euPerFU, false);
                        remainingEnergy -= this.useEnergy(filled / RebornCoreConfig.euPerFU, false);
                        continue;
                    }
                    if (!TeslaManager.isTeslaEnabled(this.getPowerConfig())) continue;
                    TeslaManager.manager.update(this);
                }
            }
        }
        if (RebornCoreConfig.isIC2Loaded && this.getPowerConfig().eu() && Info.isIc2Available()) {
            this.onLoaded();
        }
    }

    @Optional.Method(modid="ic2")
    public void onLoaded() {
        if (this.getPowerConfig().eu() && !this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.getPowerConfig().eu() && this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return this.getMaxPower() - this.getEnergy();
    }

    @Optional.Method(modid="ic2")
    public int getSinkTier() {
        return this.getTier().getIC2Tier();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double used = this.addEnergy(amount);
        return amount - used;
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canAcceptEnergy(enumFacing);
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return false;
        }
        return this.canProvideEnergy(enumFacing);
    }

    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        if (!RebornCoreConfig.getRebornPower().eu()) {
            return 0.0;
        }
        return Math.min(this.getEnergy(), this.getMaxOutput());
    }

    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        this.useEnergy((int)amount);
    }

    @Optional.Method(modid="ic2")
    public int getSourceTier() {
        return this.getTier().getIC2Tier();
    }

    @Deprecated
    public boolean canConnectEnergy(EnumFacing from) {
        return this.canAcceptEnergy(from) || this.canProvideEnergy(from);
    }

    @Deprecated
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.canAcceptEnergy(from)) {
            return 0;
        }
        int feReceived = (int)Math.min((double)(this.getMaxEnergyStored(from) - this.getEnergyStored(from)), Math.min(this.getMaxInput() * (double)RebornCoreConfig.euPerFU, (double)maxReceive));
        int euReceived = feReceived / RebornCoreConfig.euPerFU;
        feReceived = euReceived * RebornCoreConfig.euPerFU;
        if (!simulate) {
            this.setEnergy(this.getEnergy() + (double)euReceived);
        }
        return feReceived;
    }

    @Deprecated
    public int getEnergyStored(EnumFacing from) {
        return (int)this.getEnergy() * RebornCoreConfig.euPerFU;
    }

    @Deprecated
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)this.getMaxPower() * RebornCoreConfig.euPerFU;
    }

    @Deprecated
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.canProvideEnergy(from)) {
            return 0;
        }
        int euExtracted = Math.min(this.getEnergyStored(null), maxExtract / RebornCoreConfig.euPerFU);
        int feExtracted = euExtracted * RebornCoreConfig.euPerFU;
        if (!simulate) {
            this.setEnergy(this.getEnergy() - (double)euExtracted);
        }
        return feExtracted;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(double energy) {
        this.energy = Math.max(Math.min(energy, this.getMaxPower()), 0.0);
    }

    @Override
    public double addEnergy(double energy) {
        return this.addEnergy(energy, false);
    }

    @Override
    public double addEnergy(double energy, boolean simulate) {
        double energyReceived = Math.min(this.getMaxPower(), Math.min(this.getFreeSpace(), energy));
        if (!simulate) {
            this.setEnergy(this.getEnergy() + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public boolean canUseEnergy(double input) {
        return input <= this.energy;
    }

    @Override
    public double useEnergy(double energy) {
        return this.useEnergy(energy, false);
    }

    @Override
    public double useEnergy(double extract, boolean simulate) {
        if (extract > this.energy) {
            extract = this.energy;
        }
        if (!simulate) {
            this.setEnergy(this.energy - extract);
        }
        return extract;
    }

    @Override
    public boolean canAddEnergy(double energyIn) {
        return this.getEnergy() + energyIn <= this.getMaxPower();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        if (this.shouldHanldeEnergyNBT()) {
            this.setEnergy(data.func_74769_h("energy"));
        }
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.readFromNBT(tag, this);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.getEnergy());
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            TeslaManager.manager.writeToNBT(tag, this);
        }
        return tag;
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = tag.func_74775_l("TilePowerAcceptor");
        if (this.shouldHanldeEnergyNBT()) {
            this.setEnergy(data.func_74769_h("energy"));
        }
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tag) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energy);
        tag.func_74782_a("TilePowerAcceptor", (NBTBase)data);
        return tag;
    }

    public boolean shouldHanldeEnergyNBT() {
        return true;
    }

    @Override
    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + "Max Energy: " + TextFormatting.GOLD + this.getLocaliszedPowerFormatted((int)this.getMaxPower()));
        if (this.getMaxInput() != 0.0) {
            info.add(TextFormatting.GRAY + "Input Rate: " + TextFormatting.GOLD + this.getLocaliszedPowerFormatted((int)this.getMaxInput()));
        }
        if (this.getMaxOutput() != 0.0) {
            info.add(TextFormatting.GRAY + "Output Rate: " + TextFormatting.GOLD + this.getLocaliszedPowerFormatted((int)this.getMaxOutput()));
        }
        info.add(TextFormatting.GRAY + "Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase(this.getTier().toString()));
    }

    public double getFreeSpace() {
        return this.getMaxPower() - this.getEnergy();
    }

    public void charge(int slot) {
        double minProvide;
        double minAccept;
        double transfer;
        IEnergyItemInfo battery;
        ItemStack batteryStack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.func_70301_a(slot) != ItemStack.field_190927_a && (batteryStack = this.func_70301_a(slot)).func_77973_b() instanceof IEnergyItemInfo && (battery = (IEnergyItemInfo)batteryStack.func_77973_b()).canProvideEnergy(batteryStack) && this.getEnergy() < this.getMaxPower() && PoweredItem.canUseEnergy(transfer = Math.min(minAccept = Math.min(this.getFreeSpace(), this.getMaxInput()), minProvide = Math.min(battery.getMaxTransfer(batteryStack), PoweredItem.getEnergy(batteryStack))), batteryStack)) {
            PoweredItem.useEnergy(transfer, batteryStack);
            this.addEnergy(transfer);
        }
    }

    public int getEnergyScaled(int scale) {
        return (int)(this.getEnergy() * (double)scale / this.getMaxPower());
    }

    public IPowerConfig getPowerConfig() {
        return RebornCoreConfig.getRebornPower();
    }

    public String getLocaliszedPowerFormatted(int eu) {
        switch (PowerSystem.getDisplayPower()) {
            case EU: {
                return NumberFormat.getIntegerInstance(Locale.forLanguageTag("en_US")).format(eu) + " " + PowerSystem.EnergySystem.EU.abbreviation;
            }
            case TESLA: {
                return NumberFormat.getIntegerInstance(Locale.forLanguageTag("en_US")).format(eu * RebornCoreConfig.euPerFU) + " " + PowerSystem.EnergySystem.TESLA.abbreviation;
            }
        }
        return NumberFormat.getIntegerInstance(Locale.forLanguageTag("en_US")).format(eu * RebornCoreConfig.euPerFU) + " " + PowerSystem.EnergySystem.FE.abbreviation;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig()) && TeslaManager.manager.hasCapability(capability, facing, this)) {
            return true;
        }
        if (this.getPowerConfig().forge() && capability == CapabilityEnergy.ENERGY && this.canConnectEnergy(facing)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (TeslaManager.isTeslaEnabled(this.getPowerConfig())) {
            T teslaCap = TeslaManager.manager.getCapability(capability, facing, this);
            if (TeslaManager.manager.isTeslaCapability(capability)) {
                return teslaCap;
            }
        }
        if (this.getPowerConfig().forge() && capability == CapabilityEnergy.ENERGY && this.canConnectEnergy(facing)) {
            if (this.forgePowerManager == null) {
                this.forgePowerManager = new ForgePowerManager(this, facing);
            }
            this.forgePowerManager.setFacing(facing);
            return (T)this.forgePowerManager;
        }
        return super.getCapability(capability, facing);
    }

    public abstract double getBaseMaxPower();

    public abstract double getBaseMaxOutput();

    public abstract double getBaseMaxInput();

    @Deprecated
    public EnumPowerTier getBaseTier() {
        return null;
    }

    @Override
    public double getMaxPower() {
        return this.getBaseMaxPower() + this.extraPowerStoage;
    }

    @Override
    public double getMaxOutput() {
        double maxOutput = 0.0;
        maxOutput = this.extraTeir > 0 ? (double)this.getTier().getMaxOutput() : this.getBaseMaxOutput();
        return maxOutput;
    }

    @Override
    public double getMaxInput() {
        double maxInput = 0.0;
        maxInput = this.extraTeir > 0 ? (double)this.getTier().getMaxInput() : this.getBaseMaxInput();
        return maxInput;
    }

    public EnumPowerTier getPushingTier() {
        return this.getTier();
    }

    @Override
    public EnumPowerTier getTier() {
        EnumPowerTier baseTier = this.getBaseTier();
        if (baseTier == null) {
            if (this.tier == null) {
                this.checkTeir();
            }
            baseTier = this.tier;
        }
        if (this.extraTeir > 0) {
            for (EnumPowerTier tier : EnumPowerTier.values()) {
                if (tier.getIC2Tier() != baseTier.getIC2Tier() + this.extraTeir) continue;
                return tier;
            }
            return EnumPowerTier.INSANE;
        }
        return baseTier;
    }

    @Override
    public void resetUpgrades() {
        super.resetUpgrades();
        this.extraPowerStoage = 0.0;
        this.extraTeir = 0;
    }

    public boolean handleTierWithPower() {
        return true;
    }
}

