/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.tesla;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.TilePowerAcceptor;

public class AdvancedTeslaContainer
implements ITeslaConsumer,
ITeslaHolder,
ITeslaProducer {
    public TilePowerAcceptor tile;

    public AdvancedTeslaContainer(TilePowerAcceptor tile) {
        this.tile = tile;
    }

    public AdvancedTeslaContainer(NBTBase nbt, TilePowerAcceptor tile) {
        this.tile = tile;
        this.readNBT(nbt);
    }

    public long getStoredPower() {
        return (long)this.tile.getEnergy() * (long)RebornCoreConfig.euPerFU;
    }

    public long givePower(long tesla, boolean simulated) {
        double euToAdd = tesla * (long)RebornCoreConfig.euPerFU;
        if (this.tile.canAddEnergy(euToAdd)) {
            double euAdded = this.tile.addEnergy(euToAdd);
            return (long)(euAdded / (double)RebornCoreConfig.euPerFU);
        }
        return 0L;
    }

    public long takePower(long tesla, boolean simulated) {
        double euToTake = tesla * (long)RebornCoreConfig.euPerFU;
        if (this.tile.canUseEnergy(euToTake)) {
            double euTaken = this.tile.useEnergy(euToTake);
            return (long)(euTaken / (double)RebornCoreConfig.euPerFU);
        }
        return 0L;
    }

    public long getCapacity() {
        return (long)this.tile.getMaxPower() * (long)RebornCoreConfig.euPerFU;
    }

    public long getInputRate() {
        return (long)this.tile.getMaxInput() * (long)RebornCoreConfig.euPerFU;
    }

    public long getOutputRate() {
        return (long)this.tile.getMaxOutput() * (long)RebornCoreConfig.euPerFU;
    }

    public NBTBase writeNBT() {
        NBTTagCompound dataTag = new NBTTagCompound();
        return dataTag;
    }

    public void readNBT(NBTBase nbt) {
    }

    public boolean isInputSide() {
        return true;
    }

    public boolean isOutputSide() {
        return true;
    }
}

