/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.registration.impl;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import reborncore.common.registration.IRegistryFactory;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.RegistrationManager;
import reborncore.common.registration.RegistryConstructionEvent;
import reborncore.common.registration.RegistryTarget;
import reborncore.common.registration.impl.ConfigRegistry;

@IRegistryFactory.RegistryFactory
public class ConfigRegistryFactory
implements IRegistryFactory {
    private static File configDir = null;
    private static HashMap<String, Configuration> configMap = new HashMap();

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return ConfigRegistry.class;
    }

    @Override
    public void handleField(Field field) {
        try {
            String key;
            RebornRegistry rebornRegistry = (RebornRegistry)RegistrationManager.getAnnoation(field.getDeclaringClass().getAnnotations(), RebornRegistry.class);
            ConfigRegistry annotation = (ConfigRegistry)RegistrationManager.getAnnoationFromArray(field.getAnnotations(), this);
            Configuration configuration = ConfigRegistryFactory.getOrCreateConfig(annotation, rebornRegistry);
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new RuntimeException("Field " + field.getName() + " must be static");
            }
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if ((key = annotation.key()).isEmpty()) {
                key = field.getName();
            }
            Object defaultValue = field.get(null);
            String comment = annotation.comment();
            comment = comment + " [Default=" + defaultValue + "]";
            Property property = this.get(annotation.category(), key, defaultValue, comment, field.getType(), configuration);
            Object value = this.getObjectFromType(property, field.getType());
            field.set(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error("Failed to load config", e);
        }
    }

    private Object getObjectFromType(Property property, Class<?> type) {
        if (type == String.class) {
            return property.getString();
        }
        if (type == Boolean.TYPE) {
            return property.getBoolean();
        }
        if (type == Integer.TYPE) {
            return property.getInt();
        }
        if (type == Double.TYPE) {
            return property.getDouble();
        }
        throw new RuntimeException("Type not supported");
    }

    private Property get(String category, String key, Object defaultValue, String comment, Class<?> type, Configuration configuration) {
        if (type == String.class) {
            return configuration.get(category, key, (String)defaultValue, comment);
        }
        if (type == Boolean.TYPE) {
            return configuration.get(category, key, ((Boolean)defaultValue).booleanValue(), comment);
        }
        if (type == Integer.TYPE) {
            return configuration.get(category, key, ((Integer)defaultValue).intValue(), comment);
        }
        if (type == Double.TYPE) {
            return configuration.get(category, key, ((Double)defaultValue).doubleValue(), comment);
        }
        throw new RuntimeException("Type not supported: " + type);
    }

    private static Configuration getOrCreateConfig(ConfigRegistry annotation, RebornRegistry rebornRegistry) {
        Configuration configuration;
        String configIdent = rebornRegistry.modID();
        if (!annotation.config().isEmpty()) {
            configIdent = configIdent + ":" + annotation.config();
        }
        if (configMap.containsKey(configIdent)) {
            configuration = configMap.get(configIdent);
        } else {
            File modConfigDir = new File(configDir, rebornRegistry.modID());
            String configName = "config.cfg";
            if (!annotation.config().isEmpty()) {
                configName = annotation.config() + ".cfg";
            }
            configuration = new Configuration(new File(modConfigDir, configName));
            configMap.put(configIdent, configuration);
        }
        return configuration;
    }

    public static void saveAll() {
        for (Map.Entry<String, Configuration> configurationEntry : configMap.entrySet()) {
            configurationEntry.getValue().save();
        }
    }

    public static void setConfigDir(File configDir) {
        ConfigRegistryFactory.configDir = configDir;
    }

    @Override
    public List<RegistryTarget> getTargets() {
        return Collections.singletonList(RegistryTarget.FIELD);
    }

    @Override
    public Class<? extends FMLStateEvent> getProcessSate() {
        return RegistryConstructionEvent.class;
    }
}

