/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.tile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import reborncore.RebornCore;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class SlotConfiguration
implements INBTSerializable<NBTTagCompound> {
    List<SlotConfigHolder> slotDetails = new ArrayList<SlotConfigHolder>();
    @Nullable
    Inventory inventory;

    public SlotConfiguration() {
    }

    public SlotConfiguration(Inventory inventory) {
        this.inventory = inventory;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            this.updateSlotDetails(new SlotConfigHolder(i));
        }
    }

    public void update(TileLegacyMachineBase machineBase) {
        if (this.inventory == null && machineBase.getInventoryForTile().isPresent()) {
            this.inventory = machineBase.getInventoryForTile().get();
        }
        if (this.inventory != null && this.slotDetails.size() != this.inventory.func_70302_i_()) {
            RebornCore.logHelper.debug("Fixing curoupt SlotConfiguration");
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                SlotConfigHolder holder = this.getSlotDetails(i);
                if (holder != null) continue;
                RebornCore.logHelper.debug("Fixed slot " + i + " in " + machineBase);
                this.updateSlotDetails(new SlotConfigHolder(i));
            }
        }
        if (!machineBase.func_145831_w().field_72995_K && machineBase.func_145831_w().func_82737_E() % 5L == 0L) {
            this.getSlotDetails().forEach(slotConfigHolder -> ((SlotConfigHolder)slotConfigHolder).handleItemIO(machineBase));
        }
    }

    public SlotConfiguration(NBTTagCompound tagCompound) {
        this.deserializeNBT(tagCompound);
    }

    public List<SlotConfigHolder> getSlotDetails() {
        return this.slotDetails;
    }

    public SlotConfigHolder updateSlotDetails(SlotConfigHolder slotConfigHolder) {
        SlotConfigHolder lookup = this.getSlotDetails(slotConfigHolder.slotID);
        if (lookup != null) {
            this.slotDetails.remove(lookup);
        }
        this.slotDetails.add(slotConfigHolder);
        return slotConfigHolder;
    }

    @Nullable
    public SlotConfigHolder getSlotDetails(int id) {
        for (SlotConfigHolder detail : this.slotDetails) {
            if (detail.slotID != id) continue;
            return detail;
        }
        return null;
    }

    public List<SlotConfig> getSlotsForSide(EnumFacing facing) {
        return this.slotDetails.stream().map(slotConfigHolder -> slotConfigHolder.getSideDetail(facing)).collect(Collectors.toList());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("size", this.slotDetails.size());
        for (int i = 0; i < this.slotDetails.size(); ++i) {
            tagCompound.func_74782_a("slot_" + i, (NBTBase)this.slotDetails.get(i).serializeNBT());
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int size = nbt.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tagCompound = nbt.func_74775_l("slot_" + i);
            SlotConfigHolder slotConfigHolder = new SlotConfigHolder(tagCompound);
            this.updateSlotDetails(slotConfigHolder);
        }
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false);

        boolean extact;
        boolean insert;

        private ExtractConfig(boolean extact, boolean insert) {
            this.extact = extact;
            this.insert = insert;
        }

        public boolean isExtact() {
            return this.extact;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }
    }

    public static class SlotIO
    implements INBTSerializable<NBTTagCompound> {
        ExtractConfig ioConfig;

        public SlotIO(NBTTagCompound tagCompound) {
            this.deserializeNBT(tagCompound);
        }

        public SlotIO(ExtractConfig ioConfig) {
            this.ioConfig = ioConfig;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("config", this.ioConfig.ordinal());
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.ioConfig = ExtractConfig.values()[nbt.func_74762_e("config")];
        }
    }

    public static class SlotConfig
    implements INBTSerializable<NBTTagCompound> {
        EnumFacing side;
        SlotIO slotIO;
        int slotID;

        public SlotConfig(EnumFacing side, int slotID) {
            this.side = side;
            this.slotID = slotID;
            this.slotIO = new SlotIO(ExtractConfig.NONE);
        }

        public SlotConfig(EnumFacing side, SlotIO slotIO, int slotID) {
            this.side = side;
            this.slotIO = slotIO;
            this.slotID = slotID;
        }

        public SlotConfig(NBTTagCompound tagCompound) {
            this.deserializeNBT(tagCompound);
        }

        public EnumFacing getSide() {
            return this.side;
        }

        public SlotIO getSlotIO() {
            return this.slotIO;
        }

        public int getSlotID() {
            return this.slotID;
        }

        private void handleItemInput(TileLegacyMachineBase machineBase) {
            Inventory inventory = machineBase.getInventoryForTile().get();
            TileLegacyMachineBase sidedInventory = machineBase;
            ItemStack targetStack = inventory.func_70301_a(this.slotID);
            if (targetStack.func_77976_d() == targetStack.func_190916_E()) {
                return;
            }
            TileEntity tileEntity = machineBase.func_145831_w().func_175625_s(machineBase.func_174877_v().func_177972_a(this.side));
            if (tileEntity == null || !tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side)) {
                return;
            }
            IItemHandler sourceHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side);
            for (int i = 0; i < sourceHandler.getSlots(); ++i) {
                ItemStack sourceStack = sourceHandler.getStackInSlot(i);
                if (sourceStack.func_190926_b() || !targetStack.func_190926_b() && !ItemUtils.isItemEqual(sourceStack, targetStack, true, true, false) || !machineBase.func_94041_b(this.slotID, sourceStack)) continue;
                ItemStack extractedStack = sourceHandler.extractItem(i, 1, false);
                if (targetStack.func_190926_b()) {
                    inventory.func_70299_a(this.slotID, extractedStack);
                    break;
                }
                inventory.func_70301_a(this.slotID).func_190917_f(extractedStack.func_190916_E());
                break;
            }
        }

        private void handleItemOutput(TileLegacyMachineBase machineBase) {
            Inventory inventory = machineBase.getInventoryForTile().get();
            ItemStack sourceStack = inventory.func_70301_a(this.slotID);
            if (sourceStack.func_190926_b()) {
                return;
            }
            TileEntity tileEntity = machineBase.func_145831_w().func_175625_s(machineBase.func_174877_v().func_177972_a(this.side));
            if (tileEntity == null || !tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side.func_176734_d())) {
                return;
            }
            IItemHandler destHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.side.func_176734_d());
            for (int i = 0; i < destHandler.getSlots(); ++i) {
                ItemStack returnStack = destHandler.insertItem(i, sourceStack, true);
                if (!returnStack.func_190926_b() && returnStack.func_190916_E() == sourceStack.func_190916_E()) continue;
                returnStack = destHandler.insertItem(i, sourceStack, false);
                inventory.func_70299_a(this.slotID, returnStack);
                break;
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("side", this.side.ordinal());
            tagCompound.func_74782_a("config", (NBTBase)this.slotIO.serializeNBT());
            tagCompound.func_74768_a("slot", this.slotID);
            return tagCompound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.side = EnumFacing.field_82609_l[nbt.func_74762_e("side")];
            this.slotIO = new SlotIO(nbt.func_74775_l("config"));
            this.slotID = nbt.func_74762_e("slot");
        }
    }

    public static class SlotConfigHolder
    implements INBTSerializable<NBTTagCompound> {
        int slotID;
        HashMap<EnumFacing, SlotConfig> sideMap;
        boolean input;
        boolean output;
        boolean filter;

        public SlotConfigHolder(int slotID) {
            this.slotID = slotID;
            this.sideMap = new HashMap();
            Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> this.sideMap.put((EnumFacing)facing, new SlotConfig((EnumFacing)facing, slotID)));
        }

        public SlotConfigHolder(NBTTagCompound tagCompound) {
            this.sideMap = new HashMap();
            this.deserializeNBT(tagCompound);
        }

        public SlotConfig getSideDetail(EnumFacing side) {
            return this.sideMap.get(side);
        }

        public List<SlotConfig> getAllSides() {
            return new ArrayList<SlotConfig>(this.sideMap.values());
        }

        public void updateSlotConfig(SlotConfig config) {
            SlotConfig toEdit = this.sideMap.get(config.side);
            toEdit.slotIO = config.slotIO;
        }

        private void handleItemIO(TileLegacyMachineBase machineBase) {
            if (!this.input && !this.output) {
                return;
            }
            this.getAllSides().stream().filter(config -> config.getSlotIO().getIoConfig() != ExtractConfig.NONE).forEach(config -> {
                if (this.input && config.getSlotIO().getIoConfig() == ExtractConfig.INPUT) {
                    ((SlotConfig)config).handleItemInput(machineBase);
                }
                if (this.output && config.getSlotIO().getIoConfig() == ExtractConfig.OUTPUT) {
                    ((SlotConfig)config).handleItemOutput(machineBase);
                }
            });
        }

        public boolean autoInput() {
            return this.input;
        }

        public boolean autoOutput() {
            return this.output;
        }

        public boolean filter() {
            return this.filter;
        }

        public void setInput(boolean input) {
            this.input = input;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }

        public void setfilter(boolean filter) {
            this.filter = filter;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("slotID", this.slotID);
            Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> compound.func_74782_a("side_" + facing.ordinal(), (NBTBase)this.sideMap.get(facing).serializeNBT()));
            compound.func_74757_a("input", this.input);
            compound.func_74757_a("output", this.output);
            compound.func_74757_a("filter", this.filter);
            return compound;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.sideMap.clear();
            this.slotID = nbt.func_74762_e("slotID");
            Arrays.stream(EnumFacing.field_82609_l).forEach(facing -> {
                NBTTagCompound compound = nbt.func_74775_l("side_" + facing.ordinal());
                SlotConfig config = new SlotConfig(compound);
                this.sideMap.put((EnumFacing)facing, config);
            });
            this.input = nbt.func_74767_n("input");
            this.output = nbt.func_74767_n("output");
            if (nbt.func_74764_b("filter")) {
                this.filter = nbt.func_74767_n("filter");
            }
        }
    }
}

