/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.display;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.annotations.Since;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.model.MapText;
import journeymap.client.api.model.WaypointBase;
import journeymap.common.api.util.CachedDimPosition;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Waypoint
extends WaypointBase<Waypoint> {
    public static final double VERSION = 1.6;
    @Since(value=1.4)
    protected final double version = 1.6;
    @Since(value=1.4)
    protected int dim;
    @Since(value=1.4)
    protected BlockPos pos;
    @Since(value=1.4)
    protected WaypointGroup group;
    @Since(value=1.4)
    protected boolean editable = true;
    private transient boolean persistent = true;
    private final transient CachedDimPosition dimPositions = new CachedDimPosition(this::getInternalPosition);

    private Waypoint() {
    }

    public Waypoint(String modId, String name, int dimension, BlockPos position) {
        super(modId, name);
        this.setPosition(dimension, position);
    }

    public Waypoint(String modId, String id, String name, int dimension, BlockPos position) {
        super(modId, id, name);
        this.setPosition(dimension, position);
    }

    public Waypoint(Waypoint other) {
        super(other.getModId(), other.getName());
        this.updateFrom(other);
    }

    public Waypoint updateFrom(Waypoint other) {
        MapText label;
        this.setName(other.getName());
        this.dim = other.dim;
        this.pos = other.pos;
        this.group = other.group;
        this.editable = other.editable;
        this.persistent = other.persistent;
        this.displayDims = new HashSet<Integer>(other.getDisplayDimensions());
        MapImage icon = other.getIcon();
        if (icon != null) {
            this.icon = new MapImage(icon);
        }
        if ((label = other.getLabel()) != null) {
            this.label = new MapText(label);
        }
        return this;
    }

    public final WaypointGroup getGroup() {
        return this.group;
    }

    public Waypoint setGroup(@Nullable WaypointGroup group) {
        this.group = group;
        return (Waypoint)this.setDirty();
    }

    public final int getDimension() {
        return this.dim;
    }

    public final BlockPos getPosition() {
        return this.pos;
    }

    public BlockPos getPosition(int targetDimension) {
        return this.dimPositions.getPosition(targetDimension);
    }

    private BlockPos getInternalPosition(int targetDimension) {
        if (this.dim != targetDimension) {
            if (this.dim == -1) {
                this.pos = new BlockPos(this.pos.func_177958_n() * 8, this.pos.func_177956_o(), this.pos.func_177952_p() * 8);
            } else if (targetDimension == -1) {
                this.pos = new BlockPos((double)this.pos.func_177958_n() / 8.0, (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p() / 8.0);
            }
        }
        return this.pos;
    }

    public Waypoint setPosition(int dimension, BlockPos position) {
        if (position == null) {
            throw new IllegalArgumentException("position may not be null");
        }
        this.dim = dimension;
        this.pos = position;
        this.dimPositions.reset();
        return (Waypoint)this.setDirty();
    }

    public Vec3d getVec(int dimension) {
        return this.dimPositions.getVec(dimension);
    }

    public Vec3d getCenteredVec(int dimension) {
        return this.dimPositions.getCenteredVec(dimension);
    }

    public final boolean isPersistent() {
        return this.persistent;
    }

    public final Waypoint setPersistent(boolean persistent) {
        this.persistent = persistent;
        if (!persistent) {
            this.dirty = false;
        }
        return (Waypoint)this.setDirty();
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final Waypoint setEditable(boolean editable) {
        this.editable = editable;
        return (Waypoint)this.setDirty();
    }

    @Override
    protected WaypointGroup getDelegate() {
        return this.getGroup();
    }

    @Override
    protected boolean hasDelegate() {
        return this.group != null;
    }

    @Override
    public Set<Integer> getDisplayDimensions() {
        if (this.displayDims == null && !this.hasDelegate()) {
            this.setDisplayDimensions(this.dim);
        }
        return super.getDisplayDimensions();
    }

    @Override
    public int getDisplayOrder() {
        return this.group != null ? this.group.getDisplayOrder() : 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Waypoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Waypoint that = (Waypoint)o;
        return this.isPersistent() == that.isPersistent() && this.isEditable() == that.isEditable() && Objects.equal((Object)this.getDimension(), (Object)that.getDimension()) && Objects.equal((Object)this.getLabel(), (Object)that.getLabel()) && Objects.equal((Object)this.getName(), (Object)that.getName()) && Objects.equal((Object)this.getPosition(), (Object)that.getPosition()) && Objects.equal((Object)this.getIcon(), (Object)that.getIcon()) && Arrays.equals(this.getDisplayDimensions().toArray(), that.getDisplayDimensions().toArray());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.getName()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("dim", this.dim).add("pos", (Object)this.pos).add("group", (Object)this.group).add("icon", (Object)this.icon).add("label", (Object)this.label).add("displayDims", (Object)this.displayDims).add("editable", this.editable).add("persistent", this.persistent).add("dirty", this.dirty).toString();
    }
}

