/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.model;

import com.google.common.base.MoreObjects;
import java.util.EnumSet;
import journeymap.client.api.model.MapText;
import journeymap.client.api.util.UIState;
import journeymap.common.api.feature.Feature;

public class TextProperties
extends MapText<TextProperties> {
    protected EnumSet<Feature.Display> activeUIs = EnumSet.allOf(Feature.Display.class);
    protected EnumSet<Feature.MapType> activeMapTypes = EnumSet.allOf(Feature.MapType.class);

    public TextProperties() {
    }

    public TextProperties(TextProperties other) {
        super(other);
        this.activeUIs = EnumSet.copyOf(other.activeUIs);
        this.activeMapTypes = EnumSet.copyOf(other.activeMapTypes);
    }

    public EnumSet<Feature.Display> getActiveUIs() {
        return this.activeUIs;
    }

    public TextProperties setActiveUIs(EnumSet<Feature.Display> activeUIs) {
        this.activeUIs = EnumSet.noneOf(Feature.Display.class);
        this.activeUIs.addAll(activeUIs);
        return this;
    }

    public EnumSet<Feature.MapType> getActiveMapTypes() {
        return this.activeMapTypes;
    }

    public TextProperties setActiveMapTypes(EnumSet<Feature.MapType> activeMapTypes) {
        this.activeMapTypes = EnumSet.noneOf(Feature.MapType.class);
        this.activeMapTypes.addAll(activeMapTypes);
        return this;
    }

    public boolean isActiveIn(UIState uiState) {
        return uiState.active && this.activeUIs.contains(uiState.ui) && this.activeMapTypes.contains(uiState.mapType) && this.minZoom <= uiState.zoom && this.maxZoom >= uiState.zoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    @Override
    public TextProperties setMinZoom(int minZoom) {
        this.minZoom = Math.max(0, minZoom);
        return this;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public TextProperties setMaxZoom(int maxZoom) {
        this.maxZoom = Math.min(8, maxZoom);
        return this;
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public TextProperties setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public TextProperties setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("activeMapTypes", this.activeMapTypes).add("activeUIs", this.activeUIs).add("backgroundColor", (Object)this.backgroundColor).add("backgroundOpacity", (Object)this.backgroundOpacity).add("color", (Object)this.color).add("opacity", (Object)this.opacity).add("fontShadow", (Object)this.fontShadow).add("maxZoom", (Object)this.maxZoom).add("minZoom", (Object)this.minZoom).add("offsetX", (Object)this.offsetX).add("offsetY", (Object)this.offsetY).add("scale", (Object)this.scale).toString();
    }
}

