/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import journeymap.client.cartography.render.BaseRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndCaveRenderer;
import journeymap.client.cartography.render.EndSurfaceRenderer;
import journeymap.client.cartography.render.NetherRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.cartography.render.TopoRenderer;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapView;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.client.render.ComparableBufferedImage;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;

public class ChunkRenderController {
    private final SurfaceRenderer overWorldSurfaceRenderer = new SurfaceRenderer();
    private final BaseRenderer netherRenderer;
    private final SurfaceRenderer endSurfaceRenderer;
    private final BaseRenderer endCaveRenderer;
    private final BaseRenderer topoRenderer;
    private final BaseRenderer overWorldCaveRenderer = new CaveRenderer(this.overWorldSurfaceRenderer);

    public ChunkRenderController() {
        this.netherRenderer = new NetherRenderer();
        this.endSurfaceRenderer = new EndSurfaceRenderer();
        this.endCaveRenderer = new EndCaveRenderer(this.endSurfaceRenderer);
        this.topoRenderer = new TopoRenderer();
    }

    public BaseRenderer getRenderer(RegionCoord rCoord, MapView mapView, ChunkMD chunkMd) {
        block8: {
            try {
                RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
                if (mapView.isUnderground()) {
                    ComparableBufferedImage image = regionImageSet.getChunkImage(chunkMd, mapView);
                    if (image != null) {
                        switch (rCoord.dimension) {
                            case -1: {
                                return this.netherRenderer;
                            }
                            case 1: {
                                return this.endCaveRenderer;
                            }
                        }
                        return this.overWorldCaveRenderer;
                    }
                    break block8;
                }
                return this.overWorldSurfaceRenderer;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toPartialString(t));
            }
        }
        return null;
    }

    public boolean renderChunk(RegionCoord rCoord, MapView mapView, ChunkMD chunkMd) {
        if (!Journeymap.getClient().isMapping().booleanValue()) {
            return false;
        }
        boolean renderOkay = false;
        try {
            RegionImageSet regionImageSet = RegionImageCache.INSTANCE.getRegionImageSet(rCoord);
            if (mapView.isUnderground()) {
                ComparableBufferedImage chunkSliceImage = regionImageSet.getChunkImage(chunkMd, mapView);
                if (chunkSliceImage != null) {
                    switch (rCoord.dimension) {
                        case -1: {
                            renderOkay = this.netherRenderer.render(chunkSliceImage, chunkMd, mapView.vSlice);
                            break;
                        }
                        case 1: {
                            renderOkay = this.endCaveRenderer.render(chunkSliceImage, chunkMd, mapView.vSlice);
                            break;
                        }
                        default: {
                            renderOkay = this.overWorldCaveRenderer.render(chunkSliceImage, chunkMd, mapView.vSlice);
                        }
                    }
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, mapView, chunkSliceImage);
                    }
                }
            } else if (mapView.isTopo()) {
                ComparableBufferedImage imageTopo = regionImageSet.getChunkImage(chunkMd, MapView.topo(rCoord.dimension));
                renderOkay = this.topoRenderer.render(imageTopo, chunkMd, null);
                if (renderOkay) {
                    regionImageSet.setChunkImage(chunkMd, MapView.topo(rCoord.dimension), imageTopo);
                }
            } else {
                ComparableBufferedImage imageNight;
                ComparableBufferedImage imageDay = regionImageSet.getChunkImage(chunkMd, MapView.day(rCoord.dimension));
                renderOkay = this.overWorldSurfaceRenderer.render(imageDay, imageNight = regionImageSet.getChunkImage(chunkMd, MapView.night(rCoord.dimension)), chunkMd);
                if (renderOkay) {
                    regionImageSet.setChunkImage(chunkMd, MapView.day(rCoord.dimension), imageDay);
                    regionImageSet.setChunkImage(chunkMd, MapView.night(rCoord.dimension), imageNight);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Journeymap.getLogger().warn(LogFormatter.toString(e));
            return false;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug(String.format("Chunk %s render failed for %s", chunkMd.getCoord(), mapView));
        }
        return renderOkay;
    }
}

