/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.base.Strings;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.waypoint.WaypointChatParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ChatEventHandler
implements EventHandlerManager.EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void invoke(ClientChatReceivedEvent event) {
        ITextComponent message = event.getMessage();
        if (message != null) {
            try {
                EntityPlayerSP player;
                if (message instanceof TextComponentTranslation && (player = Journeymap.clientPlayer()) != null && "gameMode.changed".equals(((TextComponentTranslation)message).func_150268_i())) {
                    Journeymap.getLogger().info("Player is Op: " + Journeymap.proxy.isOp(player.func_110124_au()));
                    return;
                }
                String text = event.getMessage().func_150254_d();
                if (!Strings.isNullOrEmpty((String)text)) {
                    WaypointChatParser.parseChatForWaypoints(event, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
    }
}

