/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.text.DateFormat;
import java.util.Date;
import journeymap.client.Constants;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.event.DeathWaypointEvent;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.api.model.MapImage;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.properties.WaypointProperties;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class StateTickHandler
implements EventHandlerManager.EventHandler {
    Minecraft mc = FMLClientHandler.instance().getClient();
    int counter = 0;
    private boolean deathpointCreated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        this.mc.field_71424_I.func_76320_a("journeymap");
        EntityPlayerSP player = Journeymap.clientPlayer();
        if (player != null && player.field_70128_L) {
            if (!this.deathpointCreated) {
                this.deathpointCreated = true;
                this.createDeathpoint();
            }
        } else {
            this.deathpointCreated = false;
        }
        try {
            if (this.counter == 20) {
                this.mc.field_71424_I.func_76320_a("mainTasks");
                Journeymap.getClient().performMainThreadTasks();
                this.counter = 0;
                this.mc.field_71424_I.func_76319_b();
            } else if (this.counter == 10) {
                this.mc.field_71424_I.func_76320_a("multithreadTasks");
                if (Journeymap.getClient().isMapping().booleanValue() && Journeymap.clientWorld() != null) {
                    Journeymap.getClient().performMultithreadTasks();
                }
                ++this.counter;
                this.mc.field_71424_I.func_76319_b();
            } else if (this.counter == 5 || this.counter == 15) {
                this.mc.field_71424_I.func_76320_a("clientApiEvents");
                ClientAPI.INSTANCE.getClientEventManager().fireNextClientEvents();
                ++this.counter;
                this.mc.field_71424_I.func_76319_b();
            } else {
                ++this.counter;
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Error during onClientTick: " + LogFormatter.toPartialString(t));
        }
        finally {
            this.mc.field_71424_I.func_76319_b();
        }
    }

    private void createDeathpoint() {
        try {
            EntityPlayerSP player = Journeymap.clientPlayer();
            if (player == null) {
                Journeymap.getLogger().error("Lost reference to player before Deathpoint could be created");
                return;
            }
            int dim = player.field_71093_bK;
            WaypointProperties waypointProperties = Journeymap.getClient().getWaypointProperties();
            boolean enabled = waypointProperties.createDeathpoints.get();
            boolean cancelled = false;
            BlockPos pos = player.func_180425_c();
            if (enabled) {
                DeathWaypointEvent event = new DeathWaypointEvent(pos, dim);
                ClientAPI.INSTANCE.getClientEventManager().fireDeathpointEvent(event);
                if (!event.isCancelled()) {
                    Date now = new Date();
                    String name = String.format("%s %s %s", Constants.getString("jm.waypoint.deathpoint"), DateFormat.getTimeInstance().format(now), DateFormat.getDateInstance(3).format(now));
                    Waypoint deathpoint = new Waypoint("journeymap", name, player.field_71093_bK, pos);
                    int red = 0xFF0000;
                    deathpoint.setLabelColor(red);
                    deathpoint.setIcon(new MapImage(TextureCache.Deathpoint, 16, 16).setColor(red));
                    WaypointStore.INSTANCE.save(deathpoint);
                } else {
                    cancelled = true;
                }
            }
            Journeymap.getLogger().info(String.format("%s died at %s. Deathpoints enabled: %s. Deathpoint created: %s", player.func_70005_c_(), pos, enabled, cancelled ? "cancelled" : Boolean.valueOf(true)));
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected Error in createDeathpoint(): " + LogFormatter.toString(t));
        }
    }
}

