/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.client.api.impl.ClientAPI;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.io.FileHandler;
import journeymap.client.log.StatTimer;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.EntityHelper;
import journeymap.client.model.MapView;
import journeymap.client.properties.CoreProperties;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.properties.MapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.draw.RadarDrawStepFactory;
import journeymap.client.render.draw.WaypointDrawStepFactory;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.PolicySet;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.IntegerField;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;

public class MapState {
    public final int minZoom = 0;
    public final int maxZoom = 5;
    public AtomicBoolean follow = new AtomicBoolean(true);
    public String playerLastPos = "0,0";
    private StatTimer refreshTimer = StatTimer.get("MapState.refresh");
    private StatTimer generateDrawStepsTimer = StatTimer.get("MapState.generateDrawSteps");
    private MapView lastMapView;
    private File worldDir = null;
    private long lastRefresh = 0L;
    private long lastMapTypeChange = 0L;
    private IntegerField lastSlice = new IntegerField(Category.Hidden, "", 0, 15, 4);
    private boolean dayMappingAllowed = false;
    private boolean nightMappingAllowed = false;
    private boolean caveMappingAllowed = false;
    private boolean topoMappingAllowed = false;
    private boolean biomeMappingAllowed = false;
    private boolean caveMappingEnabled = false;
    private List<DrawStep> drawStepList = new ArrayList<DrawStep>();
    private List<DrawWayPointStep> drawWaypointStepList = new ArrayList<DrawWayPointStep>();
    private String playerBiome = "";
    private InGameMapProperties lastMapProperties = null;
    private List<EntityDTO> entityList = new ArrayList<EntityDTO>(32);
    private int lastPlayerChunkX = 0;
    private int lastPlayerChunkY = 0;
    private int lastPlayerChunkZ = 0;
    private boolean highQuality;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Minecraft mc, EntityPlayer player, InGameMapProperties mapProperties) {
        World world = Journeymap.clientWorld();
        if (world == null || world.field_73011_w == null) {
            return;
        }
        this.refreshTimer.start();
        try {
            CoreProperties coreProperties = Journeymap.getClient().getCoreProperties();
            this.lastMapProperties = mapProperties;
            this.worldDir = FileHandler.getJMWorldDir(mc);
            if (world != null && world.func_72940_L() != 256 && this.lastSlice.getMaxValue() != 15) {
                int maxSlice = world.func_72940_L() / 16 - 1;
                int seaLevel = Math.round(world.func_181545_F() / 16);
                int currentSlice = this.lastSlice.get();
                this.lastSlice = new IntegerField(Category.Hidden, "", 0, maxSlice, seaLevel);
                this.lastSlice.set(currentSlice);
            }
            boolean hasSurface = !(world.field_73011_w instanceof WorldProviderHell);
            int dimension = world.field_73011_w.getDimension();
            PolicySet policy = ClientFeatures.instance().get(dimension);
            this.caveMappingAllowed = policy.isAllowed(Feature.MapType.Underground);
            this.caveMappingEnabled = this.caveMappingAllowed && mapProperties.showCaves.get() != false;
            this.dayMappingAllowed = hasSurface && policy.isAllowed(Feature.MapType.Day);
            this.nightMappingAllowed = hasSurface && policy.isAllowed(Feature.MapType.Night);
            this.topoMappingAllowed = hasSurface && policy.isAllowed(Feature.MapType.Topo) && coreProperties.mapTopography.get() != false;
            this.biomeMappingAllowed = policy.isAllowed(Feature.MapType.Biome);
            this.highQuality = coreProperties.tileHighDisplayQuality.get();
            this.lastPlayerChunkX = player.field_70176_ah;
            this.lastPlayerChunkY = player.field_70162_ai;
            this.lastPlayerChunkZ = player.field_70164_aj;
            EntityDTO playerDTO = DataCache.getPlayer();
            this.playerBiome = playerDTO.biome;
            if (this.lastMapView != null) {
                if (player.field_71093_bK != this.lastMapView.dimension) {
                    this.lastMapView = null;
                } else if (this.caveMappingEnabled && this.follow.get() && playerDTO.underground.booleanValue() && !this.lastMapView.isUnderground()) {
                    this.lastMapView = null;
                } else if (!this.lastMapView.isAllowed()) {
                    this.lastMapView = null;
                }
            }
            this.lastMapView = this.getMapView();
            this.updateLastRefresh();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error refreshing MapState: " + LogFormatter.toPartialString(e));
        }
        finally {
            this.refreshTimer.stop();
        }
    }

    public MapView setMapType(Feature.MapType mapType) {
        if (mapType == null) {
            return this.setMapType(MapView.NONE);
        }
        return this.setMapType(MapView.from(mapType, DataCache.getPlayer()));
    }

    public MapView toggleMapType() {
        Feature.MapType next = this.getNextMapType(this.getMapView().mapType);
        return this.setMapType(next);
    }

    public Feature.MapType getNextMapType(Feature.MapType mapType) {
        EntityDTO player = DataCache.getPlayer();
        if (player.entityRef.get() == null) {
            return mapType;
        }
        ArrayList<Feature.MapType> types = new ArrayList<Feature.MapType>(4);
        if (this.dayMappingAllowed) {
            types.add(Feature.MapType.Day);
        }
        if (this.nightMappingAllowed) {
            types.add(Feature.MapType.Night);
        }
        if (this.caveMappingAllowed && (player.underground.booleanValue() || mapType == Feature.MapType.Underground)) {
            types.add(Feature.MapType.Underground);
        }
        if (this.topoMappingAllowed) {
            types.add(Feature.MapType.Topo);
        }
        if (mapType == null && !types.isEmpty()) {
            return (Feature.MapType)types.get(0);
        }
        if (types.contains(mapType)) {
            Iterator cyclingIterator = Iterables.cycle(types).iterator();
            while (cyclingIterator.hasNext()) {
                Feature.MapType current = (Feature.MapType)cyclingIterator.next();
                if (current != mapType) continue;
                return (Feature.MapType)cyclingIterator.next();
            }
        }
        return mapType;
    }

    public MapView setMapType(MapView mapView) {
        if (!mapView.isAllowed() && !(mapView = MapView.from(this.getNextMapType(mapView.mapType), DataCache.getPlayer())).isAllowed()) {
            mapView = MapView.none();
        }
        EntityDTO player = DataCache.getPlayer();
        if (player.underground.booleanValue() != mapView.isUnderground()) {
            this.follow.set(false);
        }
        if (mapView.isUnderground()) {
            if (player.chunkCoordY != mapView.vSlice) {
                this.follow.set(false);
            }
            this.lastSlice.set(mapView.vSlice);
        } else if (!mapView.isNone() && this.lastMapProperties.preferredMapType.get() != mapView.mapType) {
            this.lastMapProperties.preferredMapType.set(mapView.mapType);
            this.lastMapProperties.save();
        }
        this.setLastMapTypeChange(mapView);
        return this.lastMapView;
    }

    public MapView getMapView() {
        if (this.lastMapView == null) {
            EntityDTO player = DataCache.getPlayer();
            MapView mapView = null;
            try {
                if (this.caveMappingEnabled && player.underground.booleanValue()) {
                    mapView = MapView.underground(player);
                } else if (this.follow.get() && !player.underground.booleanValue()) {
                    if (this.dayMappingAllowed) {
                        mapView = MapView.day(player);
                    } else if (this.nightMappingAllowed) {
                        mapView = MapView.night(player);
                    } else if (this.topoMappingAllowed) {
                        mapView = MapView.topo(player);
                    }
                }
                if (mapView == null && this.lastMapProperties != null) {
                    mapView = MapView.from((Feature.MapType)this.lastMapProperties.preferredMapType.get(), player);
                }
            }
            catch (Exception e) {
                mapView = MapView.day(player);
            }
            this.setMapType(mapView);
        }
        return this.lastMapView;
    }

    public long getLastMapTypeChange() {
        return this.lastMapTypeChange;
    }

    private void setLastMapTypeChange(MapView mapView) {
        if (!Objects.equal((Object)mapView, (Object)this.lastMapView)) {
            this.lastMapTypeChange = System.currentTimeMillis();
            this.requireRefresh();
        }
        this.lastMapView = mapView;
    }

    public boolean isUnderground() {
        return this.getMapView().isUnderground();
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public String getPlayerBiome() {
        return this.playerBiome;
    }

    public List<? extends DrawStep> getDrawSteps() {
        return this.drawStepList;
    }

    public List<DrawWayPointStep> getDrawWaypointSteps() {
        return this.drawWaypointStepList;
    }

    public void generateDrawSteps(Minecraft mc, GridRenderer gridRenderer, WaypointDrawStepFactory waypointRenderer, RadarDrawStepFactory radarRenderer, InGameMapProperties mapProperties, boolean checkWaypointDistance) {
        this.generateDrawStepsTimer.start();
        this.lastMapProperties = mapProperties;
        this.drawStepList.clear();
        this.drawWaypointStepList.clear();
        this.entityList.clear();
        ClientAPI.INSTANCE.getDrawSteps(this.drawStepList, gridRenderer.getUIState());
        int dimension = this.getDimension();
        PolicySet policy = ClientFeatures.instance().get(dimension);
        if (policy.isAllowed(Feature.Radar.Vehicle) && mapProperties.showVehicles.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getVehicles(false).values());
        }
        if (policy.isAllowed(Feature.Radar.PassiveMob) && (mapProperties.showAnimals.get().booleanValue() || mapProperties.showPets.get().booleanValue())) {
            this.entityList.addAll(DataCache.INSTANCE.getPassiveMobs(false).values());
        }
        if (policy.isAllowed(Feature.Radar.NPC) && mapProperties.showVillagers.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getNpcs(false).values());
        }
        if (policy.isAllowed(Feature.Radar.HostileMob) && mapProperties.showMobs.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getHostileMobs(false).values());
        }
        if (policy.isAllowed(Feature.Radar.Player) && mapProperties.showPlayers.get().booleanValue()) {
            this.entityList.addAll(DataCache.INSTANCE.getPlayers(false).values());
        }
        if (!this.entityList.isEmpty()) {
            Collections.sort(this.entityList, EntityHelper.entityMapComparator);
            this.drawStepList.addAll(radarRenderer.prepareSteps(this.entityList, gridRenderer, mapProperties));
        }
        if (mapProperties.showWaypoints.get().booleanValue() && policy.isAllowed(Feature.Radar.Waypoint)) {
            boolean showLabel = mapProperties.showWaypointLabels.get();
            this.drawWaypointStepList.addAll(waypointRenderer.prepareSteps(WaypointStore.INSTANCE.getAll(dimension), gridRenderer, checkWaypointDistance, showLabel));
        }
        this.generateDrawStepsTimer.stop();
    }

    public boolean zoomIn() {
        if (this.lastMapProperties.zoomLevel.get() < 5) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() + 1);
        }
        return false;
    }

    public boolean zoomOut() {
        if (this.lastMapProperties.zoomLevel.get() > 0) {
            return this.setZoom(this.lastMapProperties.zoomLevel.get() - 1);
        }
        return false;
    }

    public boolean setZoom(int zoom) {
        if (zoom > 5 || zoom < 0 || zoom == this.lastMapProperties.zoomLevel.get()) {
            return false;
        }
        this.lastMapProperties.zoomLevel.set(zoom);
        this.requireRefresh();
        return true;
    }

    public int getZoom() {
        return this.lastMapProperties.zoomLevel.get();
    }

    public void requireRefresh() {
        this.lastRefresh = 0L;
    }

    public void updateLastRefresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public boolean shouldRefresh(Minecraft mc, MapProperties mapProperties) {
        if (ClientAPI.INSTANCE.isDrawStepsUpdateNeeded()) {
            return true;
        }
        if (MapPlayerTask.getlastTaskCompleted() - this.lastRefresh > 500L) {
            return true;
        }
        if (this.lastMapView == null) {
            return true;
        }
        EntityDTO player = DataCache.getPlayer();
        if (this.getMapView().dimension != player.dimension) {
            return true;
        }
        double d0 = this.lastPlayerChunkX - player.chunkCoordX;
        double d1 = this.lastPlayerChunkY - player.chunkCoordY;
        double d2 = this.lastPlayerChunkZ - player.chunkCoordZ;
        double diff = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        if (diff > 2.0) {
            return true;
        }
        return this.lastMapProperties == null || !this.lastMapProperties.equals(mapProperties);
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public boolean isCaveMappingAllowed() {
        return this.caveMappingAllowed;
    }

    public boolean isCaveMappingEnabled() {
        return this.caveMappingEnabled;
    }

    public boolean isDayMappingAllowed() {
        return this.dayMappingAllowed;
    }

    public boolean isNightMappingAllowed() {
        return this.nightMappingAllowed;
    }

    public boolean isTopoMappingAllowed() {
        return this.topoMappingAllowed;
    }

    public boolean isBiomeMappingAllowed() {
        return this.biomeMappingAllowed;
    }

    public int getDimension() {
        return this.getMapView().dimension;
    }

    public IntegerField getLastSlice() {
        return this.lastSlice;
    }

    public void resetMapType() {
        this.lastMapView = null;
    }
}

