/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.model.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.render.draw.DrawEntityStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.minimap.EntityDisplay;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.PolicySet;
import journeymap.common.log.LogFormatter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;

public class RadarDrawStepFactory {
    public List<DrawStep> prepareSteps(List<EntityDTO> entityDTOs, GridRenderer grid, InGameMapProperties mapProperties) {
        int dimension = grid.getMapView().dimension;
        PolicySet policySet = ClientFeatures.instance().get(dimension);
        boolean showPassiveMobs = mapProperties.showAnimals.get() != false && policySet.isAllowed(Feature.Radar.PassiveMob);
        boolean showPets = mapProperties.showPets.get() != false && policySet.isAllowed(Feature.Radar.PassiveMob);
        boolean showVillagers = mapProperties.showVillagers.get() != false && policySet.isAllowed(Feature.Radar.NPC);
        boolean showHostileMobs = mapProperties.showMobs.get() != false && policySet.isAllowed(Feature.Radar.HostileMob);
        boolean showVehicles = mapProperties.showVehicles.get() != false && policySet.isAllowed(Feature.Radar.Vehicle);
        boolean showPlayers = mapProperties.showPlayers.get() != false && policySet.isAllowed(Feature.Radar.Player);
        EntityDisplay mobDisplay = (EntityDisplay)mapProperties.mobDisplay.get();
        EntityDisplay playerDisplay = (EntityDisplay)mapProperties.playerDisplay.get();
        boolean showMobHeading = mapProperties.showMobHeading.get();
        boolean showPlayerHeading = mapProperties.showPlayerHeading.get();
        boolean showEntityNames = mapProperties.showEntityNames.get();
        ArrayList<DrawStep> drawStepList = new ArrayList<DrawStep>();
        try {
            for (EntityDTO dto : entityDTOs) {
                try {
                    boolean isPet;
                    TextureImpl entityIcon = null;
                    TextureImpl locatorImg = null;
                    Entity entity = (Entity)dto.entityRef.get();
                    if (entity == null || grid.getPixel(dto.posX, dto.posZ) == null) continue;
                    boolean bl = isPet = !Strings.isNullOrEmpty((String)dto.owner);
                    if (!showPets && isPet || !showPassiveMobs && dto.passiveAnimal && (!isPet || !showPets) || !showHostileMobs && Boolean.TRUE == dto.hostile || !showVillagers && (dto.profession != null || dto.npc)) continue;
                    boolean isPlayer = entity instanceof EntityPlayer;
                    if (!showPlayers && isPlayer) continue;
                    if (entity instanceof EntityMinecart || entity instanceof EntityBoat) {
                        entity.func_70005_c_();
                    }
                    if (!showVehicles && (entity instanceof EntityMinecart || entity instanceof EntityBoat)) continue;
                    DrawEntityStep drawStep = DataCache.INSTANCE.getDrawEntityStep(entity);
                    if (isPlayer) {
                        locatorImg = EntityDisplay.getLocatorTexture(playerDisplay, showPlayerHeading);
                        entityIcon = EntityDisplay.getEntityTexture(playerDisplay, entity.func_70005_c_());
                        drawStep.update(playerDisplay, locatorImg, entityIcon, dto.color, showPlayerHeading, false);
                        drawStepList.add(drawStep);
                        continue;
                    }
                    locatorImg = EntityDisplay.getLocatorTexture(mobDisplay, showMobHeading);
                    entityIcon = EntityDisplay.getEntityTexture(mobDisplay, dto.entityIconLocation);
                    EntityDisplay actualDisplay = mobDisplay;
                    if (!mobDisplay.isDots() && entityIcon == null) {
                        actualDisplay = mobDisplay.isLarge() ? EntityDisplay.LargeDots : EntityDisplay.SmallDots;
                        entityIcon = EntityDisplay.getEntityTexture(actualDisplay, dto.entityIconLocation);
                    }
                    drawStep.update(actualDisplay, locatorImg, entityIcon, dto.color, showMobHeading, showEntityNames);
                    drawStepList.add(drawStep);
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Exception during prepareSteps: " + LogFormatter.toString(e));
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Throwable during prepareSteps: " + LogFormatter.toString(t));
        }
        return drawStepList;
    }
}

