/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import journeymap.client.Constants;
import journeymap.client.data.DataCache;
import journeymap.client.feature.ClientFeatures;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.CheckBox;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.dialog.FullscreenActions;
import journeymap.client.ui.waypoint.DimensionsButton;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.Policy;
import journeymap.common.feature.PolicySet;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.TextFormatting;

public class FeatureDialog
extends JmUI {
    private static List<Feature> HIDDEN = Arrays.asList(Feature.Display.Compass, Feature.MapType.Biome, Feature.Radar.Vehicle);
    private ScrollPane scrollPane;
    private DimensionsButton buttonDimensions;
    private Button buttonClose;
    private OnOffButton buttonView;
    private CheckBox buttonOverride;
    private Button buttonReport;
    private int dimension;
    private int lastWidth;
    private boolean isCreative;
    private List<String> noticeLines;
    private int[] columnWidths;
    private int listHeight;
    private final int lineHeight;
    private final int vpad = 5;

    public FeatureDialog() {
        this((JmUI)null);
    }

    public FeatureDialog(JmUI returnDisplay) {
        super(Constants.getString("jm.common.features"), returnDisplay);
        this.lineHeight = FeatureDialog.fontRenderer().field_78288_b + 4;
        this.vpad = 5;
    }

    @Override
    public void func_146280_a(Minecraft minecraft, int width, int height) {
        if (height != this.field_146295_m) {
            this.listHeight = 0;
        }
        super.func_146280_a(minecraft, width, height);
    }

    @Override
    public void func_73866_w_() {
        int pad;
        this.field_146292_n.clear();
        this.isCreative = this.field_146297_k.field_71442_b.func_178889_l().func_77145_d();
        FontRenderer fr = this.getFontRenderer();
        if (this.buttonDimensions == null) {
            this.buttonDimensions = new DimensionsButton();
            this.buttonDimensions.setDefaultStyle(false);
            this.buttonDimensions.setDrawBackground(false);
            this.buttonDimensions.setDrawFrame(false);
            this.buttonDimensions.resetLabelColors();
        }
        this.field_146292_n.add(this.buttonDimensions);
        if (this.buttonView == null) {
            this.buttonView = new OnOffButton(Constants.getString("jm.common.features.audit_view_current"), Constants.getString("jm.common.features.audit_view_changes"), true);
            this.buttonView.setDefaultStyle(false);
            this.buttonView.setDrawBackground(false);
            this.buttonView.setDrawFrame(false);
            this.buttonView.fitWidth(fr);
        }
        this.field_146292_n.add(this.buttonView);
        if (this.buttonReport == null) {
            this.buttonReport = new Button(Constants.getString("jm.common.features.notice.button"));
            this.buttonReport.fitWidth(fr);
        }
        this.field_146292_n.add(this.buttonReport);
        if (this.buttonOverride == null) {
            this.buttonOverride = new CheckBox(Constants.getString("jm.common.features.override"), false);
            this.buttonOverride.setEnabled(this.isCreative);
            if (!this.buttonOverride.field_146124_l) {
                this.buttonOverride.setTooltip(Constants.getString("jm.common.features.override.tooltip"));
            }
            this.buttonOverride.setLabelColors(0xE0E0E0, 0xFFFFA0, 0x666666);
        }
        this.field_146292_n.add(this.buttonOverride);
        if (this.buttonClose == null) {
            this.buttonClose = new Button(Constants.getString("jm.common.close"));
            this.buttonClose.fitWidth(fr);
            this.buttonClose.func_175211_a(Math.max(this.buttonClose.getWidth(), 150));
        }
        this.field_146292_n.add(this.buttonClose);
        ButtonList buttonsRow = new ButtonList(this.buttonReport, this.buttonClose);
        buttonsRow.layoutDistributedHorizontal(10, this.field_146295_m - this.buttonClose.getHeight() - 5, this.field_146294_l - 10, true);
        this.dimension = DimensionsButton.currentWorldProvider == null ? DataCache.getPlayer().dimension : DimensionsButton.currentWorldProvider.getDimension();
        PolicySet policySet = ClientFeatures.instance().get(this.dimension);
        List<Policy> policies = this.isViewCurrentStatus() ? new ArrayList<Policy>(policySet.getPolicyMap().values()) : ClientFeatures.instance().get(this.dimension).getAuditQueue();
        TreeSet<FeatureLine> lineSet = new TreeSet<FeatureLine>();
        for (Policy policyChange : policies) {
            if (HIDDEN.contains(policyChange.getFeature())) continue;
            lineSet.add(new FeatureLine(policyChange));
        }
        ArrayList<FeatureLine> lines = new ArrayList<FeatureLine>(lineSet);
        lines.add(0, new FeatureLine(Constants.getString("jm.common.features.column_category"), Constants.getString("jm.common.features.column_feature"), Constants.getString("jm.common.features.column_origin")));
        int cols = ((FeatureLine)lines.iterator().next()).featureColumns.length;
        if (this.columnWidths == null || this.columnWidths.length != cols) {
            this.columnWidths = new int[cols];
        }
        for (int i = 0; i < cols; ++i) {
            int colWidth = this.columnWidths[i];
            Object object = lines.iterator();
            while (object.hasNext()) {
                FeatureLine line = (FeatureLine)object.next();
                colWidth = Math.max(colWidth, fr.func_78256_a(line.featureColumns[i].label));
            }
            this.columnWidths[i] = colWidth;
            for (FeatureLine line : lines) {
                line.featureColumns[i].width = colWidth;
            }
        }
        int lineWidth = pad = 15;
        for (int colWidth : this.columnWidths) {
            lineWidth += colWidth + pad;
        }
        lineWidth = Math.max(lineWidth, this.lastWidth);
        lineWidth = Math.max(lineWidth, this.buttonDimensions.getWidth() + this.buttonView.getWidth() + pad);
        this.lastWidth = lineWidth = Math.min(lineWidth, this.field_146294_l - 20);
        for (FeatureLine line : lines) {
            line.width = lineWidth;
        }
        this.scrollPane = new ScrollPane(this.field_146297_k, lineWidth, 0, lines, this.lineHeight, 3);
        this.scrollPane.func_193651_b(false);
        this.scrollPane.bgColor = 0x222222;
        this.scrollPane.bgAlpha = 1.0f;
    }

    @Override
    protected void layoutButtons() {
        if (this.field_146292_n.isEmpty()) {
            this.func_73866_w_();
        }
        FontRenderer fr = this.getFontRenderer();
        int centerX = this.field_146294_l / 2;
        if (this.noticeLines == null) {
            int fitWidth = this.scrollPane.field_148155_a;
            while (this.noticeLines == null || this.noticeLines.size() > 2) {
                this.noticeLines = fr.func_78271_c(Constants.getString("jm.common.features.notice"), fitWidth);
                fitWidth += 10;
            }
        }
        int noticeY = this.buttonReport.getY() - this.lineHeight * this.noticeLines.size() - 5;
        int overrideY = noticeY - 10 - this.buttonOverride.field_146121_g;
        int listMinY = 40 + this.buttonDimensions.field_146121_g;
        int listMaxY = overrideY - 5;
        int listMinHeight = this.lineHeight * 6;
        int listMaxHeight = listMaxY - listMinY;
        int listIdealHeight = this.scrollPane.func_148146_j() * this.scrollPane.func_148127_b() + this.lineHeight;
        int trialHeight = Math.min(Math.max(listMinHeight, listIdealHeight), listMaxHeight);
        if (trialHeight > this.listHeight) {
            this.listHeight = trialHeight;
        }
        int scrollX = (this.field_146294_l - this.scrollPane.field_148155_a) / 2;
        int scrollY = listMinY;
        if (this.listHeight < listMaxHeight) {
            scrollY += (listMaxHeight - this.listHeight) / 2;
        }
        this.scrollPane.setDimensions(this.scrollPane.field_148155_a, this.listHeight, 0, 0, scrollX, scrollY);
        this.buttonDimensions.rightOf(scrollX - 3).above(scrollY);
        this.buttonView.leftOf(scrollX + this.scrollPane.field_148155_a + 8).above(scrollY);
        overrideY = Math.min(overrideY, scrollY + this.listHeight + 5);
        this.buttonOverride.centerHorizontalOn(centerX + 6).setY(overrideY);
        int lineY = noticeY;
        for (String line : this.noticeLines) {
            this.func_73732_a(fr, line, centerX, lineY, 0xFFFFFF);
            lineY += this.lineHeight;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        try {
            List<String> tooltip;
            this.scrollPane.frameColor = this.isEditable() ? 0xFFFFFF : 0xCCCCCC;
            this.scrollPane.func_148128_a(mouseX, mouseY, partialTicks);
            ScrollPane.Scrollable underMouse = this.scrollPane.getScrollableUnderMouse(mouseX, mouseY);
            if (underMouse != null && (tooltip = underMouse.getTooltip()) != null && !tooltip.isEmpty()) {
                this.drawHoveringText(tooltip, mouseX, underMouse.getY() + underMouse.getHeight() + 2, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.scrollPane.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.scrollPane.func_178039_p();
    }

    protected void func_146284_a(GuiButton guibutton) {
        if (guibutton == this.buttonDimensions) {
            this.buttonDimensions.nextValue();
            if (DimensionsButton.currentWorldProvider == null) {
                this.buttonDimensions.nextValue();
            }
            this.field_146292_n.clear();
            return;
        }
        if (guibutton == this.buttonView) {
            this.buttonView.toggle();
            this.field_146292_n.clear();
            return;
        }
        if (guibutton == this.buttonOverride && this.isCreative) {
            return;
        }
        if (guibutton == this.buttonReport) {
            FullscreenActions.launchEulaViolationWebsite();
            return;
        }
        if (guibutton == this.buttonClose) {
            this.closeAndReturn();
        }
        this.scrollPane.func_148147_a(guibutton);
    }

    private boolean isEditable() {
        return this.isCreative && this.buttonOverride.isActive() && this.isViewCurrentStatus();
    }

    private boolean isViewCurrentStatus() {
        return this.buttonView.isActive();
    }

    private static class FeatureColumn {
        String label;
        String color;
        int width;

        FeatureColumn() {
        }

        FeatureColumn(String label, String color) {
            this.label = label;
            this.color = color;
        }
    }

    public class FeatureLine
    implements ScrollPane.Scrollable,
    Comparable<FeatureLine> {
        int x;
        int y;
        int width;
        int height;
        boolean enabled;
        long timestamp;
        FeatureColumn[] featureColumns;
        String[] tooltip;
        final Feature feature;

        private FeatureLine(String category, String name, String origin) {
            this.height = FeatureDialog.this.lineHeight;
            this.enabled = true;
            this.feature = null;
            String color = TextFormatting.AQUA.toString();
            this.featureColumns = new FeatureColumn[]{new FeatureColumn(category, color), new FeatureColumn(name, color), new FeatureColumn(origin, color)};
            this.tooltip = new String[0];
            this.timestamp = 0L;
        }

        private FeatureLine(Policy policy) {
            this.height = FeatureDialog.this.lineHeight;
            this.feature = policy.getFeature();
            this.initGui(policy);
        }

        private void initGui(Policy policy) {
            String originColor;
            this.enabled = policy.isAllowed();
            this.timestamp = policy.getTimestamp();
            String catName = ClientFeatures.getFeatureCategoryName(this.feature);
            String name = ClientFeatures.getFeatureName(this.feature);
            String tooltip = ClientFeatures.getFeatureTooltip(this.feature);
            String origin = ClientFeatures.getOriginString(policy);
            String string = originColor = origin == null ? TextFormatting.DARK_GRAY.toString() : TextFormatting.GOLD.toString();
            if (this.featureColumns == null) {
                this.featureColumns = new FeatureColumn[]{new FeatureColumn(), new FeatureColumn(), new FeatureColumn()};
            }
            this.featureColumns[0].label = catName;
            this.featureColumns[0].color = TextFormatting.GRAY.toString();
            this.featureColumns[1].label = name;
            this.featureColumns[1].color = this.enabled ? TextFormatting.WHITE.toString() : TextFormatting.RED.toString();
            this.featureColumns[2].label = origin == null ? "-" : origin;
            this.featureColumns[2].color = originColor;
            ArrayList<String> lines = new ArrayList<String>(3);
            lines.add(Joiner.on((String)"").join((Object)this.featureColumns[0].color, (Object)this.featureColumns[0].label, new Object[]{" ", this.featureColumns[1].color, this.featureColumns[1].label}));
            lines.add(TextFormatting.AQUA + tooltip);
            if (!FeatureDialog.this.isViewCurrentStatus()) {
                lines.add(TextFormatting.ITALIC + ClientFeatures.getAuditString(policy));
            }
            this.tooltip = lines.toArray(new String[lines.size()]);
        }

        @Override
        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public void setScrollableWidth(int width) {
            this.width = width;
        }

        @Override
        public int getFitWidth(FontRenderer fr) {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void drawScrollable(Minecraft mc, int mouseX, int mouseY) {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (this.tooltip.length > 0 && mouseOver) {
                DrawUtil.drawRectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0xFFFFFF, 0.3f);
            }
            FontRenderer fr = JmUI.fontRenderer();
            int labelY = this.y + (this.height - fr.field_78288_b) / 2 + 1;
            int categoryWidth = fr.func_78256_a(this.featureColumns[0].label);
            String displayName = this.enabled ? this.featureColumns[1].label : TextFormatting.STRIKETHROUGH + this.featureColumns[1].label;
            boolean editable = FeatureDialog.this.isEditable();
            if (mouseOver && this.feature != null && editable) {
                displayName = TextFormatting.UNDERLINE + displayName;
            }
            boolean dropshadow = true;
            int color = -1;
            int pad = 10;
            int x1 = this.x + pad + this.featureColumns[0].width + pad;
            int x0 = x1 - categoryWidth - pad;
            int x2 = x1 + this.featureColumns[1].width + pad;
            fr.func_175065_a(this.featureColumns[0].color + this.featureColumns[0].label, (float)x0, (float)labelY, color, dropshadow);
            fr.func_175065_a(this.featureColumns[1].color + displayName, (float)x1, (float)labelY, color, dropshadow);
            fr.func_175065_a(this.featureColumns[2].color + this.featureColumns[2].label, (float)x2, (float)labelY, color, dropshadow);
        }

        @Override
        public void drawPartialScrollable(Minecraft mc, int x, int y, int width, int height) {
        }

        @Override
        public void clickScrollable(Minecraft mc, int mouseX, int mouseY) {
            if (this.feature != null && FeatureDialog.this.isEditable()) {
                int dim = FeatureDialog.this.dimension;
                boolean state = ClientFeatures.instance().isAllowed(this.feature, dim);
                Policy policy = ClientFeatures.instance().setAllowed(dim, this.feature, !state, Journeymap.clientPlayer().getDisplayNameString());
                this.initGui(policy);
            }
        }

        @Override
        public List<String> getTooltip() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.tooltip != null && this.tooltip.length > 0) {
                FontRenderer fr = JmUI.fontRenderer();
                for (String line : this.tooltip) {
                    list.addAll(fr.func_78271_c(line, (int)((double)this.width * 0.66)));
                }
            }
            return list;
        }

        private boolean isMouseOver(int mouseX, int mouseY) {
            return this.getY() <= mouseY && mouseY <= this.getY() + this.getHeight() && mouseX >= this.x && mouseX < this.x + this.width;
        }

        @Override
        public int compareTo(FeatureLine o) {
            int result = 0;
            if (this.feature == null) {
                return -1;
            }
            if (!FeatureDialog.this.isViewCurrentStatus()) {
                result = Long.compare(o.timestamp, this.timestamp);
            }
            for (int i = 0; i < this.featureColumns.length; ++i) {
                if (result != 0) {
                    return result;
                }
                result = this.featureColumns[i].label.compareTo(o.featureColumns[i].label);
            }
            return result;
        }
    }
}

