/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.awt.Color;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import journeymap.client.Constants;
import journeymap.client.api.display.Waypoint;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.DimensionsButton;
import journeymap.client.ui.waypoint.WaypointChat;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.FMLClientHandler;

public class WaypointManagerItem
implements ScrollListPane.ISlot {
    static Integer background = new Color(20, 20, 20).getRGB();
    static Integer backgroundHover = new Color(40, 40, 40).getRGB();
    final FontRenderer fontRenderer;
    final WaypointManager manager;
    int x;
    int y;
    int width;
    int internalWidth;
    Integer distance;
    Waypoint waypoint;
    OnOffButton buttonEnable;
    Button buttonRemove;
    Button buttonEdit;
    Button buttonFind;
    Button buttonTeleport;
    Button buttonChat;
    int hgap = 4;
    ButtonList buttonListLeft;
    ButtonList buttonListRight;
    int slotIndex;
    SlotMetadata<Waypoint> slotMetadata;
    final boolean canUserTeleport;

    public WaypointManagerItem(Waypoint waypoint, FontRenderer fontRenderer, WaypointManager manager) {
        boolean id = false;
        this.waypoint = waypoint;
        this.fontRenderer = fontRenderer;
        this.manager = manager;
        boolean tpAllowed = false;
        Integer currentDimension = this.getCurrentDimension();
        if (manager.canUserTeleport.booleanValue()) {
            EntityPlayerSP player = Journeymap.clientPlayer();
            tpAllowed = player != null && currentDimension != null && CmdTeleportWaypoint.isPermitted(player.field_71093_bK, currentDimension);
        }
        this.canUserTeleport = tpAllowed;
        String on = Constants.getString("jm.common.on");
        String off = Constants.getString("jm.common.off");
        this.buttonEnable = new OnOffButton(on, off, true);
        if (currentDimension != null) {
            this.buttonEnable.setToggled(waypoint.isDisplayed(currentDimension));
            this.buttonEnable.setEnabled(true);
        } else {
            this.buttonEnable.setEnabled(false);
        }
        this.buttonFind = new Button(Constants.getString("jm.waypoint.find"));
        this.buttonFind.setLabelColors(0xE0E0E0, 0xFFFFA0, 0x666666);
        this.buttonTeleport = new Button(Constants.getString("jm.waypoint.teleport"));
        this.buttonTeleport.setDrawButton(manager.canUserTeleport);
        this.buttonTeleport.setLabelColors(0xE0E0E0, 0xFFFFA0, 0x666666);
        if (manager.canUserTeleport.booleanValue() && !this.canUserTeleport) {
            this.buttonTeleport.setTooltip(Constants.getString("jm.waypoint.teleport.dim_error"));
        }
        this.buttonListLeft = new ButtonList(this.buttonEnable, this.buttonFind, this.buttonTeleport);
        this.buttonListLeft.setHeights(manager.rowHeight);
        this.buttonListLeft.fitWidths(fontRenderer);
        this.buttonEdit = new Button(Constants.getString("jm.waypoint.edit"));
        this.buttonRemove = new Button(Constants.getString("jm.waypoint.remove"));
        this.buttonChat = new Button(Constants.getString("jm.waypoint.chat"));
        this.buttonChat.setTooltip(Constants.getString("jm.waypoint.chat.tooltip"));
        this.buttonListRight = new ButtonList(this.buttonChat, this.buttonEdit, this.buttonRemove);
        this.buttonListRight.setHeights(manager.rowHeight);
        this.buttonListRight.fitWidths(fontRenderer);
        this.internalWidth = fontRenderer.func_78263_a('X') * 32;
        this.internalWidth += Math.max(manager.colLocation, manager.colName);
        this.internalWidth += this.buttonListLeft.getWidth(this.hgap);
        this.internalWidth += this.buttonListRight.getWidth(this.hgap);
        this.internalWidth += 10;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setSlotIndex(int slotIndex) {
        this.slotIndex = slotIndex;
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getFitWidth(FontRenderer fr) {
        return this.width;
    }

    public int getHeight() {
        return this.manager.rowHeight;
    }

    public void drawPartialScrollable(Minecraft mc, int x, int y, int width, int height) {
        DrawUtil.drawRectangle(this.x, this.y, this.width, this.manager.rowHeight, background, 0.4f);
    }

    protected void drawLabels(int x, int y) {
        if (this.waypoint == null) {
            return;
        }
        boolean waypointValid = true;
        Integer currentDimension = this.getCurrentDimension();
        if (currentDimension != null) {
            waypointValid = this.waypoint.isDisplayed(currentDimension);
        }
        int color = waypointValid ? this.waypoint.getOrDefaultLabelColor(0xFFFFFF) : 0x808080;
        FontRenderer fr = JmUI.fontRenderer();
        int yOffset = 1 + (this.manager.rowHeight - fr.field_78288_b) / 2;
        fr.func_175063_a(String.format("%sm", this.getDistance()), (float)(x + this.manager.colLocation), (float)(y + yOffset), color);
        String name = waypointValid ? this.waypoint.getName() : TextFormatting.STRIKETHROUGH + this.waypoint.getName();
        fr.func_175063_a(name, (float)this.manager.colName, (float)(y + yOffset), color);
    }

    protected void drawWaypoint(int x, int y) {
        TextureImpl wpTexture = TextureCache.getTexture(WaypointStore.getWaypointIcon(this.waypoint).getImageLocation());
        DrawUtil.drawColoredImage(wpTexture, this.waypoint.getOrDefaultIconColor(0xFFFFFF), 1.0f, x, y - wpTexture.getHeight() / 2, 0.0);
    }

    protected void enableWaypoint(int dim, boolean enable) {
        this.buttonEnable.setToggled(enable);
        this.waypoint.setDisplayed(dim, enable);
    }

    protected int getButtonEnableCenterX() {
        return this.buttonEnable.getCenterX();
    }

    protected int getNameLeftX() {
        return this.x + this.manager.getMargin() + this.manager.colName;
    }

    protected int getLocationLeftX() {
        return this.x + this.manager.getMargin() + this.manager.colLocation;
    }

    public boolean clickScrollable(int mouseX, int mouseY) {
        boolean mouseOver = false;
        if (this.waypoint == null) {
            return false;
        }
        if (this.buttonChat.mouseOver(mouseX, mouseY)) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new WaypointChat(this.waypoint));
            mouseOver = true;
        } else if (this.buttonRemove.mouseOver(mouseX, mouseY)) {
            this.manager.removeWaypoint(this);
            this.waypoint = null;
            mouseOver = true;
        } else if (this.buttonEnable.mouseOver(mouseX, mouseY)) {
            this.buttonEnable.toggle();
            this.setEnabled(this.buttonEnable.getToggled());
            mouseOver = true;
        } else if (this.buttonEdit.mouseOver(mouseX, mouseY)) {
            UIManager.INSTANCE.openWaypointEditor(this.waypoint, false, this.manager);
            mouseOver = true;
        } else if (this.buttonFind.isEnabled() && this.buttonFind.mouseOver(mouseX, mouseY)) {
            UIManager.INSTANCE.openFullscreenMap(this.waypoint);
            mouseOver = true;
        } else if (this.canUserTeleport && this.buttonTeleport.mouseOver(mouseX, mouseY)) {
            Integer targetDim = this.getCurrentDimension();
            if (targetDim == null) {
                targetDim = this.waypoint.getDimension();
            }
            new CmdTeleportWaypoint(this.waypoint, targetDim).run();
            Fullscreen.state().follow.set(true);
            UIManager.INSTANCE.closeAll();
            mouseOver = true;
        }
        return mouseOver;
    }

    public int getDistance() {
        return this.distance == null ? 0 : this.distance;
    }

    public int getDistanceTo(EntityPlayer player) {
        if (this.distance == null) {
            this.distance = (int)player.func_174791_d().func_72438_d(this.waypoint.getVec(player.field_71093_bK));
        }
        return this.distance;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        Minecraft mc = this.manager.getMinecraft();
        this.width = listWidth;
        this.setPosition(x, y);
        if (this.waypoint == null) {
            return;
        }
        boolean hover = this.manager.isSelected(this) || mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.manager.rowHeight;
        this.buttonListLeft.setOptions(true, hover, true);
        this.buttonListRight.setOptions(true, hover, true);
        Integer color = hover ? backgroundHover : background;
        float alpha = hover ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(this.x, this.y, this.width, this.manager.rowHeight, color, alpha);
        int margin = this.manager.getMargin();
        this.drawWaypoint(this.x + margin + this.manager.colWaypoint, this.y + this.manager.rowHeight / 2);
        this.drawLabels(this.x + margin, this.y);
        this.buttonTeleport.setEnabled(this.canUserTeleport);
        this.buttonFind.setEnabled(this.waypoint.isDisplayed(Fullscreen.state().getDimension()));
        this.buttonListRight.layoutHorizontal(x + this.width - margin, y, false, this.hgap).draw(mc, mouseX, mouseY);
        this.buttonListLeft.layoutHorizontal(this.buttonListRight.getLeftX() - this.hgap * 2, y, false, this.hgap).draw(mc, mouseX, mouseY);
    }

    public void setSelected(int p_178011_1_, int p_178011_2_, int p_178011_3_, float partialTicks) {
    }

    public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
    }

    public boolean func_148278_a(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        return this.clickScrollable(x, y);
    }

    @Override
    public String[] mouseHover(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        for (Button button : this.buttonListLeft) {
            if (!button.func_146115_a()) continue;
            this.manager.drawHoveringText(button.getTooltip(), x, y, JmUI.fontRenderer());
        }
        return new String[0];
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }

    @Override
    public boolean keyTyped(char c, int i) {
        return false;
    }

    public List<ScrollListPane.ISlot> getChildSlots(int listWidth, int columnWidth) {
        return null;
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.buttonEnable.setToggled(enabled);
        Integer currentDimension = this.getCurrentDimension();
        if (currentDimension != null) {
            this.waypoint.setDisplayed(currentDimension, this.buttonEnable.getToggled());
            if (this.waypoint.isDirty()) {
                WaypointStore.INSTANCE.save(this.waypoint);
            }
        }
    }

    @Override
    public int getColumnWidth() {
        return this.width;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    private Integer getCurrentDimension() {
        if (DimensionsButton.currentWorldProvider != null) {
            return DimensionsButton.currentWorldProvider.getDimension();
        }
        return null;
    }

    static class DistanceComparator
    extends Sort {
        EntityPlayer player;

        public DistanceComparator(EntityPlayer player, boolean ascending) {
            super(ascending);
            this.player = player;
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            double dist1 = o1.getDistanceTo(this.player);
            double dist2 = o2.getDistanceTo(this.player);
            if (this.ascending) {
                return Double.compare(dist1, dist2);
            }
            return Double.compare(dist2, dist1);
        }
    }

    static class NameComparator
    extends Sort {
        public NameComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(WaypointManagerItem o1, WaypointManagerItem o2) {
            if (this.ascending) {
                return o1.waypoint.getName().compareToIgnoreCase(o2.waypoint.getName());
            }
            return o2.waypoint.getName().compareToIgnoreCase(o1.waypoint.getName());
        }
    }

    static abstract class Sort
    implements Comparator<WaypointManagerItem> {
        boolean ascending;

        Sort(boolean ascending) {
            this.ascending = ascending;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.ascending ? 1 : 0;
        }
    }
}

