/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Since;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.display.WaypointGroup;
import journeymap.client.api.model.MapImage;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.waypoint.WaypointGroupStore;
import journeymap.common.Journeymap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

@Deprecated
public class WaypointLegacy
implements Serializable {
    public static final int VERSION = 3;
    public static final Gson GSON = new GsonBuilder().setVersion(3.0).create();
    protected static final String ICON_NORMAL = "waypoint-normal.png";
    protected static final String ICON_DEATH = "waypoint-death.png";
    @Since(value=1.0)
    protected String id;
    @Since(value=1.0)
    protected String name;
    @Since(value=3.0)
    protected String groupName;
    @Since(value=2.0)
    protected String displayId;
    @Since(value=1.0)
    protected String icon;
    @Since(value=1.0)
    protected int x;
    @Since(value=1.0)
    protected int y;
    @Since(value=1.0)
    protected int z;
    @Since(value=1.0)
    protected int r;
    @Since(value=1.0)
    protected int g;
    @Since(value=1.0)
    protected int b;
    @Since(value=1.0)
    protected boolean enable;
    @Since(value=1.0)
    protected Type type;
    @Since(value=1.0)
    protected String origin;
    @Since(value=1.0)
    protected TreeSet<Integer> dimensions;
    @Since(value=2.0)
    protected boolean persistent;

    public WaypointLegacy() {
    }

    public WaypointLegacy(String name, BlockPos pos, Color color, Type type, Integer currentDimension) {
        this(name, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true, color.getRed(), color.getGreen(), color.getBlue(), type, "journeymap", currentDimension, Arrays.asList(currentDimension));
    }

    public WaypointLegacy(String name, int x, int y, int z, boolean enable, int red, int green, int blue, Type type, String origin, Integer currentDimension, Collection<Integer> dimensions) {
        if (name == null) {
            name = WaypointLegacy.createName(x, z);
        }
        if (dimensions == null || dimensions.size() == 0) {
            dimensions = new TreeSet<Integer>();
            dimensions.add(Journeymap.clientWorld().field_73011_w.getDimension());
        }
        this.dimensions = new TreeSet<Integer>(dimensions);
        this.dimensions.add(currentDimension);
        this.name = name;
        this.setLocation(x, y, z, currentDimension);
        this.r = red;
        this.g = green;
        this.b = blue;
        this.enable = enable;
        this.type = type;
        this.origin = origin;
        this.persistent = true;
        switch (type) {
            case Normal: {
                this.icon = ICON_NORMAL;
                break;
            }
            case Death: {
                this.icon = ICON_DEATH;
            }
        }
    }

    private static String createName(int x, int z) {
        return String.format("%s, %s", x, z);
    }

    public static WaypointLegacy fromString(String json) {
        return (WaypointLegacy)GSON.fromJson(json, WaypointLegacy.class);
    }

    public Waypoint toWaypoint() {
        Waypoint wp = new Waypoint(this.getOrigin(), this.getId(), this.getName(), this.getDimension(), this.getBlockPos());
        Integer color = this.getColor();
        if (color != null) {
            wp.setIconColor(color);
        }
        if (this.type == Type.Death) {
            wp.setIcon(new MapImage(TextureCache.Deathpoint, 16, 16));
        }
        for (int dim : this.getDimensions()) {
            wp.setDisplayed(dim, true);
        }
        return wp;
    }

    public void setLocation(int x, int y, int z, int currentDimension) {
        this.x = currentDimension == -1 ? x * 8 : x;
        this.y = y;
        this.z = currentDimension == -1 ? z * 8 : z;
        this.updateId();
    }

    public String updateId() {
        String oldId = this.id;
        this.id = String.format("%s_%s,%s,%s", this.name, this.x, this.y, this.z);
        return oldId;
    }

    public boolean isDeathPoint() {
        return this.type == Type.Death;
    }

    public TextureImpl getTexture() {
        return this.isDeathPoint() ? TextureCache.getTexture(TextureCache.Deathpoint) : TextureCache.getTexture(TextureCache.Waypoint);
    }

    public ChunkPos getChunkCoordIntPair() {
        return new ChunkPos(this.x >> 4, this.z >> 4);
    }

    public WaypointGroup getGroup() {
        return WaypointGroupStore.DEFAULT;
    }

    public Integer getColor() {
        return RGB.toInteger(this.r, this.g, this.b);
    }

    public int getDimension() {
        return this.dimensions.first();
    }

    public Collection<Integer> getDimensions() {
        return this.dimensions;
    }

    public String getId() {
        return this.displayId != null ? this.getGuid() : this.id;
    }

    public String getGuid() {
        return this.origin + ":" + this.displayId;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public double getBlockCenteredX() {
        return (double)this.getX() + 0.5;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getX(), this.getY(), this.getZ());
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public Type getType() {
        return this.type;
    }

    public String getOrigin() {
        return this.origin;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public String toString() {
        return GSON.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaypointLegacy waypoint = (WaypointLegacy)o;
        if (this.b != waypoint.b) {
            return false;
        }
        if (this.enable != waypoint.enable) {
            return false;
        }
        if (this.g != waypoint.g) {
            return false;
        }
        if (this.r != waypoint.r) {
            return false;
        }
        if (this.x != waypoint.x) {
            return false;
        }
        if (this.y != waypoint.y) {
            return false;
        }
        if (this.z != waypoint.z) {
            return false;
        }
        if (!this.dimensions.equals(waypoint.dimensions)) {
            return false;
        }
        if (!this.icon.equals(waypoint.icon)) {
            return false;
        }
        if (!this.id.equals(waypoint.id)) {
            return false;
        }
        if (!this.name.equals(waypoint.name)) {
            return false;
        }
        if (this.origin != waypoint.origin) {
            return false;
        }
        return this.type == waypoint.type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static enum Type {
        Normal,
        Death;

    }
}

