/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.api.display.Waypoint;
import journeymap.client.waypoint.WaypointLegacy;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;

public class WaypointLoader {
    public Collection<Waypoint> loadWaypoints(File waypointDir) {
        ArrayList<Waypoint> waypoints = new ArrayList<Waypoint>();
        File[] files = waypointDir.listFiles((dir, name) -> name.endsWith(".json") && !name.equals("waypoint_groups.json"));
        if (files == null || files.length == 0) {
            return waypoints;
        }
        ArrayList<File> obsoleteFiles = new ArrayList<File>();
        for (File waypointFile : files) {
            Waypoint wp = null;
            if (waypointFile.getName().contains("_waypoint_") && (wp = this.load(waypointFile)) != null) {
                waypoints.add(wp);
                continue;
            }
            wp = this.loadLegacy(waypointFile);
            if (wp == null) continue;
            waypoints.add(wp);
            wp.setDirty(true);
            obsoleteFiles.add(waypointFile);
        }
        obsoleteFiles.forEach(this::remove);
        return waypoints;
    }

    private void remove(File waypointFile) {
        try {
            waypointFile.delete();
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.format("Can't delete waypoint file %s: %s", waypointFile, e.getMessage()));
            waypointFile.deleteOnExit();
        }
    }

    private Waypoint load(File waypointFile) {
        String waypointString = null;
        Waypoint waypoint = null;
        try {
            waypointString = Files.toString((File)waypointFile, (Charset)Charset.forName("UTF-8"));
            waypoint = (Waypoint)WaypointStore.INSTANCE.GSON.fromJson(waypointString, Waypoint.class);
            return waypoint;
        }
        catch (Throwable e) {
            Journeymap.getLogger().error(String.format("Can't load waypoint file %s with contents: %s because %s", waypointFile, waypointString, e.getMessage()));
            return waypoint;
        }
    }

    private Waypoint loadLegacy(File waypointFile) {
        String waypointString = null;
        Waypoint waypoint = null;
        try {
            waypointString = Files.toString((File)waypointFile, (Charset)Charset.forName("UTF-8"));
            waypoint = WaypointLegacy.fromString(waypointString).toWaypoint();
            return waypoint;
        }
        catch (Throwable e) {
            Journeymap.getLogger().error(String.format("Can't load legacy waypoint file %s with contents: %s because %s", waypointFile, waypointString, e.getMessage()));
            return waypoint;
        }
    }
}

