/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import journeymap.common.api.feature.Feature;

public class FeatureSerializer
implements JsonSerializer<Enum<? extends Feature>>,
JsonDeserializer<Feature> {
    private final String BASE = Feature.class.getCanonicalName() + "$";

    public JsonElement serialize(Enum<? extends Feature> src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)String.format("%s.%s", ((Class)typeOfSrc).getSimpleName(), src.name()));
    }

    public Feature deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String prim = json.getAsString();
        int idx = prim.lastIndexOf(46);
        String className = this.BASE + prim.substring(0, idx);
        String name = prim.substring(idx + 1);
        try {
            Class<?> klass = Class.forName(className);
            return (Feature)Enum.valueOf(klass, name);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage());
        }
    }
}

