/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.common.collect.Maps;
import com.google.gson.annotations.Since;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.Policy;
import journeymap.common.feature.PolicySet;

@ParametersAreNonnullByDefault
public class PlayerFeatures {
    public static List<Feature> ALL = Stream.of(Arrays.stream(Feature.Action.values()), Arrays.stream(Feature.Display.values()), Arrays.stream(Feature.MapType.values()), Arrays.stream(Feature.Radar.values())).flatMap(v -> v).collect(Collectors.toList());
    @Since(value=2.0)
    protected final UUID id;
    @Since(value=2.0)
    protected final Map<Integer, PolicySet> dimensionPolicies = Maps.synchronizedNavigableMap(new TreeMap());
    protected transient int auditQueueSize = 0;

    public PlayerFeatures(UUID playerID) {
        this.id = playerID;
    }

    public UUID getID() {
        return this.id;
    }

    public int getAuditQueueSize() {
        return this.auditQueueSize;
    }

    public void setAuditQueueSize(int auditQueueSize) {
        this.auditQueueSize = auditQueueSize;
    }

    public String getJson(int dimension) {
        return this.get(dimension).toJson();
    }

    public boolean isAllowed(Feature feature, int dimension) {
        return this.get(dimension).isAllowed(feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PolicySet get(int dimension) {
        Map<Integer, PolicySet> map = this.dimensionPolicies;
        synchronized (map) {
            return this.dimensionPolicies.computeIfAbsent(dimension, this::initializePolicies);
        }
    }

    public void updatePolicies(PolicySet newPolicies) {
        this.get(newPolicies.getDimension()).update(newPolicies);
    }

    public Policy setAllowed(int dimension, Feature feature, boolean allowed, String origin) {
        return this.get(dimension).setAllowed(feature, allowed, origin);
    }

    public void reset(int dimension) {
        this.get(dimension).reset();
    }

    public void resetAll() {
        for (int dim : this.dimensionPolicies.keySet()) {
            this.reset(dim);
        }
    }

    protected PolicySet initializePolicies(int dimension) {
        PolicySet policySet = new PolicySet(dimension, this.auditQueueSize);
        if (Journeymap.proxy.isOp(this.id)) {
            ALL.forEach(feature -> policySet.setAllowed((Feature)feature, feature.isAllowedForOpByDefault(), "journeymap"));
        }
        return policySet;
    }
}

