/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.feature;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.EvictingQueue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.FeatureSerializer;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.Policy;

@ParametersAreNonnullByDefault
public class PolicySet {
    private static final Supplier<Gson> GSON = Suppliers.memoize(() -> {
        FeatureSerializer fs = new FeatureSerializer();
        return new GsonBuilder().registerTypeAdapter(Feature.Action.class, (Object)fs).registerTypeAdapter(Feature.Display.class, (Object)fs).registerTypeAdapter(Feature.Radar.class, (Object)fs).registerTypeAdapter(Feature.MapType.class, (Object)fs).registerTypeAdapter(Feature.class, (Object)fs).enableComplexMapKeySerialization().create();
    });
    private final int dimension;
    private final IdentityHashMap<Feature, Policy> policyMap = new IdentityHashMap();
    private transient EvictingQueue<Policy> auditQueue = null;

    public static PolicySet fromJson(String json) {
        return (PolicySet)((Gson)GSON.get()).fromJson(json, PolicySet.class);
    }

    public PolicySet(int dimension, int auditQueueSize) {
        this.dimension = dimension;
        if (auditQueueSize > 0) {
            this.auditQueue = EvictingQueue.create((int)auditQueueSize);
        }
    }

    public boolean isAllowed(Feature feature) {
        return this.getPolicy(feature).isAllowed();
    }

    public void setPolicies(Map<Feature, Policy> policyMap) {
        policyMap.forEach((feature, policy) -> this.setPolicy((Policy)policy));
    }

    public Policy setAllowed(Feature feature, boolean allowed, String origin) {
        return this.setPolicy(Policy.update(origin, feature, allowed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getPolicy(Feature feature) {
        IdentityHashMap<Feature, Policy> identityHashMap = this.policyMap;
        synchronized (identityHashMap) {
            return this.policyMap.computeIfAbsent(feature, feat -> {
                Policy policy = Policy.initialize(feature);
                if (this.auditQueue != null) {
                    this.auditQueue.add((Object)policy);
                }
                return policy;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy setPolicy(Policy policy) {
        IdentityHashMap<Feature, Policy> identityHashMap = this.policyMap;
        synchronized (identityHashMap) {
            this.policyMap.put(policy.getFeature(), policy);
        }
        if (this.auditQueue != null) {
            this.auditQueue.add((Object)policy);
        }
        return policy;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void reset() {
        PlayerFeatures.ALL.forEach(feature -> this.setPolicy(Policy.reset(feature)));
    }

    public void update(PolicySet other) {
        this.setPolicies(other.getPolicyMap());
    }

    public void update(Map<Feature, Boolean> featureMap, String origin) {
        featureMap.forEach((feature, allowed) -> this.setAllowed((Feature)feature, (boolean)allowed, origin));
    }

    public Map<Feature, Boolean> getPermissionMap() {
        TreeMap<Feature, Boolean> map = new TreeMap<Feature, Boolean>();
        this.policyMap.forEach((feature, policy) -> map.put((Feature)feature, policy.isAllowed()));
        return map;
    }

    public Map<Feature, Policy> getPolicyMap() {
        this.inflate();
        return new IdentityHashMap<Feature, Policy>(this.policyMap);
    }

    public List<Policy> getAuditQueue() {
        return this.auditQueue != null ? new ArrayList<Policy>((Collection<Policy>)this.auditQueue) : Collections.EMPTY_LIST;
    }

    public String toJson() {
        this.inflate();
        return ((Gson)GSON.get()).toJson((Object)this);
    }

    public void inflate() {
        PlayerFeatures.ALL.forEach(this::isAllowed);
    }
}

