/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network;

import io.netty.buffer.ByteBuf;
import journeymap.client.feature.ClientFeatures;
import journeymap.common.Journeymap;
import journeymap.common.feature.PolicySet;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DimensionPoliciesPacket
implements IMessage {
    public static final String CHANNEL_NAME = "jm_dim_policy";
    private String json;

    public DimensionPoliciesPacket() {
    }

    public DimensionPoliciesPacket(PolicySet policySet) {
        this.json = policySet.toJson();
    }

    public String getJson() {
        return this.json;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.json = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message: %s", t));
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.json != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.json);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes] Failed to read message: " + t);
        }
    }

    public static class Listener
    implements IMessageHandler<DimensionPoliciesPacket, IMessage> {
        public IMessage onMessage(DimensionPoliciesPacket message, MessageContext ctx) {
            try {
                PolicySet serverPolicies = PolicySet.fromJson(message.getJson());
                ClientFeatures.instance().updatePolicies(serverPolicies);
                Journeymap.getClient().setServerEnabled(true);
                String role = Journeymap.proxy.isOp(ctx.getClientHandler().func_175105_e().getId()) ? "Op" : "player";
                Journeymap.getLogger().info(String.format("Client features set for %s by server: %s", role, serverPolicies.toJson()));
                return null;
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("[DimensionPoliciesPacket.Listener.onMessage] " + t, t);
                return null;
            }
        }
    }
}

