/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.api.impl;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.PolicySet;
import journeymap.common.network.PacketHandler;
import journeymap.server.api.IServerAPI;
import journeymap.server.feature.ServerFeatures;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public enum ServerAPI implements IServerAPI
{
    INSTANCE;

    private final Logger LOGGER = Journeymap.getLogger();
    final Map<UUID, PlayerFeatures> playerFeaturesMap = Collections.synchronizedMap(new HashMap());
    final Multimap<UUID, Integer> pausedPlayerQueue = MultimapBuilder.hashKeys().hashSetValues().build();
    final transient ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(0);

    private ServerAPI() {
        this.log("implements JourneyMap API 2.0-SNAPSHOT");
    }

    @Override
    public void setPlayerFeatures(String modId, UUID playerID, int dimension, Map<Feature, Boolean> featureMap) {
        PolicySet policySet = this.getPlayerFeatures(playerID).get(dimension);
        BiConsumer<Feature, Boolean> setter = (feature, allowed) -> policySet.setAllowed((Feature)feature, (boolean)allowed, modId);
        featureMap.forEach(setter);
        EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(playerID);
        if (player != null && !this.pausedPlayerQueue.containsEntry((Object)playerID, (Object)dimension)) {
            this.sendPlayerFeatures(player, dimension, 0);
        }
    }

    @Override
    public Map<Feature, Boolean> getPlayerFeatures(UUID playerID, int dimension) {
        return this.getPlayerFeatures(playerID).get(dimension).getPermissionMap();
    }

    @Override
    public Map<Feature, Boolean> getServerFeatures(int dimension, boolean isOp) {
        return ServerFeatures.createPolicySet(dimension, 0, isOp).getPermissionMap();
    }

    public boolean pauseClientPackets(EntityPlayerMP player) {
        return this.pausedPlayerQueue.put((Object)player.func_110124_au(), (Object)player.field_71093_bK);
    }

    public boolean resumeClientPackets(EntityPlayerMP player) {
        return this.pausedPlayerQueue.remove((Object)player.func_110124_au(), (Object)player.field_71093_bK);
    }

    public void sendPlayerFeatures(EntityPlayerMP player, int dimension, int delayMs) {
        if (delayMs < 1) {
            this.sendPlayerFeatures(player, dimension);
        } else {
            this.taskExecutor.schedule(() -> this.sendPlayerFeatures(player, dimension), (long)delayMs, TimeUnit.MILLISECONDS);
        }
    }

    public void sendPlayerFeatures(EntityPlayerMP player, int dimension) {
        PolicySet policySet = this.getPlayerFeatures(player.func_110124_au()).get(dimension);
        PacketHandler.sendDimensionPolicyPacketToPlayer(player, policySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerFeatures getPlayerFeatures(UUID playerUUID) {
        Map<UUID, PlayerFeatures> map = this.playerFeaturesMap;
        synchronized (map) {
            return this.playerFeaturesMap.computeIfAbsent(playerUUID, ServerFeatures::new);
        }
    }

    private void log(String message) {
        this.LOGGER.info(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    private void logError(String message) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    private void logDebug(String message) {
        this.LOGGER.debug(String.format("[%s] %s", this.getClass().getSimpleName(), message));
    }

    void logError(String message, Throwable t) {
        this.LOGGER.error(String.format("[%s] %s", this.getClass().getSimpleName(), message), t);
    }
}

