/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.feature;

import java.util.UUID;
import journeymap.common.Journeymap;
import journeymap.common.api.feature.Feature;
import journeymap.common.feature.PlayerFeatures;
import journeymap.common.feature.PolicySet;
import journeymap.common.properties.config.FeatureField;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;

public class ServerFeatures
extends PlayerFeatures {
    public ServerFeatures(UUID playerID) {
        super(playerID);
    }

    @Override
    protected PolicySet initializePolicies(int dimension) {
        boolean isOp = Journeymap.proxy.isOp(this.id);
        return ServerFeatures.createPolicySet(dimension, this.auditQueueSize, isOp);
    }

    public static PolicySet createPolicySet(int dimension, int auditQueueSize, boolean isOp) {
        PolicySet policySet = new PolicySet(dimension, auditQueueSize);
        DimensionProperties dimProps = PropertiesManager.getInstance().getDimProperties(dimension, isOp);
        PermissionProperties permProps = dimProps.enabled.get() != false ? dimProps : PropertiesManager.getInstance().getGlobalProperties(isOp);
        PlayerFeatures.ALL.forEach(feature -> {
            FeatureField featureField = permProps.getField((Feature)feature);
            if (featureField != null) {
                policySet.setAllowed((Feature)feature, featureField.get(), permProps.getOriginKey());
            }
        });
        return policySet;
    }
}

