/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import journeymap.common.properties.config.BooleanField;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.PropertiesManager;
import journeymap.server.properties.ServerCategory;

public class DimensionProperties
extends PermissionProperties {
    protected final transient int dimension;
    public final BooleanField enabled = new BooleanField(ServerCategory.General, "Enable Configuration", false).categoryMaster(true);

    public DimensionProperties(int dimension, boolean isOp) {
        super(String.format("Dimension %s %s Configuration", dimension, isOp ? "Op" : "Player"), "Set \"enabled\": \"true\" to override the Global Server Configuration for this dimension", isOp);
        this.dimension = dimension;
    }

    @Override
    public String getName() {
        String target = this.isOp ? "op" : "player";
        return String.format("%s.dim%s", target, this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }

    public DimensionProperties build() {
        return this.build(PropertiesManager.getInstance().getGlobalProperties(this.isOp));
    }

    DimensionProperties build(GlobalProperties gProp) {
        this.copyFrom(gProp);
        this.save();
        return this;
    }

    @Override
    public String getOriginKey() {
        return this.isOp ? "jm.common.server_config_dim" : "jm.common.server_config_op_dim";
    }
}

