/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.properties;

import java.util.HashMap;
import java.util.Map;
import journeymap.common.api.feature.Feature;
import journeymap.common.properties.Category;
import journeymap.common.properties.config.FeatureField;
import journeymap.server.properties.ServerCategory;
import journeymap.server.properties.ServerPropertiesBase;

public abstract class PermissionProperties
extends ServerPropertiesBase {
    protected transient HashMap<Feature, FeatureField> fieldMap = new HashMap();
    final transient boolean isOp;
    public final FeatureField actionTeleport = PermissionProperties.createFeatureField(Feature.Action.Teleport, this.fieldMap);
    public final FeatureField displayCompass = PermissionProperties.createFeatureField(Feature.Display.Compass, this.fieldMap);
    public final FeatureField displayFullscreen = PermissionProperties.createFeatureField(Feature.Display.Fullscreen, this.fieldMap);
    public final FeatureField displayMinimap = PermissionProperties.createFeatureField(Feature.Display.Minimap, this.fieldMap);
    public final FeatureField displayWaypointBeacon = PermissionProperties.createFeatureField(Feature.Display.WaypointBeacon, this.fieldMap);
    public final FeatureField displayWaypointManager = PermissionProperties.createFeatureField(Feature.Display.WaypointManager, this.fieldMap);
    public final FeatureField displayWebmap = PermissionProperties.createFeatureField(Feature.Display.Webmap, this.fieldMap);
    public final FeatureField maptypeBiome = PermissionProperties.createFeatureField(Feature.MapType.Biome, this.fieldMap);
    public final FeatureField maptypeDay = PermissionProperties.createFeatureField(Feature.MapType.Day, this.fieldMap);
    public final FeatureField maptypeNight = PermissionProperties.createFeatureField(Feature.MapType.Night, this.fieldMap);
    public final FeatureField maptypeTopo = PermissionProperties.createFeatureField(Feature.MapType.Topo, this.fieldMap);
    public final FeatureField maptypeUnderground = PermissionProperties.createFeatureField(Feature.MapType.Underground, this.fieldMap);
    public final FeatureField radarHostileMob = PermissionProperties.createFeatureField(Feature.Radar.HostileMob, this.fieldMap);
    public final FeatureField radarNPC = PermissionProperties.createFeatureField(Feature.Radar.NPC, this.fieldMap);
    public final FeatureField radarPassiveMob = PermissionProperties.createFeatureField(Feature.Radar.PassiveMob, this.fieldMap);
    public final FeatureField radarPlayer = PermissionProperties.createFeatureField(Feature.Radar.Player, this.fieldMap);
    public final FeatureField radarVehicle = PermissionProperties.createFeatureField(Feature.Radar.Vehicle, this.fieldMap);
    public final FeatureField radarWaypoint = PermissionProperties.createFeatureField(Feature.Radar.Waypoint, this.fieldMap);

    protected PermissionProperties(String displayName, String description, boolean isOp) {
        super(displayName, description);
        this.isOp = isOp;
    }

    public boolean isOp() {
        return this.isOp;
    }

    public FeatureField getField(Feature feature) {
        return this.fieldMap.get(feature);
    }

    public void copyFrom(PermissionProperties other) {
        for (Feature feature : this.fieldMap.keySet()) {
            FeatureField otherField = other.getField(feature);
            if (otherField == null) continue;
            this.getField(feature).set(otherField.get());
        }
    }

    private static FeatureField createFeatureField(Feature feature, Map<Feature, FeatureField> map) {
        Category category = ServerCategory.valueOf(feature.getFeatureType());
        FeatureField featureField = new FeatureField(category, feature, feature.getFeatureKey());
        map.put(feature, featureField);
        return featureField;
    }

    public abstract String getOriginKey();
}

