/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.task.migrate;

import com.google.common.base.Joiner;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.Version;
import journeymap.server.Constants;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PropertiesManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseMigrate {
    protected Logger logger = LogManager.getLogger((String)"journeymap");
    protected final String legacyVersion;
    protected final String currentVersion;
    protected final File legacyConfigDir;
    protected final File currentConfigDir;

    public BaseMigrate(String legacyVersion, String currentVersion) {
        this.legacyVersion = legacyVersion;
        this.currentVersion = currentVersion;
        String legacyPath = Joiner.on((String)File.separator).join((Object)Constants.MC_DATA_DIR, (Object)Constants.JOURNEYMAP_DIR, new Object[]{"config", this.legacyVersion});
        this.legacyConfigDir = new File(legacyPath);
        this.currentConfigDir = new File(Constants.CONFIG_DIR);
    }

    public boolean isActive(Version currentVersion) {
        if (!this.currentVersion.equals(currentVersion.toMajorMinorString())) {
            return false;
        }
        if (!this.legacyConfigDir.canRead()) {
            return false;
        }
        File globalConfig = new GlobalProperties(true).getFile();
        File overworldConfig = new DimensionProperties(0, true).getFile();
        return !globalConfig.exists() || !overworldConfig.exists();
    }

    protected boolean migrateConfigs() {
        try {
            this.logger.info(String.format("Migrating server configs from %s to %s", this.legacyVersion, this.currentVersion));
            boolean errorFree = this.copyConfigFiles();
            PropertiesManager.getInstance();
            if (!errorFree) {
                this.logger.warn("MIGRATION OF CONFIG FILES DID NOT COMPLETELY SUCCEED. You should examine the results in " + this.currentConfigDir);
            }
            return true;
        }
        catch (Throwable t) {
            this.logger.error(String.format("Unexpected error migrating configs: %s", LogFormatter.toPartialString(t)));
            return false;
        }
    }

    protected boolean copyConfigFiles() throws Exception {
        AtomicBoolean errorFree = new AtomicBoolean(true);
        File currentConfigDir = new File(Constants.CONFIG_DIR);
        Files.list(this.legacyConfigDir.toPath()).forEach(legacyFile -> {
            File currentFile;
            if (legacyFile.startsWith("journeymap.server.") && legacyFile.endsWith(".config") && !(currentFile = new File(currentConfigDir, legacyFile.getFileName().toString())).exists()) {
                try {
                    Files.copy(legacyFile, currentFile.toPath(), new CopyOption[0]);
                }
                catch (Exception e) {
                    errorFree.set(false);
                    this.logger.error("Unable to copy config file: " + LogFormatter.toPartialString(e));
                }
            }
        });
        return errorFree.get();
    }
}

