/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.task.migrate;

import journeymap.common.api.feature.Feature;
import journeymap.common.log.LogFormatter;
import journeymap.common.migrate.MigrationTask;
import journeymap.server.properties.DimensionProperties;
import journeymap.server.properties.GlobalProperties;
import journeymap.server.properties.PermissionProperties;
import journeymap.server.properties.legacy.DimensionProperties55;
import journeymap.server.properties.legacy.GlobalProperties55;
import journeymap.server.properties.legacy.PermissionProperties55;
import journeymap.server.task.migrate.BaseMigrate;
import net.minecraftforge.common.DimensionManager;

public class Migrate55to56
extends BaseMigrate
implements MigrationTask {
    public Migrate55to56() {
        super("5.5", "5.6");
    }

    @Override
    public Boolean call() throws Exception {
        GlobalProperties55 legacyGlobal = new GlobalProperties55();
        boolean playerTeleport = false;
        boolean opTeleport = true;
        try {
            if (legacyGlobal.getFile().exists()) {
                GlobalProperties playerGlobal;
                legacyGlobal.load();
                playerTeleport = legacyGlobal.teleportEnabled.get();
                GlobalProperties opGlobal = new GlobalProperties(true);
                if (!opGlobal.getFile().exists()) {
                    opGlobal.useWorldId.set(legacyGlobal.useWorldId.get());
                    this.migrate(legacyGlobal, opGlobal, opTeleport);
                }
                if (!(playerGlobal = new GlobalProperties(false)).getFile().exists()) {
                    playerGlobal.useWorldId.set(legacyGlobal.useWorldId.get());
                    this.migrate(legacyGlobal, playerGlobal, playerTeleport);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error migrating " + legacyGlobal + ": " + LogFormatter.toPartialString(e));
        }
        for (Integer dim : DimensionManager.getIDs()) {
            DimensionProperties55 legacyDim = new DimensionProperties55(dim);
            try {
                DimensionProperties playerDim;
                if (!legacyDim.getFile().exists()) continue;
                legacyDim.load();
                DimensionProperties opDim = new DimensionProperties(dim, true);
                if (!opDim.getFile().exists()) {
                    opDim.enabled.set(legacyDim.enabled.get());
                    this.migrate(legacyDim, opDim, opTeleport);
                }
                if ((playerDim = new DimensionProperties(dim, false)).getFile().exists()) continue;
                playerDim.enabled.set(legacyDim.enabled.get());
                this.migrate(legacyDim, playerDim, playerTeleport);
            }
            catch (Exception e) {
                this.logger.error("Error migrating " + legacyDim + ": " + LogFormatter.toPartialString(e));
            }
        }
        return true;
    }

    public void migrate(PermissionProperties55 legacy, PermissionProperties properties, boolean teleportAllowed) {
        boolean isOp = properties.isOp();
        boolean surfaceAllowed = isOp ? legacy.opSurfaceMappingEnabled.get() : legacy.surfaceMappingEnabled.get();
        boolean topoAllowed = isOp ? legacy.opTopoMappingEnabled.get() : legacy.topoMappingEnabled.get();
        boolean caveAllowed = isOp ? legacy.opCaveMappingEnabled.get() : legacy.caveMappingEnabled.get();
        boolean radarAllowed = legacy.radarEnabled.get() != false && (isOp ? legacy.opRadarEnabled.get() : legacy.playerRadarEnabled.get()) != false;
        properties.getField(Feature.Action.Teleport).set(teleportAllowed);
        properties.getField(Feature.MapType.Day).set(surfaceAllowed);
        properties.getField(Feature.MapType.Night).set(surfaceAllowed);
        properties.getField(Feature.MapType.Topo).set(topoAllowed);
        properties.getField(Feature.MapType.Underground).set(caveAllowed);
        properties.getField(Feature.Radar.PassiveMob).set(radarAllowed && legacy.animalRadarEnabled.get() != false);
        properties.getField(Feature.Radar.HostileMob).set(radarAllowed && legacy.mobRadarEnabled.get() != false);
        properties.getField(Feature.Radar.Player).set(radarAllowed && legacy.playerRadarEnabled.get() != false);
        properties.getField(Feature.Radar.NPC).set(radarAllowed && legacy.villagerRadarEnabled.get() != false);
        properties.save();
    }
}

