/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import gnu.trove.map.TObjectLongMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.beans.ConstructorProperties;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.texture.ICTMTexture;
import team.chisel.ctm.api.util.RenderContextList;
import team.chisel.ctm.client.asm.CTMCoreMethods;
import team.chisel.ctm.client.state.ChiselExtendedState;
import team.chisel.ctm.client.util.ProfileUtil;

public abstract class AbstractCTMBakedModel
implements IBakedModel {
    private static Cache<ModelResourceLocation, AbstractCTMBakedModel> itemcache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.SECONDS).build();
    private static Cache<State, AbstractCTMBakedModel> modelcache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).maximumSize(5000L).build();
    private static final MethodHandle _locations;
    @Nonnull
    private final IModelCTM model;
    @Nonnull
    private final IBakedModel parent;
    @Nonnull
    private final Overrides overrides = new Overrides();
    protected final ListMultimap<BlockRenderLayer, BakedQuad> genQuads = MultimapBuilder.enumKeys(BlockRenderLayer.class).arrayListValues().build();
    protected final Table<BlockRenderLayer, EnumFacing, List<BakedQuad>> faceQuads = Tables.newCustomTable((Map)Maps.newEnumMap(BlockRenderLayer.class), () -> Maps.newEnumMap(EnumFacing.class));
    public static final Map<ItemCameraTransforms.TransformType, TRSRTransformation> TRANSFORMS;
    public static final TRSRTransformation DEFAULT_TRANSFORM;
    protected static final BlockRenderLayer[] LAYERS;

    public static void invalidateCaches() {
        itemcache.invalidateAll();
        modelcache.invalidateAll();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (CTMCoreMethods.renderingDamageModel.get().booleanValue()) {
            return this.parent.func_188616_a(state, side, rand);
        }
        IBakedModel parent = this.getParent(rand);
        ProfileUtil.start("chisel_models");
        AbstractCTMBakedModel baked = this;
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (Minecraft.func_71410_x().field_71441_e != null && state instanceof ChiselExtendedState) {
            ProfileUtil.start("state_creation");
            ChiselExtendedState ext = (ChiselExtendedState)state;
            RenderContextList ctxList = ext.getContextList(ext.getClean(), this.model);
            TObjectLongMap<ICTMTexture<?>> serialized = ctxList.serialized();
            ProfileUtil.endAndStart("model_creation");
            baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(ext.getClean(), serialized, parent), () -> this.createModel(state, this.model, ctxList, rand));
            ProfileUtil.end();
        } else if (state != null) {
            ProfileUtil.start("model_creation");
            baked = (AbstractCTMBakedModel)modelcache.get((Object)new State(state, null, this.getParent(rand)), () -> this.createModel(state, this.model, null, rand));
            ProfileUtil.end();
        }
        ProfileUtil.start("quad_lookup");
        List<Object> ret = side != null && layer != null ? (List)baked.faceQuads.get((Object)layer, (Object)side) : (side != null ? baked.faceQuads.column((Object)side).values().stream().flatMap(Collection::stream).collect(Collectors.toList()) : (layer != null ? baked.genQuads.get((Object)layer) : Lists.newArrayList((Iterable)baked.genQuads.values())));
        ProfileUtil.end();
        ProfileUtil.end();
        return ret;
    }

    public IBakedModel getParent(long rand) {
        if (this.getParent() instanceof WeightedBakedModel) {
            return ((WeightedBakedModel)this.parent).func_188627_a(rand);
        }
        return this.getParent();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.model.getDefaultFace().getParticle();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)this, (Object)TRANSFORMS.getOrDefault(cameraTransformType, DEFAULT_TRANSFORM).getMatrix());
    }

    protected abstract AbstractCTMBakedModel createModel(IBlockState var1, @Nonnull IModelCTM var2, RenderContextList var3, long var4);

    @ConstructorProperties(value={"model", "parent"})
    public AbstractCTMBakedModel(@Nonnull IModelCTM model, @Nonnull IBakedModel parent) {
        if (model == null) {
            throw new NullPointerException("model");
        }
        if (parent == null) {
            throw new NullPointerException("parent");
        }
        this.model = model;
        this.parent = parent;
    }

    @Nonnull
    public IModelCTM getModel() {
        return this.model;
    }

    @Nonnull
    public IBakedModel getParent() {
        return this.parent;
    }

    static {
        try {
            _locations = MethodHandles.lookup().unreflectGetter(ReflectionHelper.findField(ItemModelMesherForge.class, (String[])new String[]{"locations"}));
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        TRANSFORMS = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 30.0f, 45.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)AbstractCTMBakedModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f)).build();
        DEFAULT_TRANSFORM = AbstractCTMBakedModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        LAYERS = BlockRenderLayer.values();
    }

    private static class State {
        private final IBlockState cleanState;
        private final TObjectLongMap<ICTMTexture<?>> serializedContext;
        private final IBakedModel parent;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.cleanState != other.cleanState) {
                return false;
            }
            if (this.parent != other.parent) {
                return false;
            }
            return !(this.serializedContext == null ? other.serializedContext != null : !this.serializedContext.equals(other.serializedContext));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cleanState == null ? 0 : this.cleanState.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.serializedContext == null ? 0 : this.serializedContext.hashCode());
            return result;
        }

        public IBlockState getCleanState() {
            return this.cleanState;
        }

        public TObjectLongMap<ICTMTexture<?>> getSerializedContext() {
            return this.serializedContext;
        }

        public IBakedModel getParent() {
            return this.parent;
        }

        @ConstructorProperties(value={"cleanState", "serializedContext", "parent"})
        public State(IBlockState cleanState, TObjectLongMap<ICTMTexture<?>> serializedContext, IBakedModel parent) {
            this.cleanState = cleanState;
            this.serializedContext = serializedContext;
            this.parent = parent;
        }

        public String toString() {
            return "AbstractCTMBakedModel.State(cleanState=" + this.getCleanState() + ", serializedContext=" + this.getSerializedContext() + ", parent=" + this.getParent() + ")";
        }
    }

    @ParametersAreNonnullByDefault
    private class Overrides
    extends ItemOverrideList {
        public Overrides() {
            super((List)Lists.newArrayList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Block block = null;
            if (stack.func_77973_b() instanceof ItemBlock) {
                block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            }
            IBlockState state = block == null ? null : block.func_176223_P();
            ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
            ModelResourceLocation modelResourceLocation = Optional.ofNullable(_locations.invoke(mesher)).map(map -> (TIntObjectHashMap)map.get(stack.func_77973_b().delegate)).map(map -> (ModelResourceLocation)map.get(mesher.func_178084_b(stack))).orElse(null);
            if (modelResourceLocation == null) {
                ItemMeshDefinition itemMeshDefinition = (ItemMeshDefinition)mesher.field_178092_c.get(stack.func_77973_b());
                modelResourceLocation = Optional.ofNullable(itemMeshDefinition).map(mesh -> mesh.func_178113_a(stack)).orElse(null);
            }
            if (modelResourceLocation == null) {
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            return (IBakedModel)itemcache.get((Object)modelResourceLocation, () -> AbstractCTMBakedModel.this.createModel(state, AbstractCTMBakedModel.this.model, null, 0L));
        }
    }
}

