/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.impl;

import mcp.mobius.waila.api.IWailaCommonAccessor;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.utils.NBTUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class DataAccessorCommon
implements IWailaCommonAccessor,
IWailaDataAccessor,
IWailaEntityAccessor {
    public static DataAccessorCommon instance = new DataAccessorCommon();
    public World world;
    public EntityPlayer player;
    public RayTraceResult mop;
    public Vec3d renderingvec = null;
    public Block block = Blocks.field_150350_a;
    public IBlockState state = Blocks.field_150350_a.func_176223_P();
    public BlockPos pos = BlockPos.field_177992_a;
    public int blockID = -1;
    public String blockResource = Blocks.field_150350_a.getRegistryName().toString();
    public int metadata = -1;
    public TileEntity tileEntity;
    public Entity entity;
    public NBTTagCompound remoteNbt = null;
    public long timeLastUpdate = System.currentTimeMillis();
    public double partialFrame;
    public ItemStack stack = ItemStack.field_190927_a;

    public void set(World _world, EntityPlayer _player, RayTraceResult _mop) {
        this.set(_world, _player, _mop, null, 0.0);
    }

    public void set(World _world, EntityPlayer _player, RayTraceResult _mop, Entity viewEntity, double partialTicks) {
        this.world = _world;
        this.player = _player;
        this.mop = _mop;
        if (this.mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.pos = _mop.func_178782_a();
            this.state = this.world.func_180495_p(this.pos);
            this.block = this.state.func_177230_c();
            this.metadata = this.state.func_177230_c().func_176201_c(this.state);
            this.tileEntity = this.world.func_175625_s(this.pos);
            this.entity = null;
            this.blockID = Block.func_149682_b((Block)this.block);
            this.blockResource = this.block.getRegistryName().toString();
            Item itemBlock = Item.func_150898_a((Block)this.block);
            this.stack = itemBlock != Items.field_190931_a ? new ItemStack(this.block, 1, this.metadata) : ItemStack.field_190927_a;
        } else if (this.mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.pos = new BlockPos(_mop.field_72308_g);
            this.state = Blocks.field_150350_a.func_176223_P();
            this.block = Blocks.field_150350_a;
            this.blockID = -1;
            this.metadata = -1;
            this.tileEntity = null;
            this.stack = ItemStack.field_190927_a;
            this.entity = _mop.field_72308_g;
        }
        if (viewEntity != null) {
            double px = viewEntity.field_70142_S + (viewEntity.field_70165_t - viewEntity.field_70142_S) * partialTicks;
            double py = viewEntity.field_70137_T + (viewEntity.field_70163_u - viewEntity.field_70137_T) * partialTicks;
            double pz = viewEntity.field_70136_U + (viewEntity.field_70161_v - viewEntity.field_70136_U) * partialTicks;
            this.renderingvec = new Vec3d((double)this.pos.func_177958_n() - px, (double)this.pos.func_177956_o() - py, (double)this.pos.func_177952_p() - pz);
            this.partialFrame = partialTicks;
        }
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public int getBlockID() {
        return this.blockID;
    }

    @Override
    public int getMetadata() {
        return this.metadata;
    }

    @Override
    public IBlockState getBlockState() {
        return this.state;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    public RayTraceResult getMOP() {
        return this.mop;
    }

    @Override
    public Vec3d getRenderingPosition() {
        return this.renderingvec;
    }

    @Override
    public NBTTagCompound getNBTData() {
        if (this.tileEntity != null && this.isTagCorrectTileEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.entity != null && this.isTagCorrectEntity(this.remoteNbt)) {
            return this.remoteNbt;
        }
        if (this.tileEntity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            try {
                this.tileEntity.func_189515_b(tag);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return tag;
        }
        if (this.entity != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.entity.func_189511_e(tag);
            return tag;
        }
        return new NBTTagCompound();
    }

    public void setNBTData(NBTTagCompound tag) {
        this.remoteNbt = tag;
    }

    private boolean isTagCorrectTileEntity(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("WailaX")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int x = tag.func_74762_e("WailaX");
        int y = tag.func_74762_e("WailaY");
        int z = tag.func_74762_e("WailaZ");
        if (x == this.mop.func_178782_a().func_177958_n() && y == this.mop.func_178782_a().func_177956_o() && z == this.mop.func_178782_a().func_177952_p()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    private boolean isTagCorrectEntity(NBTTagCompound tag) {
        if (tag == null || !tag.func_74764_b("WailaEntityID")) {
            this.timeLastUpdate = System.currentTimeMillis() - 250L;
            return false;
        }
        int id = tag.func_74762_e("WailaEntityID");
        if (id == this.entity.func_145782_y()) {
            return true;
        }
        this.timeLastUpdate = System.currentTimeMillis() - 250L;
        return false;
    }

    @Override
    public int getNBTInteger(NBTTagCompound tag, String keyname) {
        return NBTUtil.getNBTInteger(tag, keyname);
    }

    @Override
    public double getPartialFrame() {
        return this.partialFrame;
    }

    @Override
    public EnumFacing getSide() {
        return this.getMOP().field_178784_b;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isTimeElapsed(long time) {
        return System.currentTimeMillis() - this.timeLastUpdate >= time;
    }

    public void resetTimer() {
        this.timeLastUpdate = System.currentTimeMillis();
    }

    @Override
    public String getBlockQualifiedName() {
        return this.blockResource;
    }
}

